/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.SpringLayout;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJToggleButton;
import tianyuan.games.gui.goe.goeroom.BoardView;
import tianyuan.games.gui.goe.goeroom.GoCommandPane;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.qp.AnalysisReportDisplay;

class SeeGameCommandPane
extends GoCommandPane {
    AbstractButton[] button1 = new AbstractButton[6];
    AbstractButton[] button2 = new AbstractButton[5];
    protected GoeRoom guiRoom;
    private AnalysisReportDisplay analysis;
    protected SizeListener seeSize = new SizeListener();

    SeeGameCommandPane() {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
    }

    SeeGameCommandPane(GoeRoom goeRoom) {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
        this.setGoeRoom(goeRoom);
    }

    public void setGoeRoom(GoeRoom goeRoom) {
        int n;
        this.guiRoom = goeRoom;
        this.revalidate();
        for (n = 0; n < this.button1.length; ++n) {
            this.button1[n].setEnabled(true);
        }
        for (n = 0; n < this.button2.length; ++n) {
            this.button2[n].setEnabled(true);
        }
        this.boardView.setBoard(goeRoom.board);
    }

    private void createButton() {
        this.button1[0] = new MyJButton("|<");
        this.button1[1] = new MyJButton("<<");
        this.button1[2] = new MyJButton("<\uff0d");
        this.button1[3] = new MyJButton("\uff0d>");
        this.button1[4] = new MyJButton(">>");
        this.button1[5] = new MyJButton(">|");
        this.button2[0] = new MyJToggleButton(Global.lang.getKey("120_test"));
        this.button2[3] = new MyJToggleButton(Global.lang.getKey("120_analyze"));
        this.boardView = new BoardView(null);
        this.button2[1] = this.boardView;
        this.button2[2] = new MyJToggleButton(Global.lang.getKey("120_quiet"));
        this.button2[4] = new MyJButton(Global.lang.getKey("120_exit"));
        this.button1[0].addActionListener(new B10Listener());
        this.button1[1].addActionListener(new B11Listener());
        this.button1[2].addActionListener(new B12Listener());
        this.button1[3].addActionListener(new B13Listener());
        this.button1[4].addActionListener(new B14Listener());
        this.button1[5].addActionListener(new B15Listener());
        this.button2[0].addItemListener(new TestListener());
        this.button2[3].addItemListener(new AnalysisListener());
        this.button2[2].addItemListener(new QuietListener());
        this.button2[4].addActionListener(new QuitRoomListener());
    }

    @Override
    protected void resetLayout() {
        int n;
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n2 = (dimension.width - 6) / 6;
        int n3 = (dimension.width - 10) / 5;
        int n4 = (dimension.height - 24) / 2;
        for (n = 0; n < this.button1.length; ++n) {
            this.addComp(this.button1[n], dimension.width / 6 * n + 2, 0, n2, n4);
        }
        for (n = 0; n < this.button2.length; ++n) {
            this.addComp(this.button2[n], dimension.width / 5 * n + 2, n4 + 4, n3, n4);
        }
    }

    protected class SizeListener
    extends ComponentAdapter {
        protected SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            SeeGameCommandPane.this.resetLayout();
        }
    }

    class AnalysisListener
    implements ItemListener {
        AnalysisListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            int n = itemEvent.getStateChange();
            if (n == 1) {
                SeeGameCommandPane.this.button2[0].setEnabled(false);
                SeeGameCommandPane.this.guiRoom.enterAnalysisMode();
            } else {
                SeeGameCommandPane.this.button2[0].setEnabled(true);
                SeeGameCommandPane.this.guiRoom.quitAnalysisMode();
            }
        }
    }

    class TestListener
    implements ItemListener {
        TestListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            int n = itemEvent.getStateChange();
            if (n == 1) {
                SeeGameCommandPane.this.guiRoom.board.enterTestModeForSeeGame();
                for (int i = 0; i < SeeGameCommandPane.this.button1.length; ++i) {
                    SeeGameCommandPane.this.button1[i].setEnabled(false);
                }
            } else {
                SeeGameCommandPane.this.guiRoom.board.quitTestModeForSeeGame();
                for (int i = 0; i < SeeGameCommandPane.this.button1.length; ++i) {
                    SeeGameCommandPane.this.button1[i].setEnabled(true);
                }
            }
        }
    }

    class QuitRoomListener
    implements ActionListener {
        QuitRoomListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            Global.netDaemon.quitRoom(SeeGameCommandPane.this.guiRoom.coreData.roomNumber);
            Global.goRootPane.removeGoeRoom(SeeGameCommandPane.this.guiRoom);
            SeeGameCommandPane.this.guiRoom.closeRoom();
            Global.goRoomPanel.removeGoeRoom(SeeGameCommandPane.this.guiRoom);
        }
    }

    class QuietListener
    implements ItemListener {
        QuietListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                SeeGameCommandPane.this.guiRoom.board.setSound(false);
                SeeGameCommandPane.this.guiRoom.clock.setSound(false);
            } else {
                SeeGameCommandPane.this.guiRoom.board.setSound(true);
                SeeGameCommandPane.this.guiRoom.clock.setSound(true);
            }
        }
    }

    class B15Listener
    implements ActionListener {
        B15Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToLast();
        }
    }

    class B14Listener
    implements ActionListener {
        B14Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToNextFive();
        }
    }

    class B13Listener
    implements ActionListener {
        B13Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToNextOne();
        }
    }

    class B12Listener
    implements ActionListener {
        B12Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToPrevOne();
        }
    }

    class B11Listener
    implements ActionListener {
        B11Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToPrevFive();
        }
    }

    class B10Listener
    implements ActionListener {
        B10Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SeeGameCommandPane.this.guiRoom == null) {
                return;
            }
            SeeGameCommandPane.this.guiRoom.board.seeGameGoToFirst();
        }
    }
}

