/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.phoenix.util.MyProperties;
import org.phoenix.util.RwProperties;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoGamblingOneUserInfo;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.editor.GoEditorBoard;
import tianyuan.games.gui.goe.editor.GoEditorInterface;
import tianyuan.games.gui.goe.editor.GoEditorMap;
import tianyuan.games.gui.goe.editor.GoEditorTextInfo;
import tianyuan.games.gui.goe.editor.GoEditorToolBar;
import tianyuan.games.gui.goe.editor.maptree.MapTree;
import tianyuan.games.gui.goe.editor.maptree.MapTreeModel;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.ComputeGameResultCommandPane;
import tianyuan.games.gui.goe.goeroom.GoBoardPane;
import tianyuan.games.gui.goe.goeroom.GoClockPane;
import tianyuan.games.gui.goe.goeroom.GoGamblingInfoPane;
import tianyuan.games.gui.goe.goeroom.InGameCommandPanel;
import tianyuan.games.gui.goe.goeroom.NetInGameControl;
import tianyuan.games.gui.goe.goeroom.NetSeeGameControl;
import tianyuan.games.gui.goe.goeroom.NetStudyGameControl;
import tianyuan.games.gui.goe.goeroom.SeeGameCommandPane;
import tianyuan.games.gui.goe.goeroom.StudyGameCommandPane;
import tianyuan.games.gui.goe.goeroom.qp.AnalysisReportDisplay;
import tianyuan.games.gui.goe.goeroom.qp.BoardMouseAdapter;
import tianyuan.games.gui.goe.goeroom.qp.Cvs2QiPan;
import tianyuan.games.gui.goe.goeroom.qp.CvsQiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiPanPosition;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;
import tianyuan.games.gui.goe.hall.GoeRoomBbs;
import tianyuan.games.gui.goe.hall.TabbedInfoPane;
import tianyuan.games.gui.goe.hall.UserGoInfoPane;
import tianyuan.games.gui.goe.hall.UserGoInfoPane2;
import tianyuan.games.gui.goe.table.GameReferenceTable;
import tianyuan.games.gui.goe.table.GoeRoomMemberList;
import tianyuan.games.net.ServerMessage;

public class GoeRoom
extends JPanel {
    NetInGameControl inControl = new NetInGameControl();
    NetSeeGameControl seeControl = new NetSeeGameControl();
    GoBoardPane board = new GoBoardPane();
    GoClockPane clock = new GoClockPane(this);
    public GoeRoomMemberList memberList = new GoeRoomMemberList(this);
    public GoeRoomBbs chat = new GoeRoomBbs(this);
    TabbedInfoPane tabbedInfoPane = new TabbedInfoPane();
    GoGamblingInfoPane gamblingPane;
    SeeGameCommandPane seeGameCommand = new SeeGameCommandPane(this);
    InGameCommandPanel inGameCommand = new InGameCommandPanel(this);
    ComputeGameResultCommandPane computeCommand = new ComputeGameResultCommandPane(this);
    JPanel commandContainer = new JPanel();
    StudyGameCommandPane studyGameCommand = new StudyGameCommandPane();
    NetStudyGameControl studyControl = new NetStudyGameControl();
    GameStudyPane studyPane = new GameStudyPane();
    GameReferenceTable studyReferenceTable = new GameReferenceTable();
    AnalysisReportDisplay analysisReportDisplay;
    private JSplitPane right;
    protected JPanel rightPane = new JPanel();
    public GoRoom coreData;
    private SizeListener seeSize = new SizeListener();

    public GoeRoom(GoRoom goRoom) {
        this.coreData = goRoom;
        this.chat.roomNumber = goRoom.roomNumber;
        this.gamblingPane = new GoGamblingInfoPane(goRoom.roomNumber, goRoom.gamblingInfo);
        this.gamblingPane.setEnabled(false);
        this.addComponentListener(this.seeSize);
        this.tabbedInfoPane.add(Global.lang.getKey("110_room_chat"), this.chat);
        this.tabbedInfoPane.add(Global.lang.getKey("307_gambling_info"), this.gamblingPane);
        this.right = new JSplitPane(0, this.memberList, this.tabbedInfoPane);
        this.right.setOneTouchExpandable(true);
        this.right.addComponentListener(new RightSizeListener());
        this.rightPane.add(this.clock);
        this.rightPane.add(this.right);
        this.commandContainer.add(this.seeGameCommand);
        this.rightPane.add(this.commandContainer);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
        for (UserAllInfo userAllInfo : goRoom.userinfos) {
            this.memberList.add(userAllInfo.info, userAllInfo.tmpInfo);
        }
    }

    public void gamblingAddMoney(GoGamblingOneUserInfo goGamblingOneUserInfo, boolean bl) {
        this.gamblingPane.add(goGamblingOneUserInfo, bl);
    }

    public void gamblingGameInfo(GoGamblingGameInfo goGamblingGameInfo) {
        this.gamblingPane.setInfo(goGamblingGameInfo);
    }

    public int getRoomNumber() {
        return this.coreData.roomNumber;
    }

    public void displayMessage(ServerMessage serverMessage) {
        this.chat.displayMessageWithTimeStamp(serverMessage);
    }

    public void displayMessage(String string) {
        this.chat.displayMessageWithTimeStamp(null, string);
    }

    public String getNameWithLevel(String string) {
        if (this.coreData == null) {
            return string;
        }
        return this.coreData.getNameWithLevel(string, Global.lang);
    }

    public void goIn(UserAllInfo userAllInfo) {
        this.memberList.add(userAllInfo.info, userAllInfo.tmpInfo);
        if (this.coreData.isRunner(userAllInfo.info.userName)) {
            this.clock.clock.recoverFromBreakLine();
        }
    }

    public void goOut(String string) {
        this.memberList.del(string);
    }

    public void memberBreakLine(String string) {
        if (!this.coreData.isRunner(string)) {
            return;
        }
        if (string.equals(this.coreData.black)) {
            this.clock.clock.setTimeFlag(3);
        } else if (string.equals(this.coreData.white)) {
            this.clock.clock.setTimeFlag(4);
        }
    }

    public void memberBreakLineTimeOut(String string) {
        if (!this.coreData.isRunner(string)) {
            return;
        }
    }

    public void modify(UserAllInfo userAllInfo) {
        this.memberList.modify(userAllInfo);
    }

    public void closeRoom() {
        if (this.clock.clock != null) {
            this.clock.clock.setStop();
        }
    }

    public void beginGame(GoGameRecord goGameRecord) {
        this.clear();
        this.coreData.setGameRecord(goGameRecord);
        if (Global.myUserInfo.userName.equals(goGameRecord.black) || Global.myUserInfo.userName.equals(goGameRecord.white)) {
            this.inControl.set(this);
        } else {
            this.seeControl.set(this);
        }
        this.chat.displayMessageNoChangeLine(this.chat.display.grayBold, " " + Global.lang.getKey("132_game_begin"));
        this.chat.displayMessage(this.chat.display.grayBold, " ### " + new Time(goGameRecord.beginTime).toString());
    }

    public void beginStudyGame() {
        this.coreData.status.setValue((byte)8);
        this.chat.displayMessageNoChangeLine(this.chat.display.blueBold, " *** " + Global.lang.getKey("301_begin_study"));
        this.studyControl.set(this);
        this.studyPane.treeMap.setTreeModel(this.getQiPu().getTreeModel());
        this.remove(0);
        this.add((Component)this.studyPane.studyBoard, 0);
        this.setStudyBoardMouse();
    }

    private void setStudyBoardMouse() {
        MouseListener[] mouseListenerArray = this.studyPane.studyBoard.getMouseListeners();
        boolean bl = false;
        if (mouseListenerArray != null) {
            for (MouseListener mouseListener : mouseListenerArray) {
                if (!(mouseListener instanceof GoStudyEditorMouseAdapter)) continue;
                bl = true;
            }
        }
        if (!bl) {
            GoStudyEditorMouseAdapter goStudyEditorMouseAdapter = new GoStudyEditorMouseAdapter(this.studyPane.studyBoard);
            this.studyPane.studyBoard.addMouseListener(goStudyEditorMouseAdapter);
            goStudyEditorMouseAdapter.setBoard(this.studyPane.studyBoard);
            goStudyEditorMouseAdapter.setToolBar(this.studyPane.toolBar);
            goStudyEditorMouseAdapter.setTreeMap(this.studyPane.treeMap);
            goStudyEditorMouseAdapter.setGoEditorInterface(this.studyPane.studyEditorControl);
        }
    }

    public void endStudyGame() {
        this.coreData.status.setValue((byte)3);
        this.chat.displayMessage(this.chat.display.blueBold, " *** " + Global.lang.getKey("301_end_study"));
        this.setSeeGameCommandPane();
        this.remove(0);
        this.add((Component)this.board, 0);
        if (Global.netDaemon != null) {
            Global.netDaemon.exitStudyRoomStatus(this.getRoomNumber());
        }
    }

    public void studyRefPublish(int n, int n2, QiPu qiPu, String string, int n3) {
    }

    public void studyRefDelete(int n, String string) {
    }

    public void oneUserExitStudyRoomStatus(String string) {
        this.chat.displayMessageWithTimeStamp(this.chat.display.blueBold, " *** " + string + " " + Global.lang.getKey("303_exit_study_status"));
    }

    public void agreeStudyGame(String string) {
        this.chat.displayMessageWithTimeStamp(this.chat.display.blueBold, " *** " + string + " " + Global.lang.getKey("301_agree_study"));
    }

    public void refuseStudyGame(String string) {
        this.chat.displayMessageWithTimeStamp(this.chat.display.redBold, " *** " + string + " " + Global.lang.getKey("301_refuse_study"));
    }

    public void clear() {
        this.coreData.record = null;
        this.clock.clear();
        if (this.clock.clock != null) {
            this.clock.clock.setStop();
        }
        this.board.clear();
        this.gamblingPane.clear();
    }

    public void appendRecordQiZi(GoRecordQiZi goRecordQiZi, boolean bl) {
        this.coreData.record.mem.add(goRecordQiZi);
        if (this.coreData.isRunner(Global.myName())) {
            this.inControl.setRecordQiZiFromNet(goRecordQiZi);
        } else {
            this.seeControl.setRecordQiZi(goRecordQiZi);
        }
    }

    public void addInfoPane(UserGoInfoPane userGoInfoPane) {
        this.tabbedInfoPane.addInfoPane(userGoInfoPane);
    }

    public void addInfoPane(UserGoInfoPane2 userGoInfoPane2) {
        this.tabbedInfoPane.addInfoPane(userGoInfoPane2);
    }

    private QiPu getQiPu() {
        return GoeRoom.getQiPu(this.board, this.coreData);
    }

    private static QiPu getQiPu(Cvs2QiPan cvs2QiPan, GoRoom goRoom) {
        QiPu qiPu = new QiPu(cvs2QiPan.getData());
        String string = goRoom.blackNameWithLevel2(Global.lang) + " vs " + goRoom.whiteNameWithLevel2(Global.lang);
        qiPu.setTitle(string);
        long l = System.currentTimeMillis();
        String string2 = " " + GoeRoom.toDateStr(l);
        qiPu.setExplain(string2);
        return qiPu;
    }

    private static String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    public void enterAnalysisMode() {
        this.analysisReportDisplay = new AnalysisReportDisplay();
        this.board.enterAnalysisMode(this.analysisReportDisplay);
        this.analysisReportDisplay.setReport(this.board.getAnalysisQiPan().getAnalysisReport());
        this.tabbedInfoPane.add(Global.lang.getKey("120_analyze"), this.analysisReportDisplay);
        this.tabbedInfoPane.setSelectedComponent(this.analysisReportDisplay);
    }

    public void quitAnalysisMode() {
        this.board.quitAnalysisMode();
        this.tabbedInfoPane.removeAnalysisReportDisplay(this.analysisReportDisplay);
    }

    private void setRightSize() {
        this.right.setDividerLocation(0.4);
        this.right.revalidate();
    }

    protected void layoutRightPane() {
    }

    protected void setStudyGameCommandPane() {
        this.commandContainer.remove(this.seeGameCommand);
        this.commandContainer.remove(this.inGameCommand);
        this.commandContainer.add(this.studyGameCommand);
        this.setAllSize();
        this.right.setDividerLocation(0);
        this.tabbedInfoPane.add(Global.lang.getKey("304_qipu_tree"), this.studyPane);
        this.tabbedInfoPane.add(Global.lang.getKey("304_reference"), this.studyReferenceTable);
        this.rightPane.revalidate();
        this.rightPane.validate();
        this.commandContainer.revalidate();
        this.commandContainer.validate();
        this.commandContainer.repaint();
        this.studyGameCommand.repaint();
    }

    protected void setComputeCommandPane() {
        this.commandContainer.remove(this.inGameCommand);
        this.commandContainer.remove(this.studyGameCommand);
        this.commandContainer.remove(this.seeGameCommand);
        this.commandContainer.add(this.computeCommand);
        this.tabbedInfoPane.remove(this.studyPane);
        this.tabbedInfoPane.remove(this.studyReferenceTable);
        this.setAllSizeForCompute();
        this.rightPane.revalidate();
        this.rightPane.validate();
        this.commandContainer.revalidate();
        this.commandContainer.validate();
        this.commandContainer.repaint();
        this.computeCommand.repaint();
    }

    protected void setInGameCommandPane() {
        this.commandContainer.remove(this.seeGameCommand);
        this.commandContainer.remove(this.computeCommand);
        this.commandContainer.remove(this.studyGameCommand);
        this.commandContainer.add(this.inGameCommand);
        this.tabbedInfoPane.remove(this.studyPane);
        this.tabbedInfoPane.remove(this.studyReferenceTable);
        this.setAllSize();
        this.rightPane.revalidate();
        this.rightPane.validate();
        this.commandContainer.revalidate();
        this.commandContainer.validate();
        this.commandContainer.repaint();
        this.inGameCommand.repaint();
    }

    protected void setSeeGameCommandPane() {
        this.commandContainer.remove(this.inGameCommand);
        this.commandContainer.remove(this.studyGameCommand);
        this.commandContainer.remove(this.computeCommand);
        this.commandContainer.add(this.seeGameCommand);
        this.tabbedInfoPane.remove(this.studyPane);
        this.tabbedInfoPane.remove(this.studyReferenceTable);
        this.setAllSize();
        this.rightPane.revalidate();
        this.rightPane.validate();
        this.commandContainer.revalidate();
        this.commandContainer.validate();
        this.commandContainer.repaint();
    }

    protected void setAllSize() {
        Dimension dimension = this.getSize();
        GoeRoom.limitSize(this.board, new Dimension(dimension.height - 1, dimension.height - 1));
        if (this.studyPane != null && this.studyPane.studyBoard != null) {
            GoeRoom.limitSize(this.studyPane.studyBoard, new Dimension(dimension.height - 1, dimension.height - 1));
        }
        GoeRoom.limitSize(this.rightPane, new Dimension(dimension.width - dimension.height + 1, dimension.height));
        GoeRoom.limitSize(this.clock, new Dimension(dimension.width - dimension.height + 1, dimension.height / 6));
        GoeRoom.limitSize(this.right, new Dimension(dimension.width - dimension.height + 1, dimension.height * 17 / 24));
        GoeRoom.limitSize(this.seeGameCommand, new Dimension(dimension.width - dimension.height - 1, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.studyGameCommand, new Dimension(dimension.width - dimension.height - 1, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.inGameCommand, new Dimension(dimension.width - dimension.height - 1, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.computeCommand, new Dimension(dimension.width - dimension.height - 1, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.commandContainer, new Dimension(dimension.width - dimension.height + 1, dimension.height / 8));
        this.right.setDividerLocation(0.4);
        this.validate();
        this.revalidate();
    }

    protected void setAllSizeForCompute() {
        Dimension dimension = this.getSize();
        GoeRoom.limitSize(this.board, new Dimension(dimension.height - 1, dimension.height - 1));
        GoeRoom.limitSize(this.rightPane, new Dimension(dimension.width - dimension.height, dimension.height));
        GoeRoom.limitSize(this.clock, new Dimension(dimension.width - dimension.height, dimension.height / 6));
        GoeRoom.limitSize(this.right, new Dimension(dimension.width - dimension.height, dimension.height * 17 / 24));
        GoeRoom.limitSize(this.seeGameCommand, new Dimension(dimension.width - dimension.height - 2, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.studyGameCommand, new Dimension(dimension.width - dimension.height - 2, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.inGameCommand, new Dimension(dimension.width - dimension.height - 2, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.computeCommand, new Dimension(dimension.width - dimension.height - 2, dimension.height / 8 - 6));
        GoeRoom.limitSize(this.commandContainer, new Dimension(dimension.width - dimension.height + 1, dimension.height / 8));
        this.right.setDividerLocation(0.4);
        this.invalidate();
        this.validate();
    }

    private static void limitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeRoom.this.setAllSize();
        }
    }

    private class RightSizeListener
    extends ComponentAdapter {
        private RightSizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeRoom.this.setRightSize();
        }
    }

    class GoStudyEditorMouseAdapter
    extends BoardMouseAdapter {
        boolean editEnabledFlag;
        private GoEditorBoard board;
        private GoEditorToolBar toolBar;
        private GoEditorMap treeMap;
        private GoEditorInterface geif;

        GoStudyEditorMouseAdapter(CvsQiPan cvsQiPan) {
            super(cvsQiPan);
            this.editEnabledFlag = true;
        }

        @Override
        public void handleClick(MouseEvent mouseEvent) {
            if (!this.editEnabledFlag) {
                return;
            }
            QiPanPosition qiPanPosition = this.board.getPosition(mouseEvent.getX(), mouseEvent.getY());
            if (qiPanPosition == null) {
                return;
            }
            QiZi qiZi = this.board.setPositionAndStatus(qiPanPosition, this.toolBar.getToolBarStatus());
            if (qiZi != null) {
                this.treeMap.insert(qiZi);
                this.geif.setNewDataUnSaveFlag(true);
            }
        }

        public void setBoard(GoEditorBoard goEditorBoard) {
            this.board = goEditorBoard;
        }

        public void setToolBar(GoEditorToolBar goEditorToolBar) {
            this.toolBar = goEditorToolBar;
        }

        public void setTreeMap(GoEditorMap goEditorMap) {
            this.treeMap = goEditorMap;
        }

        public void setGoEditorInterface(GoEditorInterface goEditorInterface) {
            this.geif = goEditorInterface;
        }

        public void clear() {
        }
    }

    class GameStudyPane
    extends JPanel {
        InnerSizeListener seeSize = new InnerSizeListener();
        private JScrollPane sp;
        GoEditorToolBar toolBar = new GoEditorToolBar();
        GameStudyEditorControl studyEditorControl;
        GoEditorMap treeMap;
        GoEditorTextInfo textInfo;
        JSplitPane split;
        GoEditorBoard studyBoard;

        GameStudyPane() {
            this.studyEditorControl = new GameStudyEditorControl();
            this.treeMap = new GoEditorMap(this.studyEditorControl, this.studyEditorControl);
            this.textInfo = new GoEditorTextInfo(this.studyEditorControl);
            this.split = new JSplitPane(0, this.textInfo, this.treeMap);
            this.studyBoard = new GoEditorBoard(this.studyEditorControl);
            this.studyEditorControl.setParamter(this.treeMap, this.toolBar, this.textInfo, this.studyBoard);
            this.addComponentListener(this.seeSize);
            this.setLayout(new BorderLayout());
            this.sp = new JScrollPane(this.toolBar);
            this.sp.setVerticalScrollBarPolicy(21);
            this.split.setDividerLocation(0.35);
            this.add((Component)this.sp, "North");
            this.add((Component)this.split, "Center");
        }

        protected void setCompSize() {
            Dimension dimension = this.getSize();
            this.limitSize(this.sp, new Dimension(dimension.width - 1, 47));
            this.limitSize(this.split, new Dimension(dimension.width - 1, dimension.height - 47));
            this.split.setDividerLocation(0.35);
            this.validate();
            this.revalidate();
        }

        private void limitSize(JComponent jComponent, Dimension dimension) {
            jComponent.setPreferredSize(dimension);
        }

        private class InnerSizeListener
        extends ComponentAdapter {
            private InnerSizeListener() {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GameStudyPane.this.setCompSize();
            }
        }
    }

    class GameStudyEditorControl
    implements GoEditorInterface,
    TreeSelectionListener {
        MapTree treeMap;
        GoEditorToolBar toolBar;
        GoEditorBoard board;
        GoEditorTextInfo textInfo;
        private TreePath beSelectedPath = null;

        GameStudyEditorControl() {
        }

        void setParamter(MapTree mapTree, GoEditorToolBar goEditorToolBar, GoEditorTextInfo goEditorTextInfo, GoEditorBoard goEditorBoard) {
            this.treeMap = mapTree;
            this.toolBar = goEditorToolBar;
            this.textInfo = goEditorTextInfo;
            this.board = goEditorBoard;
        }

        @Override
        public void setBlackFlag(boolean bl) {
        }

        @Override
        public void insertSubTree() {
            this.treeMap.insertSubTree();
        }

        @Override
        public void removeSubTree() {
            this.treeMap.removeSubTree();
        }

        @Override
        public void setNewDataUnSaveFlag(boolean bl) {
        }

        @Override
        public MyProperties getLang() {
            return Global.lang;
        }

        @Override
        public RwProperties getParamter() {
            return Global.paramter;
        }

        @Override
        public void setPath(TreePath treePath, MapTreeModel mapTreeModel) {
            this.board.setPath(treePath, mapTreeModel);
        }

        @Override
        public void removeMark(int n, int n2) {
            this.treeMap.removeMark(n, n2);
        }

        @Override
        public void removeQiZi(QiZi qiZi) {
            this.treeMap.removeQiZi(qiZi);
        }

        @Override
        public int getCount() {
            return this.toolBar.getCount();
        }

        @Override
        public void addCount() {
            this.toolBar.addCount();
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            String string;
            if (this.treeMap == null) {
                System.out.println("treeMap is null ");
            }
            if (this.textInfo == null) {
                System.out.println("textInfo is null ");
            }
            if ((string = this.treeMap.valueChanged(treeSelectionEvent, this.textInfo.getExplain())) != null || string.length() > 0) {
                this.textInfo.setExplain(string);
            }
            TreePath treePath = treeSelectionEvent.getPath();
            boolean bl = true;
            if (treePath != null && this.beSelectedPath != null) {
                if (treePath.equals(this.beSelectedPath)) {
                    bl = false;
                }
            } else if (treePath == null) {
                bl = false;
            }
            if (bl && treePath.getPathCount() > 0) {
                this.board.setPath(treePath, this.treeMap.getTreeModel());
            }
            this.beSelectedPath = treePath;
        }
    }
}

