/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import tianyuan.games.base.GoGameRule;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.clk.MyNewClock;
import tianyuan.games.gui.goe.goeroom.qp.Cvs2QiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;
import tianyuan.games.gui.goe.hall.GoeRoomBbs;

public class GoGameControl {
    GoeRoom guiRoom;

    public void set(GoeRoom goeRoom) {
        this.guiRoom = goeRoom;
    }

    public void setRecordQiZi(GoRecordQiZi goRecordQiZi) {
        this.setRecordQiZi(goRecordQiZi, true, this.guiRoom.board, this.guiRoom.clock.clock, this.guiRoom.chat, this.guiRoom.coreData);
        this.displayBeEatedCount();
    }

    public void goIn(UserAllInfo userAllInfo) {
        if (this.guiRoom.coreData.isRunner(userAllInfo.info.userName)) {
            this.guiRoom.clock.clock.recoverFromBreakLine();
        }
    }

    protected final void displayBeEatedCount() {
        String string = Global.lang.getKey("118_eat") + " ";
        this.guiRoom.clock.printInfo(string + this.guiRoom.board.getWhiteBeEatedCounter(), true);
        this.guiRoom.clock.printInfo(string + this.guiRoom.board.getBlackBeEatedCounter(), false);
    }

    protected final boolean isBlackFirst() {
        return this.guiRoom.coreData.record.rule.isBlackFirst();
    }

    protected final void setCurrentClockTimeFlag() {
        if (this.isBlackFirst()) {
            this.guiRoom.clock.clock.setTimeFlag(1);
        } else {
            this.guiRoom.clock.clock.setTimeFlag(2);
        }
        int n = this.guiRoom.board.getCurrentNumber();
        if (n % 2 == 1) {
            this.guiRoom.clock.clock.click();
        }
    }

    protected void setGoGameRecord() {
        for (GoRecordQiZi goRecordQiZi : this.guiRoom.coreData.record.mem) {
            this.setRecordQiZi(goRecordQiZi, false, this.guiRoom.board, this.guiRoom.clock.clock, this.guiRoom.chat, this.guiRoom.coreData);
        }
    }

    public void setBoardFlag(Cvs2QiPan cvs2QiPan) {
        cvs2QiPan.setAllFlag(Global.paramter.getBoolean("7_displayNumber"), Global.paramter.getBoolean("7_idLastWithNumber"), Global.paramter.getBoolean("7_show3DStone"), Global.paramter.getBoolean("7_bigStone"), Global.paramter.getBoolean("7_showTarget"), Global.paramter.getBoolean("7_woodBoard"), Global.paramter.getBoolean("7_saturatedBoardColor"), Global.paramter.getBoolean("7_showCoordinate"));
    }

    protected void setRecordQiZi(GoRecordQiZi goRecordQiZi, boolean bl, Cvs2QiPan cvs2QiPan, MyNewClock myNewClock, GoeRoomBbs goeRoomBbs, GoRoom goRoom) {
        switch (goRecordQiZi.type) {
            case 1: {
                cvs2QiPan.setQiZi(goRecordQiZi.qz);
                if (myNewClock == null) break;
                myNewClock.modifyTime(goRecordQiZi.snap);
                myNewClock.click();
                break;
            }
            case 3: {
                if (goRecordQiZi.agreeUser.equals(goRoom.black)) {
                    cvs2QiPan.goBack(2);
                    break;
                }
                cvs2QiPan.goBack(1);
                break;
            }
            case 41: {
                cvs2QiPan.enterComputeMode();
                myNewClock.pause();
                break;
            }
            case 42: {
                cvs2QiPan.quitComputeMode();
                myNewClock.contin();
                break;
            }
            case 43: {
                cvs2QiPan.setComputeSelect(goRecordQiZi.selectPosition);
                break;
            }
            case 40: {
                cvs2QiPan.quitComputeMode();
                myNewClock.stop();
                this.guiRoom.gamblingPane.clear();
                this.saveQiPu(cvs2QiPan, goRoom);
                break;
            }
        }
        if (bl) {
            this.printRecordQiZiMsg(goRecordQiZi, goeRoomBbs);
        }
    }

    private synchronized void saveQiPu(Cvs2QiPan cvs2QiPan, GoRoom goRoom) {
        QiPu qiPu = new QiPu(cvs2QiPan.getData());
        String string = goRoom.blackNameWithLevel2(Global.lang) + " vs " + goRoom.whiteNameWithLevel2(Global.lang);
        qiPu.setTitle(string);
        long l = System.currentTimeMillis();
        String string2 = " " + this.toDateStr(l);
        qiPu.setExplain(string2);
        try {
            File file = new File("gosave");
            if (!file.exists()) {
                file.mkdir();
            } else if (file.isFile()) {
                file.mkdir();
            }
            File file2 = new File("gosave/" + string + l / 3000L + ".twq");
            if (file2.exists()) {
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
            TyBaseOutputStream tyBaseOutputStream = new TyBaseOutputStream(dataOutputStream);
            qiPu.write(tyBaseOutputStream);
            tyBaseOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    protected void printRecordQiZiMsg(GoRecordQiZi goRecordQiZi, GoeRoomBbs goeRoomBbs) {
        String string = " ";
        switch (goRecordQiZi.type) {
            case 1: {
                if (goRecordQiZi.qz.flag != 8) break;
                if (goRecordQiZi.qz.getColor() == 1) {
                    string = this.guiRoom.coreData.blackNameWithLevel(Global.lang);
                } else if (goRecordQiZi.qz.getColor() == 2) {
                    string = this.guiRoom.coreData.whiteNameWithLevel(Global.lang);
                }
                goeRoomBbs.append(string + " " + Global.lang.getKey("123_stop_one"));
                break;
            }
            case 40: {
                String string2 = goRecordQiZi.serverResult.toString(Global.lang);
                goeRoomBbs.append(string2);
                goeRoomBbs.displayMessageNoChangeLine(goeRoomBbs.display.redUnderLine, " " + Global.lang.getKey("132_game_end"));
                goeRoomBbs.displayMessage(goeRoomBbs.display.redUnderLine, " ### " + new Time(System.currentTimeMillis()).toString());
                break;
            }
            case 2: {
                this.msgPrint(goRecordQiZi.regretUser, "123_regret", goeRoomBbs);
                break;
            }
            case 3: {
                this.msgPrint(goRecordQiZi.agreeUser, "123_agree_regret", goeRoomBbs);
                break;
            }
            case 4: {
                this.msgPrint(goRecordQiZi.refuseUser, "123_refuse_regret", goeRoomBbs);
                break;
            }
            case 5: {
                this.msgPrint(goRecordQiZi.whoGiveUp, "123_give_up", goeRoomBbs);
                break;
            }
            case 7: {
                this.msgPrint(goRecordQiZi.whoTimeOut, "123_time_out", goeRoomBbs);
                break;
            }
            case 8: {
                this.msgPrint(goRecordQiZi.whoPeaceGame, "123_peace", goeRoomBbs);
                break;
            }
            case 9: {
                this.msgPrint(goRecordQiZi.whoAgreePeaceGame, "123_agree_peace", goeRoomBbs);
                break;
            }
            case 10: {
                this.msgPrint(goRecordQiZi.whoRefusePeaceGame, "123_refuse_peace", goeRoomBbs);
                break;
            }
            case 14: {
                this.msgPrint(goRecordQiZi.whoSendGameResult, "123_game_result", goeRoomBbs);
                break;
            }
            case 15: {
                this.msgPrint(goRecordQiZi.whoAgreeGameResult, "123_agree_game_result", goeRoomBbs);
                break;
            }
            case 16: {
                this.msgPrint(goRecordQiZi.whoRefuseGameResult, "123_refuse_game_result", goeRoomBbs);
                break;
            }
            case 11: {
                this.msgPrint(goRecordQiZi.who_want_compute, "123_compute", goeRoomBbs);
                break;
            }
            case 12: {
                this.msgPrint(goRecordQiZi.who_agree_opponent_compute, "123_agree_compute", goeRoomBbs);
                break;
            }
            case 13: {
                this.msgPrint(goRecordQiZi.who_refuse_opponent_compute, "123_refuse_compute", goeRoomBbs);
                break;
            }
            case 20: {
                this.msgPrint(goRecordQiZi.whoBreakLine, "123_break_line", goeRoomBbs);
                break;
            }
            case 41: {
                goeRoomBbs.append(Global.lang.getKey("123_server_agree_compute"));
                break;
            }
            case 21: {
                this.msgPrint(goRecordQiZi.reEnterRequestUser, "123_re_enter_game_mode_request", goeRoomBbs);
                break;
            }
            case 22: {
                this.msgPrint(goRecordQiZi.agreeReEnterRequestUser, "123_agree_re_enter_game_mode_request", goeRoomBbs);
                break;
            }
            case 23: {
                this.msgPrint(goRecordQiZi.refuseReEnterRequestUser, "123_refuse_re_enter_game_mode_request", goeRoomBbs);
                break;
            }
            case 24: {
                this.msgPrint(goRecordQiZi.whoValidate, "124_validate", goeRoomBbs);
                break;
            }
        }
    }

    private void msgPrint(String string, String string2, GoeRoomBbs goeRoomBbs) {
        String string3 = this.guiRoom.coreData.blackOrWhiteNameWithLevel(string, Global.lang);
        goeRoomBbs.append(string3 + " " + Global.lang.getKey(string2));
    }

    protected void setBegin(GoGameRule goGameRule, Cvs2QiPan cvs2QiPan) {
        boolean bl = cvs2QiPan.getSound();
        cvs2QiPan.setSound(false);
        if (goGameRule.type == 2) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 3) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 4) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 5) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 6) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 7) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 8) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        if (goGameRule.type == 9) {
            QiZi qiZi = new QiZi(1, 3, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 3, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 15, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 15);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 3);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            qiZi = new QiZi(1, 9, 9);
            qiZi.flag = (byte)7;
            cvs2QiPan.setQiZi(qiZi);
            return;
        }
        cvs2QiPan.setSound(bl);
    }
}

