/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoGamblingOneUserInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.goeroom.GamblingInputPane;
import tianyuan.games.gui.goe.table.GoGamblingInfoList;

public class GoGamblingInfoPane
extends JPanel {
    private GoGamblingGameInfo core = null;
    private GoGamblingInfoList blackWin;
    private GoGamblingInfoList whiteWin;
    private JSplitPane split = null;
    private GamblingInputPane inputPane;
    private SizeListener seeSize = new SizeListener();

    public GoGamblingInfoPane(int n, GoGamblingGameInfo goGamblingGameInfo) {
        this.inputPane = new GamblingInputPane(n);
        this.core = goGamblingGameInfo != null ? goGamblingGameInfo : new GoGamblingGameInfo();
        this.blackWin = new GoGamblingInfoList(Global.lang.getKey("306_black"));
        this.whiteWin = new GoGamblingInfoList(Global.lang.getKey("306_white"));
        for (GoGamblingOneUserInfo goGamblingOneUserInfo : this.core.getBlackWin()) {
            this.blackWin.add(goGamblingOneUserInfo);
        }
        for (GoGamblingOneUserInfo goGamblingOneUserInfo : this.core.getWhiteWin()) {
            this.whiteWin.add(goGamblingOneUserInfo);
        }
        this.inputPane.displayLossRatio(this.core.getLossRatio());
        this.split = new JSplitPane(1, this.blackWin, this.whiteWin);
        this.split.setDividerLocation(0.5);
        this.setLayout(new BorderLayout());
        this.add("North", this.inputPane);
        this.add("Center", this.split);
        this.addComponentListener(this.seeSize);
    }

    public void setCoreData(GoGamblingGameInfo goGamblingGameInfo) {
        this.core = goGamblingGameInfo;
    }

    public void clear() {
        if (this.core != null) {
            this.core.clear();
        }
        this.inputPane.clear();
        this.blackWin.clear();
        this.whiteWin.clear();
        this.setEnabled(false);
    }

    public void add(GoGamblingOneUserInfo goGamblingOneUserInfo, boolean bl) {
        if (bl) {
            goGamblingOneUserInfo.money = this.core.buyBlackWin(goGamblingOneUserInfo);
            this.blackWin.add(goGamblingOneUserInfo);
            this.blackWin.updateDigital(this.core.blackWinPerson(), this.core.blackWinMoney());
        } else {
            goGamblingOneUserInfo.money = this.core.buyWhiteWin(goGamblingOneUserInfo);
            this.whiteWin.add(goGamblingOneUserInfo);
            this.whiteWin.updateDigital(this.core.whiteWinPerson(), this.core.whiteWinMoney());
        }
        this.inputPane.displayLossRatio(this.core.getLossRatio());
    }

    public void setInfo(GoGamblingGameInfo goGamblingGameInfo) {
        for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getBlackWin()) {
            this.core.buyBlackWin(goGamblingOneUserInfo);
            this.blackWin.add(goGamblingOneUserInfo);
        }
        for (GoGamblingOneUserInfo goGamblingOneUserInfo : goGamblingGameInfo.getWhiteWin()) {
            this.core.buyWhiteWin(goGamblingOneUserInfo);
            this.whiteWin.add(goGamblingOneUserInfo);
        }
        this.blackWin.updateDigital(this.core.blackWinPerson(), this.core.blackWinMoney());
        this.whiteWin.updateDigital(this.core.whiteWinPerson(), this.core.whiteWinMoney());
        this.inputPane.displayLossRatio(this.core.getLossRatio());
    }

    private void setAllSize() {
        Dimension dimension = this.getSize();
        this.split.setDividerLocation(0.5);
        this.revalidate();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoGamblingInfoPane.this.setAllSize();
        }
    }
}

