/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SpringLayout;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJToggleButton;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.GoEditorBoard;
import tianyuan.games.gui.goe.editor.MyGoFileFilter;
import tianyuan.games.gui.goe.editor.TwqFileFilter;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.BoardView;
import tianyuan.games.gui.goe.goeroom.GoCommandPane;

public class GoEditorCommandPane
extends GoCommandPane {
    private GoEditor editor;
    private GoEditorBoard board;
    AbstractButton[] button1 = new AbstractButton[5];
    AbstractButton[] button2 = new AbstractButton[4];
    private String currentDir = "";
    private boolean analysisFlag = false;
    private String filename = "Untitled.twq";
    protected SizeListener seeSize = new SizeListener();

    public GoEditorCommandPane(GoEditor goEditor, GoEditorBoard goEditorBoard) {
        this.editor = goEditor;
        this.board = goEditorBoard;
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
    }

    private boolean isNeedSave() {
        return this.editor.getNewDataUnSaveFlag();
    }

    protected void clear() {
        int n;
        if (this.analysisFlag) {
            return;
        }
        if (this.isNeedSave() && ((n = this.unSaveProcess()) == -1 || n == 2)) {
            return;
        }
        this.editor.clear();
    }

    private void setTitle(String string) {
        this.setFilename(string);
        this.editor.geListener.setGoEditorTitle("tpweiqi-editor-" + this.getFilename());
    }

    protected void openFile() {
        int n;
        if (this.analysisFlag) {
            return;
        }
        if (this.isNeedSave() && ((n = this.unSaveProcess()) == -1 || n == 2)) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new MyGoFileFilter());
        this.currentDir = GoEditor.paramter.getString("22_current_dir");
        if (this.currentDir != null && !this.currentDir.equals("")) {
            try {
                File file = new File(this.currentDir);
                if (file != null) {
                    jFileChooser.setCurrentDirectory(file);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n2 = jFileChooser.showOpenDialog(null);
        File file = jFileChooser.getSelectedFile();
        if (file != null && n2 == 0) {
            String string = file.getName();
            if (string.endsWith("twq") || string.endsWith("TWQ")) {
                try {
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                    TyBaseInputStream tyBaseInputStream = new TyBaseInputStream(dataInputStream);
                    QiPu qiPu = new QiPu();
                    qiPu.read(tyBaseInputStream);
                    if (!qiPu.fileCanUsed()) {
                        JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
                        tyBaseInputStream.close();
                        return;
                    }
                    this.editor.setQiPu(qiPu);
                    this.setTitle(file.getName());
                    this.editor.setNewDataUnSaveFlag(false);
                    this.currentDir = file.getPath();
                    this.currentDir = file.getParent();
                    GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                    GoEditor.paramter.writeOut();
                    tyBaseInputStream.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
                }
            } else if (string.endsWith("sgf") || string.endsWith("SGF")) {
                Object object;
                try {
                    object = new DataInputStream(new FileInputStream(file));
                    TyBaseInputStream tyBaseInputStream = new TyBaseInputStream((DataInputStream)object);
                    QiPu qiPu = new QiPu();
                    qiPu.read(tyBaseInputStream);
                    if (qiPu.fileCanUsed()) {
                        this.editor.setQiPu(qiPu);
                        this.setTitle(file.getName());
                        this.editor.setNewDataUnSaveFlag(false);
                        this.currentDir = file.getPath();
                        this.currentDir = file.getParent();
                        GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                        GoEditor.paramter.writeOut();
                        tyBaseInputStream.close();
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    object = new QiPu(file);
                    if (!((QiPu)object).fileCanUsed()) {
                        JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
                        return;
                    }
                    this.editor.setQiPu((QiPu)object);
                    this.setTitle(file.getName());
                    this.editor.setNewDataUnSaveFlag(false);
                    this.currentDir = file.getPath();
                    this.currentDir = file.getParent();
                    GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                    GoEditor.paramter.writeOut();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
                }
            }
        }
    }

    private int unSaveProcess() {
        String string = GoEditor.lang.getKey("211_unsave_title");
        String[] stringArray = new String[]{GoEditor.lang.getKey("211_unsave_info") + this.filename, "", GoEditor.lang.getKey("211_unsave_ask"), ""};
        int n = JOptionPane.showConfirmDialog(null, stringArray, string, 1, 2);
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                this.filename = this.filename;
                this.saveAsFile();
                break;
            }
            case 1: {
                break;
            }
        }
        return n;
    }

    protected void saveAsFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new TwqFileFilter());
        this.currentDir = GoEditor.paramter.getString("22_current_dir");
        if (!this.currentDir.equals("")) {
            try {
                File file2 = new File(this.currentDir);
                jFileChooser.setCurrentDirectory(file2);
                file = new File(this.currentDir + this.getFilename());
                jFileChooser.setSelectedFile(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n = jFileChooser.showSaveDialog(null);
        file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            QiPu qiPu = this.editor.getQiPu();
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                TyBaseOutputStream tyBaseOutputStream = new TyBaseOutputStream(dataOutputStream);
                qiPu.write(tyBaseOutputStream);
                GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                GoEditor.paramter.writeOut();
                tyBaseOutputStream.close();
                this.setTitle(file.getName());
                this.editor.setNewDataUnSaveFlag(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    protected boolean save() {
        if (this.filename != null && !this.filename.equals("")) {
            try {
                File file = new File(this.currentDir + this.filename);
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                TyBaseOutputStream tyBaseOutputStream = new TyBaseOutputStream(dataOutputStream);
                QiPu qiPu = this.editor.getQiPu();
                qiPu.write(tyBaseOutputStream);
                tyBaseOutputStream.close();
                this.editor.setNewDataUnSaveFlag(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        } else {
            this.saveAsFile();
        }
        return true;
    }

    protected void quit() {
        int n;
        boolean bl = this.isNeedSave();
        if (bl && ((n = this.unSaveProcess()) == -1 || n == 2)) {
            return;
        }
        System.exit(0);
    }

    private void setGoEditorTitle(String string) {
        if (this.editor.geListener != null) {
            this.editor.geListener.setGoEditorTitle(string);
        }
    }

    @Override
    protected void resetLayout() {
        int n;
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n2 = (dimension.width - 10) / this.button1.length;
        int n3 = (dimension.width - 16) / this.button2.length;
        int n4 = (dimension.height - 10) / 2;
        for (n = 0; n < this.button1.length; ++n) {
            this.addComp(this.button1[n], dimension.width / this.button1.length * n + 2, 3, n2, n4);
        }
        for (n = 0; n < this.button2.length; ++n) {
            this.addComp(this.button2[n], dimension.width / this.button2.length * n + 2, dimension.height / 2 + 2, n3, n4);
        }
    }

    private void createButton() {
        this.button1[0] = new MyJButton(GoEditor.lang.getKey("211_new"));
        this.button1[1] = new MyJToggleButton(GoEditor.lang.getKey("211_analyze"));
        this.button1[2] = new MyJToggleButton(GoEditor.lang.getKey("120_test"));
        this.button1[3] = new MyJToggleButton(GoEditor.lang.getKey("211_quiet"));
        this.button1[4] = new MyJButton(GoEditor.lang.getKey("211_quit"));
        this.button2[1] = new MyJButton(GoEditor.lang.getKey("211_open"));
        this.button2[2] = new MyJButton(GoEditor.lang.getKey("211_save"));
        this.button2[3] = new MyJButton(GoEditor.lang.getKey("211_save_as"));
        this.button1[0].addActionListener(new NewListener());
        this.button1[1].addItemListener(new AnalysisListener());
        this.button1[2].addItemListener(new TestListener());
        this.button1[3].addItemListener(new QuietListener());
        this.button1[4].addActionListener(new QuitListener());
        this.button2[1].addActionListener(new OpenListener());
        this.button2[2].addActionListener(new SaveListener());
        this.button2[3].addActionListener(new SaveAsListener());
        try {
            this.boardView = new BoardView(this.board, GoEditor.lang, GoEditor.paramter);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.button2[0] = this.boardView;
    }

    protected class SizeListener
    extends ComponentAdapter {
        protected SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoEditorCommandPane.this.resetLayout();
        }
    }

    class SaveAsListener
    implements ActionListener {
        SaveAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoEditorCommandPane.this.saveAsFile();
        }
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoEditorCommandPane.this.save();
        }
    }

    class OpenListener
    implements ActionListener {
        OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoEditorCommandPane.this.openFile();
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoEditorCommandPane.this.quit();
        }
    }

    class AnalysisListener
    implements ItemListener {
        AnalysisListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                GoEditorCommandPane.this.editor.enterAnalysisMode();
                GoEditorCommandPane.this.analysisFlag = true;
            } else {
                GoEditorCommandPane.this.editor.quitAnalysisMode();
                GoEditorCommandPane.this.analysisFlag = false;
            }
        }
    }

    class QuietListener
    implements ItemListener {
        QuietListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                ((GoEditorCommandPane)GoEditorCommandPane.this).editor.boardMainPane.board.setSound(false);
            } else {
                ((GoEditorCommandPane)GoEditorCommandPane.this).editor.boardMainPane.board.setSound(true);
            }
        }
    }

    class TestListener
    implements ItemListener {
        TestListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                GoEditorCommandPane.this.editor.enterTestMode();
            } else {
                GoEditorCommandPane.this.editor.quitTestMode();
            }
        }
    }

    class NewListener
    implements ActionListener {
        NewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoEditorCommandPane.this.clear();
        }
    }
}

