/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.netmanager.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.UserInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.hall.PagePane;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;
import tianyuan.games.gui.netmanager.table.DeleteUserAction;
import tianyuan.games.gui.netmanager.table.DisableAction;
import tianyuan.games.gui.netmanager.table.EnableAction;
import tianyuan.games.gui.netmanager.table.MailToUserAction;
import tianyuan.games.gui.netmanager.table.SetAdminAction;
import tianyuan.games.gui.netmanager.table.SetNormalUserAction;
import tianyuan.games.gui.util.MyDate;
import tianyuan.games.gui.util.MyTime;

public class NetManagerTable
extends MyJPanel {
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected NetManagerTableSorter sorter;
    protected Pager pagePane = new Pager();
    protected JTextField userNameInput = new JTextField(10);
    protected JButton searchUser = new JButton(Global.lang.getKey("114_search_user"));
    protected JPopupMenu popup = new JPopupMenu();
    protected String[] columnNames = new String[]{Global.lang.getKey("111_username"), Global.lang.getKey("111_netmanager"), Global.lang.getKey("102_money"), Global.lang.getKey("111_on_line_count"), Global.lang.getKey("111_on_line_time_total"), Global.lang.getKey("111_register_time"), Global.lang.getKey("111_time"), Global.lang.getKey("111_ip_address"), Global.lang.getKey("111_os")};
    Vector<UserInfo> userTable;
    private SizeListener seeSize = new SizeListener();
    protected DeleteUserAction deleteUser;
    protected SetAdminAction setAdmin;
    protected SetNormalUserAction setNormalUser;
    protected MailToUserAction mailToUser;
    protected DisableAction disableAction;
    protected EnableAction enableAction;

    protected void setPopupMenu() {
        this.deleteUser = new DeleteUserAction(this);
        this.popup.add(this.deleteUser);
        this.setAdmin = new SetAdminAction(this);
        this.popup.add(this.setAdmin);
        this.setNormalUser = new SetNormalUserAction(this);
        this.popup.add(this.setNormalUser);
        this.mailToUser = new MailToUserAction(this);
        this.popup.add(this.mailToUser);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
        this.searchUser.addActionListener(new UserNameInputListener());
        this.userNameInput.addActionListener(new UserNameInputListener());
    }

    protected UserInfo search(String string) {
        for (UserInfo userInfo : this.userTable) {
            if (!userInfo.userName.equals(string)) continue;
            return userInfo;
        }
        return null;
    }

    public NetManagerTable() {
        this.mtm = new MyTableModel();
        this.sorter = new NetManagerTableSorter(this.mtm);
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
        this.sp = new JScrollPane(this.table);
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
        this.setPopupMenu();
    }

    private void layout1() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = dimension.width - n;
        int n3 = 25;
        this.myAddComp(this.searchUser, 5, 3, dimension.width / 8, n3 - 6);
        this.myAddComp(this.userNameInput, dimension.width / 8 + 12, 3, dimension.width / 5, n3 - 6);
        this.myAddComp(this.pagePane, n + 1, 0, n2 - 1, n3);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 1);
        this.setColumnWidth();
        this.revalidate();
    }

    public void add(Vector<UserInfo> vector) {
        this.delAll();
        this.userTable = vector;
        for (UserInfo userInfo : vector) {
            this.addALine(userInfo);
        }
        this.pagePane.setNumber(1);
    }

    public void setPage(Vector<UserInfo> vector, int n) {
        this.delAll();
        this.userTable = vector;
        for (UserInfo userInfo : vector) {
            this.addALine(userInfo);
        }
        this.pagePane.setNumber(n + 1);
    }

    public void clearAndAddItem(UserInfo userInfo) {
        this.reset();
        if (userInfo == null) {
            return;
        }
        for (UserInfo userInfo2 : this.userTable) {
            if (!userInfo2.userName.equals(userInfo.userName)) continue;
            return;
        }
        this.addALine(userInfo);
    }

    public void add(UserInfo userInfo) {
        for (UserInfo userInfo2 : this.userTable) {
            if (!userInfo2.userName.equals(userInfo.userName)) continue;
            return;
        }
        this.addALine(userInfo);
    }

    void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    public String getUseTime(MyProperties myProperties, long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 3600L;
        long l4 = (l2 - l3 * 3600L) / 60L;
        long l5 = l2 - l3 * 3600L - l4 * 60L;
        if (l4 == 0L && l3 == 0L) {
            return l5 + myProperties.getKey("129_second");
        }
        if (l3 == 0L) {
            return l4 + myProperties.getKey("129_minute") + l5 + myProperties.getKey("129_second");
        }
        return l3 + myProperties.getKey("129_hour") + l4 + myProperties.getKey("129_minute") + l5 + myProperties.getKey("129_second");
    }

    private void addALine(UserInfo userInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(userInfo.userName);
        if (userInfo.adminField.isNetManager) {
            vector.add(Global.lang.getKey("111_yes"));
        } else {
            vector.add(Global.lang.getKey("111_no"));
        }
        vector.add(userInfo.money);
        vector.add(new Integer(userInfo.adminField.onLineCount));
        vector.add(new MyTime(Global.lang, userInfo.adminField.onLineTimeTotal));
        vector.add(new MyDate(userInfo.adminField.firstLoginTime));
        vector.add(new MyDate(userInfo.adminField.time));
        vector.add(userInfo.adminField.ipAddress);
        vector.add(userInfo.adminField.osDescr);
        this.mtm.addRow(vector);
    }

    protected String getSelectedUser() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("111_username").equals(this.sorter.getColumnName(i))) continue;
            String string = (String)this.sorter.getValueAt(n, i);
            return string;
        }
        return null;
    }

    public void modify(UserInfo userInfo) {
        int n = this.searchRow(userInfo.userName);
        if (n < 0) {
            return;
        }
        this.setValue(this.columnNames[0], userInfo.userName, n);
        if (userInfo.adminField.isNetManager) {
            this.setValue(this.columnNames[1], Global.lang.getKey("111_yes"), n);
        } else {
            this.setValue(this.columnNames[1], Global.lang.getKey("111_no"), n);
        }
        this.setValue(this.columnNames[3], userInfo.adminField.onLineCount, n);
        this.setValue(this.columnNames[4], new MyTime(Global.lang, userInfo.adminField.onLineTimeTotal), n);
        this.setValue(this.columnNames[5], new MyDate(userInfo.adminField.firstLoginTime), n);
        this.setValue(this.columnNames[6], new MyDate(userInfo.adminField.time), n);
        this.setValue(this.columnNames[7], userInfo.adminField.ipAddress, n);
        this.setValue(this.columnNames[8], userInfo.adminField.osDescr, n);
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    private String toTimeStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getTimeInstance(0, Locale.getDefault());
        return dateFormat.format(date);
    }

    private int searchRow(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!Global.lang.getKey("111_username").equals(this.mtm.getColumnName(i))) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (object == null || !(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                return j;
            }
        }
        return -1;
    }

    private void setValue(String string, Object object, int n) {
        int n2 = -1;
        int n3 = this.mtm.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (string.compareTo(this.mtm.getColumnName(i)) != 0) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        this.mtm.setValueAt(object, n, n2);
    }

    public void del(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (Global.lang.getKey("111_username").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void reset() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
        this.userTable.removeAllElements();
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new NetManagerCellRenderer());
        }
    }

    private void setAllSize() {
        this.pagePane.myReLayout();
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[0]);
        tableColumn.setPreferredWidth(45);
        tableColumn = this.table.getColumn(this.columnNames[1]);
        tableColumn.setPreferredWidth(22);
        tableColumn = this.table.getColumn(this.columnNames[2]);
        tableColumn.setPreferredWidth(22);
        tableColumn = this.table.getColumn(this.columnNames[3]);
        tableColumn.setPreferredWidth(33);
        tableColumn = this.table.getColumn(this.columnNames[4]);
        tableColumn.setPreferredWidth(80);
        tableColumn = this.table.getColumn(this.columnNames[5]);
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.columnNames[6]);
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.columnNames[7]);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.table.getColumn(this.columnNames[8]);
        tableColumn.setPreferredWidth(90);
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            NetManagerTable.this.setAllSize();
        }
    }

    class NetManagerCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        NetManagerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.isHostRecordRow(n)) {
                this.setForeground(HOST_FOREGROUND);
                this.setBackground(HOST_BACKGROUND);
            } else {
                this.setForeground(NORMAL_ITEM_FOREGROUND);
                this.setBackground(NORMAL_ITEM_BACKGROUND);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            String string = (String)NetManagerTable.this.sorter.getValueAt(n, 0);
            return string.equals(Global.myUserInfo.userName);
        }
    }

    class NetManagerTableSorter
    extends TableSorter {
        NetManagerTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isHostRecord(int n) {
            String string = (String)NetManagerTable.this.sorter.getValueAt(n, 0);
            return string.equals(Global.myUserInfo.userName);
        }

        @Override
        public int compareRowsByColumn(int n, int n2, int n3) {
            TableModel tableModel = this.model;
            if (this.ascending) {
                if (this.isHostRecord(n)) {
                    return -1;
                }
                if (this.isHostRecord(n2)) {
                    return 1;
                }
            } else {
                if (this.isHostRecord(n)) {
                    return 1;
                }
                if (this.isHostRecord(n2)) {
                    return -1;
                }
            }
            return super.compareRowsByColumn(n, n2, n3);
        }
    }

    class UserNameInputListener
    implements ActionListener {
        UserNameInputListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = NetManagerTable.this.userNameInput.getText();
            NetManagerTable.this.userNameInput.setText("");
            if (string == null || string.length() == 0) {
                return;
            }
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.searchUserDetial(string, -2);
        }
    }

    class Pager
    extends PagePane {
        Pager() {
        }

        @Override
        protected void doOperation(int n) {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.getUserTableByPage(n - 1);
        }
    }
}

