/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.innermail;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import tianyuan.games.base.innermail.InnerMailHead;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.hall.PagePane;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;

public class InnerMailBoxListView
extends MyJPanel {
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected InnerMailTableSorter sorter;
    protected JLabel title = new JLabel("");
    protected InnerMailPager pagePane = new InnerMailPager();
    protected JPopupMenu popup = new JPopupMenu();
    protected DeleteAction deleteAction = null;
    protected ReadAction readAction = null;
    private byte mailboxType;
    protected String[] columnNames = new String[]{Global.lang.getKey("252_number"), Global.lang.getKey("252_sender"), Global.lang.getKey("252_time"), Global.lang.getKey("252_receiver"), Global.lang.getKey("252_title"), Global.lang.getKey("252_size")};

    InnerMailBoxListView(String string, byte by) {
        this.mailboxType = by;
        this.mtm = new MyTableModel();
        this.sorter = new InnerMailTableSorter(this.mtm);
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.table.setDragEnabled(true);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.setPopupMenu();
        this.table.addMouseListener(new DoubleClickAdapter());
        this.sp = new JScrollPane(this.table);
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
        this.title.setText(string);
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new InnerMailCellRenderer());
        }
    }

    protected void setPopupMenu() {
        this.readAction = new ReadAction(this);
        this.deleteAction = new DeleteAction(this);
        this.popup.add(this.readAction);
        this.popup.add(this.deleteAction);
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = dimension.width - n;
        int n3 = 25;
        this.myAddComp(this.title, 5, 3, n - 6, n3 - 6);
        this.myAddComp(this.pagePane, n + 1 - 5, 0, n2 - 1, n3);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 1);
        this.setColumnWidth();
        this.pagePane.myReLayout();
        this.pagePane.revalidate();
        this.revalidate();
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[0]);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.table.getColumn(this.columnNames[1]);
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.columnNames[2]);
        tableColumn.setPreferredWidth(130);
        tableColumn = this.table.getColumn(this.columnNames[3]);
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.columnNames[4]);
        tableColumn.setPreferredWidth(500);
        tableColumn = this.table.getColumn(this.columnNames[5]);
        tableColumn.setPreferredWidth(35);
        this.table.doLayout();
    }

    public void add(InnerMailHead[] innerMailHeadArray) {
        for (int i = 0; i < innerMailHeadArray.length; ++i) {
            this.add(innerMailHeadArray[i]);
        }
    }

    public void add(InnerMailHead innerMailHead) {
        this.addALine(innerMailHead);
    }

    protected void addALine(InnerMailHead innerMailHead) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(innerMailHead.number + 1);
        vector.add(innerMailHead.sender);
        vector.add(this.toDateStr(innerMailHead.sendTime));
        vector.add(innerMailHead.receiver);
        vector.add(innerMailHead.title);
        vector.add(innerMailHead.size);
        this.mtm.addRow(vector);
    }

    public void del(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("252_number").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Integer n3 = (Integer)this.mtm.getValueAt(j, i);
                if (n3 - 1 != n) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void setPage(InnerMailHead[] innerMailHeadArray, int n) {
        this.delAll();
        this.pagePane.setNumber(n + 1);
        for (int i = 0; i < innerMailHeadArray.length; ++i) {
            this.addALine(innerMailHeadArray[i]);
        }
        this.myReLayout();
    }

    private int getSelectNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("252_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    private void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    void deleteOperation() {
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.innerMailDel(this.mailboxType, this.getSelectNumber() - 1);
    }

    void readOperation() {
        if (Global.netDaemon == null) {
            return;
        }
        int n = this.getSelectNumber() - 1;
        Global.netDaemon.innerMailRead(this.mailboxType, n);
    }

    void answerOperation() {
        if (Global.netDaemon == null) {
            return;
        }
    }

    class ReadAction
    extends RootAction {
        ReadAction(InnerMailBoxListView innerMailBoxListView2) {
            super(Global.lang.getKey("220_read"), innerMailBoxListView2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerMailBoxListView.this.readOperation();
        }
    }

    class DeleteAction
    extends RootAction {
        DeleteAction(InnerMailBoxListView innerMailBoxListView2) {
            super(Global.lang.getKey("220_delete"), innerMailBoxListView2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerMailBoxListView.this.deleteOperation();
        }
    }

    class RootAction
    extends AbstractAction {
        InnerMailBoxListView father;

        RootAction(String string, InnerMailBoxListView innerMailBoxListView2) {
            super(string);
            this.father = innerMailBoxListView2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class InnerMailCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        InnerMailCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            return false;
        }
    }

    class InnerMailTableSorter
    extends TableSorter {
        InnerMailTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isHostRecord(int n) {
            return false;
        }

        @Override
        public int compareRowsByColumn(int n, int n2, int n3) {
            TableModel tableModel = this.model;
            if (this.ascending) {
                if (this.isHostRecord(n)) {
                    return -1;
                }
                if (this.isHostRecord(n2)) {
                    return 1;
                }
            } else {
                if (this.isHostRecord(n)) {
                    return 1;
                }
                if (this.isHostRecord(n2)) {
                    return -1;
                }
            }
            return super.compareRowsByColumn(n, n2, n3);
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class InnerMailPager
    extends PagePane {
        InnerMailPager() {
        }

        @Override
        protected void doOperation(int n) {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.innerMailGetIndex(InnerMailBoxListView.this.mailboxType, n - 1);
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                InnerMailBoxListView.this.readOperation();
            }
        }
    }
}

