/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.ChallengeWithRule;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;

public class GoeRoomMemberList
extends JPanel {
    protected JLabel title = new JLabel();
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm = new MyTableModel();
    protected TableSorter sorter = new TableSorter(this.mtm);
    protected String[] columnNames = new String[]{Global.lang.getKey("102_username"), Global.lang.getKey("102_level"), Global.lang.getKey("102_winTimes"), Global.lang.getKey("102_failTimes")};
    protected GoeRoom goeRoomContainer;
    protected JPopupMenu popup = new JPopupMenu();
    protected ChallengeAction challengeAction;
    protected SendMessageAction sendMessageAction;
    protected InfoAction infoAction;
    protected int memberCount = 0;
    private SizeListener seeSize = new SizeListener();

    public GoeRoomMemberList(GoeRoom goeRoom) {
        this.title.setText(Global.lang.getKey("109_room_member_list"));
        this.goeRoomContainer = goeRoom;
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new DoubleClickAdapter());
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
        this.setPopupMenu();
        this.sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)this.sp, "Center");
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
    }

    protected String getSelectedUser() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("102_username").equals(this.sorter.getColumnName(i))) continue;
            String string = (String)this.sorter.getValueAt(n, i);
            return string;
        }
        return null;
    }

    protected void setActionsEnabled(boolean bl, boolean bl2) {
        if (this.challengeAction != null) {
            this.challengeAction.setEnabled(bl);
        }
        if (this.sendMessageAction != null) {
            this.sendMessageAction.setEnabled(bl2);
        }
    }

    public void setPopupMenu() {
        this.challengeAction = new ChallengeAction(this);
        this.popup.add(this.challengeAction);
        this.sendMessageAction = new SendMessageAction(this);
        this.popup.add(this.sendMessageAction);
        this.infoAction = new InfoAction(this);
        this.popup.add(this.infoAction);
    }

    private void updateTitle() {
        this.title.setText(Global.lang.getKey("109_room_member_list") + "    " + Global.lang.getKey("109_counter") + this.memberCount);
    }

    public void add(UserInfo userInfo, UserTmpInfo userTmpInfo) {
        this.addALine(userInfo, userTmpInfo, this.mtm);
    }

    public void del(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (Global.lang.getKey("102_username").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                this.mtm.removeRow(j);
                --this.memberCount;
                this.updateTitle();
                return;
            }
        }
    }

    public void modify(UserAllInfo userAllInfo) {
        int n = this.searchRow(userAllInfo.info.userName);
        if (n < 0) {
            return;
        }
        this.setValue(this.columnNames[1], userAllInfo.info.go.currentLevel.toString(Global.lang), n);
        this.setValue(this.columnNames[2], new Integer(userAllInfo.info.go.total.win), n);
        this.setValue(this.columnNames[3], new Integer(userAllInfo.info.go.total.fail), n);
    }

    private void setValue(String string, Object object, int n) {
        int n2 = -1;
        int n3 = this.mtm.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (string.compareTo(this.mtm.getColumnName(i)) != 0) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        this.mtm.setValueAt(object, n, n2);
    }

    private void addALine(UserInfo userInfo, UserTmpInfo userTmpInfo, MyTableModel myTableModel) {
        int n = this.searchRow(userInfo.userName);
        if (n >= 0) {
            myTableModel.removeRow(n);
        } else {
            ++this.memberCount;
            this.updateTitle();
        }
        Vector<Object> vector = new Vector<Object>();
        vector.add(userInfo.userName);
        vector.add(userInfo.go.currentLevel.toString(Global.lang));
        vector.add(new Integer(userInfo.go.total.win));
        vector.add(new Integer(userInfo.go.total.fail));
        myTableModel.addRow(vector);
    }

    private int searchRow(String string) {
        int n = this.mtm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!Global.lang.getKey("102_username").equals(this.mtm.getColumnName(i))) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (object == null || !(object instanceof String) || ((String)object).compareTo(string) != 0) continue;
                return j;
            }
        }
        return -1;
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new UserTableCellRenderer());
        }
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        int n = this.table.getColumnCount();
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int[] nArray = new int[]{n2 / 10, n2 / 20, n2 / 30, n2 / 30};
        int[] nArray2 = new int[]{n2 / 3 * 2, n2 / 4, n2 / 4, n2 / 4};
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.columnNames[i]);
            tableColumn.setMinWidth(nArray[i]);
            tableColumn.setMaxWidth(nArray2[i]);
        }
        this.table.doLayout();
    }

    private void challenge() {
        String string = this.getSelectedUser();
        if (string == null) {
            return;
        }
        if (string.equals(Global.myName())) {
            this.detial();
            return;
        }
        UserAllInfo userAllInfo = Global.goRoomPanel.search(string);
        if (userAllInfo == null) {
            return;
        }
        new ChallengeWithRule(Global.root, userAllInfo.info, this.goeRoomContainer.getRoomNumber());
    }

    private void detial() {
        String string = this.getSelectedUser();
        if (string == null) {
            return;
        }
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.searchUserDetial(string, this.goeRoomContainer.getRoomNumber());
    }

    class InfoAction
    extends RootAction {
        InfoAction(GoeRoomMemberList goeRoomMemberList2) {
            super(Global.lang.getKey("102_detail"), goeRoomMemberList2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoeRoomMemberList.this.detial();
        }
    }

    class SendMessageAction
    extends RootAction {
        SendMessageAction(GoeRoomMemberList goeRoomMemberList2) {
            super(Global.lang.getKey("102_chat"), goeRoomMemberList2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.father.getSelectedUser();
            if (string == null) {
                return;
            }
            UserAllInfo userAllInfo = Global.goRoomPanel.search(string);
            if (userAllInfo == null) {
                return;
            }
            Global.goCollogue.openUser(userAllInfo.info);
            Global.goCollogue.setVisible(true);
        }
    }

    class ChallengeAction
    extends RootAction {
        ChallengeAction(GoeRoomMemberList goeRoomMemberList2) {
            super(Global.lang.getKey("102_challenge"), goeRoomMemberList2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoeRoomMemberList.this.challenge();
        }
    }

    class RootAction
    extends AbstractAction {
        GoeRoomMemberList father;

        RootAction(String string, GoeRoomMemberList goeRoomMemberList2) {
            super(string);
            this.father = goeRoomMemberList2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class UserTableCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        UserTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.isHostRecordRow(n)) {
                this.setForeground(HOST_FOREGROUND);
                this.setBackground(HOST_BACKGROUND);
            } else {
                this.setForeground(NORMAL_ITEM_FOREGROUND);
                this.setBackground(NORMAL_ITEM_BACKGROUND);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            String string = (String)GoeRoomMemberList.this.sorter.getValueAt(n, 0);
            return string.equals(Global.myUserInfo.userName);
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeRoomMemberList.this.setAllSize();
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            String string = GoeRoomMemberList.this.getSelectedUser();
            if (string == null) {
                return;
            }
            UserAllInfo userAllInfo = Global.goRoomPanel.search(string);
            boolean bl = true;
            boolean bl2 = true;
            if (userAllInfo != null) {
                bl = userAllInfo.info.go.isAcceptInvitation;
                bl2 = userAllInfo.info.go.isAcceptPersonMessage;
            }
            if (string.equals(Global.myUserInfo.userName)) {
                GoeRoomMemberList.this.setActionsEnabled(false, false);
            } else if (Global.myUserInfo.isFriend(string)) {
                GoeRoomMemberList.this.setActionsEnabled(bl, bl2);
            } else if (Global.myUserInfo.isDislike(string)) {
                GoeRoomMemberList.this.setActionsEnabled(bl, bl2);
            } else {
                GoeRoomMemberList.this.setActionsEnabled(bl, bl2);
            }
            this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GoeRoomMemberList.this.detial();
            }
        }
    }
}

