/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.hall;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import tianyuan.games.base.GoGamblingGameInfo;
import tianyuan.games.base.GoGamblingOneUserInfo;
import tianyuan.games.base.GoGameIndex;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.base.RoomStatus;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.base.UsernameAndMoney;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.ChallengeWithRule;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.GoeSeeGameRecordPane;
import tianyuan.games.gui.goe.hall.RightCenterCommandBar;
import tianyuan.games.gui.goe.hall.SystemBbs;
import tianyuan.games.gui.goe.hall.TabbedInfoPane;
import tianyuan.games.gui.goe.hall.UserGoInfoPane2;
import tianyuan.games.gui.goe.table.TabbedNewGameList;
import tianyuan.games.gui.goe.table.TabbedRunGameList;
import tianyuan.games.gui.goe.table.TabbedUserList;
import tianyuan.games.net.GoServerResponse;
import tianyuan.games.net.ServerMessage;

public class GoRoomPanel
extends JPanel {
    Vector<UserAllInfo> allInfo;
    Vector<GoRoom> rooms;
    protected Vector<GoeRoom> goeRooms = new Vector();
    protected TabbedInfoPane tabbedInfoPane = new TabbedInfoPane();
    protected SystemBbs systemBbs = new SystemBbs();
    protected TabbedUserList userList = new TabbedUserList();
    protected TabbedNewGameList newGameList = new TabbedNewGameList();
    protected TabbedRunGameList runGameList = new TabbedRunGameList();
    protected RightCenterCommandBar commandBar = new RightCenterCommandBar();
    private JPanel right1 = new JPanel();
    private JSplitPane left;
    private JSplitPane right;
    private JSplitPane center;
    private JScrollPane jsp1 = new JScrollPane();
    private SizeListener seeSize = new SizeListener();

    public GoRoomPanel() {
        this.tabbedInfoPane.add(Global.lang.getKey("107_system_bbs"), this.systemBbs);
        this.right1.setLayout(new BorderLayout());
        this.right1.add("Center", this.userList);
        this.right1.add("South", this.commandBar);
        this.right = new JSplitPane(0, this.right1, this.tabbedInfoPane);
        this.right.setOneTouchExpandable(true);
        this.left = new JSplitPane(0, this.newGameList, this.runGameList);
        this.left.setOneTouchExpandable(true);
        this.center = new JSplitPane(1, this.left, this.right);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.center);
        this.setAllSize();
        this.addComponentListener(this.seeSize);
    }

    public void reset() {
        if (this.allInfo != null) {
            this.allInfo.removeAllElements();
        }
        if (this.rooms != null) {
            this.rooms.removeAllElements();
        }
        if (this.goeRooms != null) {
            this.goeRooms.removeAllElements();
        }
        if (this.systemBbs != null) {
            this.systemBbs.clear();
        }
        if (this.userList != null) {
            this.userList.delAll();
        }
        if (this.newGameList != null) {
            this.newGameList.delAll();
        }
        if (this.runGameList != null) {
            this.runGameList.delAll();
        }
        if (this.tabbedInfoPane != null) {
            this.tabbedInfoPane.myReset();
        }
    }

    public int userCount() {
        return this.allInfo.size();
    }

    private String nameWithLevel(String string) {
        for (UserAllInfo userAllInfo : this.allInfo) {
            if (!userAllInfo.info.userName.equals(string)) continue;
            return userAllInfo.info.nameWithGoLevel(Global.lang);
        }
        return string;
    }

    public boolean isMeInThisRoom(int n) {
        for (GoRoom goRoom : this.rooms) {
            if (goRoom.roomNumber != n || !goRoom.isMember(Global.myUserInfo.userName)) continue;
            return true;
        }
        return false;
    }

    public GoRoom searchRoom(int n) {
        for (GoRoom goRoom : this.rooms) {
            if (goRoom.roomNumber != n) continue;
            return goRoom;
        }
        return null;
    }

    public void add(UserInfo userInfo, UserTmpInfo userTmpInfo, Vector<UserAllInfo> vector, Vector<GoRoom> vector2) {
        this.allInfo = vector;
        this.rooms = vector2;
        UserAllInfo userAllInfo = new UserAllInfo();
        userAllInfo.info = userInfo;
        userAllInfo.tmpInfo = userTmpInfo;
        this.allInfo.add(0, userAllInfo);
        this.userList.add(vector);
        for (GoRoom goRoom : vector2) {
            if (goRoom.status.getValue() == 1) {
                this.newGameList.add(goRoom);
                continue;
            }
            this.runGameList.add(goRoom);
        }
    }

    public void oneUserLogin(UserInfo userInfo, UserTmpInfo userTmpInfo) {
        UserAllInfo userAllInfo = new UserAllInfo();
        userAllInfo.info = userInfo;
        userAllInfo.tmpInfo = userTmpInfo;
        this.allInfo.add(userAllInfo);
        this.userList.add(userInfo, userTmpInfo);
    }

    public void oneUserLogout(String string) {
        this.delUser(string);
        this.userList.del(string);
        Enumeration<GoRoom> enumeration = this.rooms.elements();
        while (enumeration.hasMoreElements()) {
            GoRoom goRoom = enumeration.nextElement();
            if (!goRoom.isMember(string)) continue;
            goRoom.goOut(string);
            if (goRoom.userinfos.size() == 0) {
                this.rooms.remove(goRoom);
                this.newGameList.del(goRoom.roomNumber);
                this.runGameList.del(goRoom.roomNumber);
                continue;
            }
            this.newGameList.modify(goRoom);
            this.runGameList.modify(goRoom);
        }
        for (GoeRoom goeRoom : this.goeRooms) {
            goeRoom.goOut(string);
        }
    }

    public UserAllInfo search(String string) {
        for (UserAllInfo userAllInfo : this.allInfo) {
            if (!string.equals(userAllInfo.info.userName)) continue;
            return userAllInfo;
        }
        return null;
    }

    public void oneUserExitStudyRoomStatus(int n, String string) {
        for (GoeRoom goeRoom : this.goeRooms) {
            if (goeRoom.getRoomNumber() != n) continue;
            goeRoom.oneUserExitStudyRoomStatus(string);
            break;
        }
    }

    public void studyRefPublish(int n, int n2, int n3, QiPu qiPu, String string, int n4) {
        for (GoeRoom goeRoom : this.goeRooms) {
            if (goeRoom.getRoomNumber() != n) continue;
            goeRoom.studyRefPublish(n2, n3, qiPu, string, n4);
            break;
        }
    }

    public void studyRefDelete(int n, int n2, String string) {
        for (GoeRoom goeRoom : this.goeRooms) {
            if (goeRoom.getRoomNumber() != n) continue;
            goeRoom.studyRefDelete(n2, string);
            break;
        }
    }

    private void delUser(String string) {
        for (UserAllInfo userAllInfo : this.allInfo) {
            if (!string.equals(userAllInfo.info.userName)) continue;
            this.allInfo.remove(userAllInfo);
            break;
        }
    }

    private void delRoom(int n) {
        for (GoRoom goRoom : this.rooms) {
            if (goRoom.roomNumber != n) continue;
            this.rooms.remove(goRoom);
            break;
        }
    }

    public void updateUserMoneyChange(Vector<UsernameAndMoney> vector) {
        for (UsernameAndMoney usernameAndMoney : vector) {
            this.userList.updateMoney(usernameAndMoney.username, usernameAndMoney.money);
        }
    }

    public void gamblingAddMoney(int n, GoGamblingOneUserInfo goGamblingOneUserInfo, boolean bl) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.gamblingAddMoney(goGamblingOneUserInfo, bl);
    }

    public void gamblingGameInfo(int n, GoGamblingGameInfo goGamblingGameInfo) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.gamblingGameInfo(goGamblingGameInfo);
    }

    public void oneUserBreakLine(String string) {
        this.delUser(string);
        this.userList.del(string);
        Vector vector = new Vector();
        Enumeration<GoRoom> enumeration = this.rooms.elements();
        while (enumeration.hasMoreElements()) {
            GoRoom goRoom = enumeration.nextElement();
            if (!goRoom.isMember(string)) continue;
            goRoom.goOut(string);
            if (goRoom.userinfos.size() == 0) {
                vector.add(goRoom);
                this.newGameList.del(goRoom.roomNumber);
                this.runGameList.del(goRoom.roomNumber);
                continue;
            }
            this.newGameList.modify(goRoom);
            this.runGameList.modify(goRoom);
        }
        for (GoeRoom object : this.goeRooms) {
            object.goOut(string);
            object.memberBreakLine(string);
            for (GoRoom goRoom : vector) {
                if (object.coreData.roomNumber != goRoom.roomNumber) continue;
                Global.goRootPane.remove(object);
            }
        }
        for (GoRoom goRoom : vector) {
            this.rooms.remove(goRoom);
        }
    }

    public void oneUserBreakLineTimeOut(String string) {
    }

    public void oneRoomCreated(GoRoom goRoom) {
        if (goRoom.status.getValue() == 1) {
            this.newGameList.add(goRoom);
        } else {
            this.runGameList.add(goRoom);
        }
        this.rooms.add(goRoom);
        if (goRoom.isMember(Global.myUserInfo.userName)) {
            GoeRoom goeRoom = new GoeRoom(goRoom);
            this.goeRooms.add(goeRoom);
            Global.goRootPane.add(goRoom.roomNumber + " ", goeRoom);
            Global.rootPane.setSelectedComponent(Global.goRootPane);
            Global.goRootPane.setSelectedComponent(goeRoom);
            if (goRoom.isFirstMember(Global.myUserInfo.userName)) {
                UserAllInfo userAllInfo = goRoom.secondMember();
                if (userAllInfo == null) {
                    return;
                }
                new ChallengeWithRule(Global.root, userAllInfo.info, goRoom.roomNumber);
            }
        }
    }

    public void oneRoomEnd(int n) {
        this.newGameList.del(n);
        this.runGameList.del(n);
        this.delRoom(n);
        GoeRoom goeRoom = this.search(n);
        if (goeRoom != null) {
            this.goeRooms.remove(goeRoom);
            Global.goRootPane.remove(goeRoom);
        }
    }

    public int getGoeRoomsCount() {
        return this.goeRooms.size();
    }

    public void removeGoeRoom(GoeRoom goeRoom) {
        this.goeRooms.remove(goeRoom);
    }

    protected GoeRoom search(int n) {
        for (GoeRoom goeRoom : this.goeRooms) {
            if (goeRoom.coreData.roomNumber != n) continue;
            return goeRoom;
        }
        return null;
    }

    protected void modifyGoeRooms(UserAllInfo userAllInfo) {
        for (GoeRoom goeRoom : this.goeRooms) {
            goeRoom.memberList.modify(userAllInfo);
        }
    }

    public void userGoInRoom(String string, int n) {
        for (GoRoom goRoom : this.rooms) {
            UserAllInfo userAllInfo;
            if (goRoom.roomNumber != n || (userAllInfo = this.search(string)) == null) continue;
            goRoom.goIn(userAllInfo);
            this.newGameList.modify(goRoom);
            this.runGameList.modify(goRoom);
            if (Global.myUserInfo.userName.equals(string)) {
                GoeRoom goeRoom = new GoeRoom(goRoom);
                this.goeRooms.add(goeRoom);
                Global.goRootPane.add(goRoom.roomNumber + " ", goeRoom);
                Global.goRootPane.setSelectedComponent(goeRoom);
                break;
            }
            GoeRoom goeRoom = this.search(n);
            if (goeRoom == null) break;
            goeRoom.goIn(userAllInfo);
            break;
        }
    }

    public void userGoOutRoom(String string, int n) {
        for (GoRoom goRoom : this.rooms) {
            UserAllInfo userAllInfo;
            if (goRoom.roomNumber != n || (userAllInfo = this.search(string)) == null) continue;
            goRoom.goOut(userAllInfo);
            this.newGameList.modify(goRoom);
            this.runGameList.modify(goRoom);
            GoeRoom goeRoom = this.search(n);
            if (goeRoom == null) break;
            goeRoom.goOut(string);
            break;
        }
    }

    public void refuse(GoServerResponse goServerResponse) {
        String string = Global.lang.getKey("115_msg_user") + "'" + goServerResponse.be_challenged_user + "'" + Global.lang.getKey("115_msg_refuse");
        this.systemBbs.displayMessage(this.systemBbs.display.redItalic, string);
        for (GoeRoom goeRoom : this.goeRooms) {
            goeRoom.chat.displayMessage(goeRoom.chat.display.redItalic, string);
        }
    }

    public void displayMessage(ServerMessage serverMessage) {
        block0 : switch (serverMessage.type) {
            case 0: {
                this.systemBbs.displayMessage(serverMessage);
                for (GoeRoom goeRoom : this.goeRooms) {
                    goeRoom.displayMessage(serverMessage);
                }
                break;
            }
            case 1: {
                break;
            }
            case 10: {
                this.systemBbs.displayMessage(serverMessage);
                break;
            }
            case 11: {
                for (GoeRoom goeRoom : this.goeRooms) {
                    if (goeRoom.coreData.roomNumber != serverMessage.roomNumber) continue;
                    goeRoom.displayMessage(serverMessage);
                    break block0;
                }
                break;
            }
            case 12: {
                Global.goCollogue.displayMessage(serverMessage);
                break;
            }
        }
    }

    public void displayMessage(String string) {
        this.systemBbs.displayMessage(null, string);
    }

    public void beginGame(GoGameRecord goGameRecord, int n) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.beginGame(goGameRecord);
    }

    public void agreeStudyGame(String string, int n) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.agreeStudyGame(string);
    }

    public void refuseStudyGame(String string, int n) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.refuseStudyGame(string);
    }

    public void beginStudyGame(int n) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.beginStudyGame();
        this.runGameList.modify(goeRoom.coreData);
    }

    public void endStudyGame(int n) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.endStudyGame();
    }

    public void publishGameStatus(RoomStatus roomStatus, int n) {
        GoRoom goRoom = this.searchRoom(n);
        if (goRoom == null) {
            return;
        }
        RoomStatus roomStatus2 = goRoom.status;
        goRoom.status = roomStatus;
        if (roomStatus2.getValue() == 1 && roomStatus.getValue() == 5) {
            this.newGameList.del(goRoom.roomNumber);
            this.runGameList.add(goRoom);
        } else if (roomStatus.getValue() == 1) {
            this.runGameList.del(goRoom.roomNumber);
            this.newGameList.add(goRoom);
        } else {
            goRoom.status = roomStatus;
            this.runGameList.modify(goRoom);
        }
    }

    public void publishGameRecordHead(GoGameRecord goGameRecord, int n) {
        GoRoom goRoom = this.searchRoom(n);
        if (goRoom == null) {
            return;
        }
        goRoom.black = goGameRecord.black;
        goRoom.white = goGameRecord.white;
    }

    public void publishUserGameCount(String string, int n, int n2) {
        UserAllInfo userAllInfo = this.search(string);
        if (userAllInfo == null) {
            return;
        }
        userAllInfo.tmpInfo.go.currentInGameTotal = n;
        userAllInfo.tmpInfo.go.currentSeeGameTotal = n2;
        this.userList.modify(userAllInfo);
    }

    public void sendRecordQiZi(GoRecordQiZi goRecordQiZi, int n, boolean bl) {
        GoeRoom goeRoom = this.search(n);
        if (goeRoom == null) {
            return;
        }
        goeRoom.appendRecordQiZi(goRecordQiZi, bl);
    }

    public void infoHeadChange(UserInfo userInfo) {
        UserAllInfo userAllInfo = this.search(userInfo.userName);
        if (userAllInfo == null) {
            return;
        }
        userAllInfo.info = userInfo;
        this.userList.modify(userAllInfo);
        this.modifyGoeRooms(userAllInfo);
    }

    public void infoChange(UserInfo userInfo, UserTmpInfo userTmpInfo) {
        UserAllInfo userAllInfo = this.search(userInfo.userName);
        if (userAllInfo == null) {
            return;
        }
        userAllInfo.info = userInfo;
        userAllInfo.tmpInfo = userTmpInfo;
        this.userList.modify(userAllInfo);
        this.modifyGoeRooms(userAllInfo);
    }

    public void reportUserDetial(boolean bl, UserInfo userInfo, GoRoomInfos goRoomInfos, int n) {
        UserGoInfoPane2 userGoInfoPane2 = new UserGoInfoPane2(userInfo, goRoomInfos, bl);
        if (n < 0) {
            this.tabbedInfoPane.addInfoPane(userGoInfoPane2);
        } else {
            GoeRoom goeRoom = this.search(n);
            if (goeRoom != null) {
                goeRoom.addInfoPane(userGoInfoPane2);
            }
        }
    }

    public void userNoFind(String string, int n) {
        String string2 = Global.lang.getKey("125_user") + " '" + string + "' " + Global.lang.getKey("125_no_exist");
        if (n < 0) {
            this.displayMessage(string2);
        } else {
            GoeRoom goeRoom = this.search(n);
            if (goeRoom != null) {
                goeRoom.displayMessage(string2);
            }
        }
    }

    public void returnGoGameIndex(String string, Vector<GoGameIndex> vector, int n) {
        GoeSeeGameRecordPane goeSeeGameRecordPane = Global.goRootPane.selectGoeSeeGameRecordPane(string);
        if (goeSeeGameRecordPane != null) {
            goeSeeGameRecordPane.addIndex(vector, n);
        }
    }

    public void returnGoGameRecord(String string, GoGameRecord goGameRecord) {
        GoeSeeGameRecordPane goeSeeGameRecordPane = Global.goRootPane.selectGoeSeeGameRecordPane(string);
        if (goeSeeGameRecordPane != null) {
            goeSeeGameRecordPane.setGoGameRecord(goGameRecord);
        }
    }

    private void setAllSize() {
        Dimension dimension = this.getSize();
        this.center.setDividerLocation(0.57);
        this.right.setDividerLocation(0.62);
        this.left.setDividerLocation(0.4);
        this.right.setPreferredSize(new Dimension(dimension.width * 30 / 100, dimension.height));
        this.right.revalidate();
        this.left.revalidate();
        this.center.revalidate();
        this.revalidate();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoRoomPanel.this.setAllSize();
        }
    }
}

