/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom.qp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import tianyuan.games.gui.goe.goeroom.qp.BoardMouseAdapter;
import tianyuan.games.gui.goe.goeroom.qp.CvsQiPanSpec;
import tianyuan.games.gui.goe.goeroom.qp.DispQiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiPanPosition;
import tianyuan.games.gui.goe.goeroom.qp.WeiQiType;
import tianyuan.games.gui.goe.goeroom.qp.jago.EmptyPaint;

public class CvsQiPan
extends JPanel
implements CvsQiPanSpec,
Printable {
    private byte gType = (byte)2;
    private byte visualMode = (byte)4;
    private static final Color bk_color_light = new Color(212, 187, 49);
    private static final Color bk_color_saturated;
    private static Color bk_color;
    private static final Color qizi_white;
    private static final Color qizi_black;
    private static final int MIN_STEP = 12;
    private static final int MAX_STEP = 200;
    private int bx = 12;
    private int by = 12;
    private int step = 100;
    private int boardBx = 0;
    private int boardBy = 0;
    private int boardEx = this.bx + this.step * 19 + this.bx - this.boardBx;
    private int boardEy = this.by + this.step * 19 + this.by - this.boardBy;
    private int daoBoardBx = 0;
    private int daoBoardEx = 0;
    private int daoBoardBy = 0;
    private int daoBoardEy = 0;
    private int daoBx;
    private int daoBy;
    private double daoStep = 0.0;
    private boolean saturatedBoardColor = true;
    private boolean displayNumber = false;
    private boolean identifyLast = true;
    private boolean qz3D = true;
    private boolean bigStone = true;
    private boolean showTarget = true;
    private boolean woodBoard = true;
    private boolean showCoordinate = true;
    private int originX = 0;
    private int originY = 0;
    private DispQiPan dqp = new DispQiPan();
    private Color visual_bk_color = Color.lightGray;
    public QiPanPosition target = new QiPanPosition(-1, -1);
    private static final Color targetColor;
    private boolean idLastWithNumber = false;
    private Image BlackStone = null;
    private Image WhiteStone = null;
    private static Color boardColor;
    private static final double pixel = 0.8;
    private static final double shadow = 0.7;
    private EmptyPaint epThread = null;
    private static final int[] indexYr;
    private static final char[] indexXr;
    private SizeListener seeSize = new SizeListener();

    public void setGType(byte by) {
        this.gType = by;
    }

    public byte getGType() {
        if (WeiQiType.type == 1) {
            return this.gType;
        }
        return WeiQiType.type;
    }

    public void setVisualMode(byte by) {
        this.visualMode = by;
    }

    protected byte getVisualMode() {
        return this.visualMode;
    }

    public CvsQiPan() {
        this.setToolTipText("");
        this.addMouseMotionListener(new MouseMotion());
        this.addMouseListener(new MouseExitAndDrop(this));
        this.resetStep();
        this.repaint();
    }

    @Override
    public QiPanPosition getPosition(int n, int n2) {
        if (this.getGType() == 2) {
            return this.getPositionGoe(n, n2);
        }
        if (this.getGType() == 3) {
            return this.getPositionDao(n, n2);
        }
        if (this.getGType() == 4) {
            return this.getPositionYuan(n, n2);
        }
        if (this.getGType() == 5) {
            return this.getPositionMobi(n, n2);
        }
        return new QiPanPosition(0, 0);
    }

    private QiPanPosition getPositionDao(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (int)((this.daoStep + 1.0) / 2.0);
        if (n < this.daoBx - n6 | n > (n5 = (int)((double)this.daoBx + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6 | n2 < this.daoBy - n6 | n2 > (n4 = (int)((double)this.daoBy + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6) {
            return null;
        }
        int n7 = -1;
        int n8 = -1;
        for (n3 = 0; n3 <= 18 + this.getVisualMode() * 2; ++n3) {
            if (n > (int)((double)this.daoBx + this.daoStep * (double)n3 + (double)n6) || n < (int)((double)this.daoBx + this.daoStep * (double)n3 - (double)n6)) continue;
            n7 = n3;
            break;
        }
        for (n3 = 0; n3 <= 18 + this.getVisualMode() * 2; ++n3) {
            if (n2 > (int)((double)this.daoBy + this.daoStep * (double)n3 + (double)n6) || n2 < (int)((double)this.daoBy + this.daoStep * (double)n3 - (double)n6)) continue;
            n8 = n3;
            break;
        }
        if (n7 == -1 || n8 == -1) {
            return null;
        }
        n8 -= this.getVisualMode();
        if ((n7 -= this.getVisualMode()) < 0) {
            n7 += 19;
        }
        if (n7 > 18) {
            n7 -= 19;
        }
        if (n8 < 0) {
            n8 += 19;
        }
        if (n8 > 18) {
            n8 -= 19;
        }
        n7 = (n7 - this.originX) % 19;
        n8 = (n8 - this.originY) % 19;
        if (n7 < 0) {
            n7 += 19;
        }
        if (n7 > 18) {
            n7 -= 19;
        }
        if (n8 < 0) {
            n8 += 19;
        }
        if (n8 > 18) {
            n8 -= 19;
        }
        return new QiPanPosition(n7, n8);
    }

    private QiPanPosition getPositionMobi(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (int)((this.daoStep + 1.0) / 2.0);
        if (n < this.daoBx - n6 | n > (n5 = (int)((double)this.daoBx + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6 | n2 < this.daoBy - n6 | n2 > (n4 = (int)((double)this.daoBy + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6) {
            return null;
        }
        int n7 = -1;
        int n8 = -1;
        for (n3 = 0; n3 <= 18 + this.getVisualMode() * 2; ++n3) {
            if (n > (int)((double)this.daoBx + this.daoStep * (double)n3 + (double)n6) || n < (int)((double)this.daoBx + this.daoStep * (double)n3 - (double)n6)) continue;
            n7 = n3;
            break;
        }
        for (n3 = (int)this.getVisualMode(); n3 <= 18 + this.getVisualMode(); ++n3) {
            if (n2 > (int)((double)this.daoBy + this.daoStep * (double)n3 + (double)n6) || n2 < (int)((double)this.daoBy + this.daoStep * (double)n3 - (double)n6)) continue;
            n8 = n3;
            break;
        }
        if (n7 == -1 || n8 == -1) {
            return null;
        }
        n7 -= this.getVisualMode();
        if ((n8 -= this.getVisualMode()) < 0) {
            n8 += 19;
        }
        if (n8 > 18) {
            n8 -= 19;
        }
        if (n7 < 0 || n7 > 18) {
            if (n7 < 0) {
                n7 += 19;
            }
            if (n7 > 18) {
                n7 -= 19;
            }
            n8 = 18 - n8;
        }
        if ((n7 = (n7 - this.originX) % 19) < 0) {
            n7 += 19;
        }
        if (n7 > 18) {
            n7 -= 19;
        }
        return new QiPanPosition(n7, n8);
    }

    private QiPanPosition getPositionYuan(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (int)((this.daoStep + 1.0) / 2.0);
        if (n < this.daoBx - n6 | n > (n5 = (int)((double)this.daoBx + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6 | n2 < this.daoBy - n6 | n2 > (n4 = (int)((double)this.daoBy + (double)(18 + this.getVisualMode() * 2) * this.daoStep)) + n6) {
            return null;
        }
        int n7 = -1;
        int n8 = -1;
        for (n3 = 0; n3 <= 18 + this.getVisualMode() * 2; ++n3) {
            if (n > (int)((double)this.daoBx + this.daoStep * (double)n3 + (double)n6) || n < (int)((double)this.daoBx + this.daoStep * (double)n3 - (double)n6)) continue;
            n7 = n3;
            break;
        }
        for (n3 = (int)this.getVisualMode(); n3 <= 18 + this.getVisualMode(); ++n3) {
            if (n2 > (int)((double)this.daoBy + this.daoStep * (double)n3 + (double)n6) || n2 < (int)((double)this.daoBy + this.daoStep * (double)n3 - (double)n6)) continue;
            n8 = n3;
            break;
        }
        if (n7 == -1 || n8 == -1) {
            return null;
        }
        n8 -= this.getVisualMode();
        if ((n7 -= this.getVisualMode()) < 0) {
            n7 += 19;
        }
        if (n7 > 18) {
            n7 -= 19;
        }
        if (n8 < 0) {
            n8 += 19;
        }
        if (n8 > 18) {
            n8 -= 19;
        }
        if ((n7 = (n7 - this.originX) % 19) < 0) {
            n7 += 19;
        }
        if (n7 > 18) {
            n7 -= 19;
        }
        return new QiPanPosition(n7, n8);
    }

    private QiPanPosition getPositionGoe(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (this.step + 1) / 2;
        if (n < this.bx - n6 | n > (n5 = this.bx + 18 * this.step) + n6 | n2 < this.by - n6 | n2 > (n4 = this.by + 18 * this.step) + n6) {
            return null;
        }
        int n7 = -1;
        int n8 = -1;
        for (n3 = 0; n3 <= 18; ++n3) {
            if (!(n <= this.bx + this.step * n3 + n6 & n >= this.bx + this.step * n3 - n6)) continue;
            n7 = n3;
            break;
        }
        for (n3 = 0; n3 <= 18; ++n3) {
            if (!(n2 <= this.by + this.step * n3 + n6 & n2 >= this.by + this.step * n3 - n6)) continue;
            n8 = n3;
            break;
        }
        if (n7 != -1 && n8 != -1) {
            return new QiPanPosition(n7, n8);
        }
        return null;
    }

    @Override
    public boolean reSetQiPan() {
        this.resetStep();
        this.repaint();
        return true;
    }

    private void resetStep() {
        if (this.getGType() == 2) {
            this.resetStepGoe();
        } else if (this.getGType() == 3) {
            this.resetStepDao();
        } else if (this.getGType() == 4 || this.getGType() == 5) {
            this.resetStepYuan();
        }
    }

    private void resetStepYuan() {
        this.resetStepDao();
    }

    private void resetStepDao() {
        double d;
        Dimension dimension = this.getSize();
        int n = 0;
        if (this.showCoordinate) {
            n = 19 + this.getVisualMode() * 2 + 2;
            this.daoBoardBx = this.daoBoardBy = dimension.height / n;
            this.daoBoardEx = this.daoBoardEy = dimension.height - this.daoBoardBx;
        } else {
            n = 19 + this.getVisualMode() * 2;
            this.daoBoardBy = 3;
            this.daoBoardBx = 3;
            this.daoBoardEx = this.daoBoardEy = dimension.height - this.daoBoardBx;
        }
        double d2 = this.daoBoardEx - this.daoBoardBx;
        this.daoStep = d = d2 / (double)(19 + this.getVisualMode() * 2);
        this.step = (int)this.daoStep;
        double d3 = d2 - d * (double)(19 + this.getVisualMode() * 2 - 1);
        this.bx = this.by = (this.daoBx = (this.daoBy = (int)(d3 / 2.0 + (double)this.daoBoardBx)));
        this.boardBx = this.boardBy = (int)((double)this.daoBoardBx + this.daoStep * (double)this.getVisualMode());
        this.boardEx = this.boardEy = (int)((double)this.daoBoardEx - this.daoStep * (double)this.getVisualMode());
    }

    private void resetStepGoe() {
        int n;
        Dimension dimension = this.getSize();
        if (this.showCoordinate) {
            int n2;
            this.boardBx = this.boardBy = dimension.height / 21;
            this.boardEx = this.boardEy = dimension.height - this.boardBx;
            int n3 = this.boardEx - this.boardBx;
            this.step = n2 = n3 / 19;
            int n4 = n3 - n2 * 18;
            this.bx = this.by = n4 / 2 + this.boardBx;
            return;
        }
        this.boardBy = 3;
        this.boardBx = 3;
        this.boardEx = this.boardEy = dimension.height - this.boardBx;
        int n5 = this.boardEx - this.boardBx;
        this.step = n = n5 / 19;
        int n6 = n5 - n * 18;
        this.bx = this.by = n6 / 2 + this.boardBx;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    public void setSaturatedBoardColor(boolean bl) {
        this.saturatedBoardColor = bl;
        bk_color = this.saturatedBoardColor ? bk_color_saturated : bk_color_light;
        this.repaint();
    }

    public boolean getSaturatedBoardColor() {
        return this.saturatedBoardColor;
    }

    @Override
    public void setNumberDisplay(boolean bl) {
        this.displayNumber = bl;
        this.repaint();
    }

    @Override
    public void setIdentifyLast(boolean bl) {
        this.identifyLast = bl;
    }

    @Override
    public void set3DQiZi(boolean bl) {
        this.qz3D = bl;
        this.repaint();
    }

    public boolean get3DQiZi() {
        return this.qz3D;
    }

    @Override
    public void setBigQiZi(boolean bl) {
        this.bigStone = bl;
        this.repaint();
    }

    public boolean getBigQiZi() {
        return this.bigStone;
    }

    @Override
    public void setShowTarget(boolean bl) {
        this.showTarget = bl;
        this.repaint();
    }

    public boolean getShowTarget() {
        return this.showTarget;
    }

    @Override
    public void setWoodBoard(boolean bl) {
        this.woodBoard = bl;
        this.repaint();
    }

    public boolean getWoodboard() {
        return this.woodBoard;
    }

    @Override
    public void setShowCoordinate(boolean bl) {
        this.showCoordinate = bl;
        this.repaint();
    }

    public boolean getShowCoordinate() {
        return this.showCoordinate;
    }

    public void setAllFlag(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.displayNumber = bl;
        this.idLastWithNumber = bl2;
        this.qz3D = bl3;
        this.bigStone = bl4;
        this.showTarget = bl5;
        this.woodBoard = bl6;
        this.showCoordinate = bl8;
        this.saturatedBoardColor = bl7;
        bk_color = bl7 ? bk_color_saturated : bk_color_light;
        this.repaint();
    }

    @Override
    public void updateboard() {
        this.repaint();
    }

    @Override
    public void setDispQiPan(DispQiPan dispQiPan) {
        this.dqp = dispQiPan;
    }

    public DispQiPan getDispQiPan() {
        return this.dqp;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.updateAll(graphics);
    }

    protected void updateAll(Graphics graphics) {
        if (this.getGType() == 2) {
            this.resetStepGoe();
            this.drawBackground(graphics);
            this.drawQiGeGoe(graphics);
            this.drawCoordinateGoe((Graphics2D)graphics);
            this.draw_all_qizi_Goe(graphics, this.dqp);
            this.showTarget(graphics);
        } else if (this.getGType() == 3) {
            DispQiPan dispQiPan = DispQiPan.coordinateTransfer(this.originX, this.originY, this.dqp);
            this.resetStepDao();
            this.drawBackgroundDao(graphics);
            this.drawQiGeDao(graphics);
            this.drawCoordinateDao((Graphics2D)graphics);
            this.draw_all_qizi_Dao(graphics, dispQiPan);
            this.showTarget(graphics);
        } else if (this.getGType() == 4) {
            DispQiPan dispQiPan = DispQiPan.coordinateTransfer(this.originX, this.originY, this.dqp);
            this.resetStepYuan();
            this.drawBackgroundYuan(graphics);
            this.drawQiGeYuan(graphics);
            this.drawCoordinateYuan((Graphics2D)graphics);
            this.draw_all_qizi_Yuan(graphics, dispQiPan);
            this.showTarget(graphics);
        } else if (this.getGType() == 5) {
            DispQiPan dispQiPan = DispQiPan.coordinateTransfer(this.originX, this.originY, this.dqp);
            this.resetStepYuan();
            this.drawBackgroundMobi(graphics);
            this.drawQiGeYuan(graphics);
            this.drawCoordinateYuan((Graphics2D)graphics);
            this.draw_all_qizi_Mobi(graphics, dispQiPan);
            this.showTarget(graphics);
        }
    }

    protected void drawBackgroundDao(Graphics graphics) {
        this.drawBackgroundVisual(graphics);
    }

    private void drawBackgroundVisual(Graphics graphics) {
        bk_color = this.saturatedBoardColor ? bk_color_saturated : bk_color_light;
        boolean bl = false;
        int n = 19 + this.getVisualMode() * 2;
        double d = 0.0;
        double d2 = this.daoStep * (double)(n - 1);
        graphics.setColor(this.visual_bk_color);
        if (this.getGType() == 5 || this.getGType() == 4) {
            if (this.getGType() == 4) {
                graphics.setColor(Color.gray);
            }
            if (this.getShowCoordinate()) {
                graphics.fillRect((int)((double)this.daoBx - this.daoStep / 2.0), this.boardBy, (int)((double)this.daoBx + d2 - this.daoStep / 2.0 + 2.0), this.boardEy - this.boardBy);
                graphics.setColor(Color.black);
                graphics.drawRect((int)((double)this.daoBx - this.daoStep / 2.0), this.boardBy, (int)((double)this.daoBx + d2 - this.daoStep / 2.0 + 2.0), this.boardEy - this.boardBy);
            } else {
                graphics.fillRect((int)((double)this.daoBx - this.daoStep / 2.0), this.boardBy, (int)((double)this.daoBx + d2 + this.daoStep / 2.0 - 2.0), this.boardEy - this.boardBy);
                graphics.setColor(Color.black);
                graphics.drawRect((int)((double)this.daoBx - this.daoStep / 2.0), this.boardBy, (int)((double)this.daoBx + d2 + this.daoStep / 2.0 - 2.0), this.boardEy - this.boardBy);
            }
        } else if (this.getGType() == 3) {
            if (this.getShowCoordinate()) {
                graphics.fillRect((int)((double)this.daoBx - this.daoStep / 2.0), (int)((double)this.daoBy - this.daoStep / 2.0), (int)((double)this.daoBx + d2 - this.daoStep / 2.0 + 2.0), (int)((double)this.daoBy + d2 - this.daoStep / 2.0 + 2.0));
                graphics.setColor(Color.black);
                graphics.drawRect((int)((double)this.daoBx - this.daoStep / 2.0), (int)((double)this.daoBy - this.daoStep / 2.0), (int)((double)this.daoBx + d2 - this.daoStep / 2.0 + 2.0), (int)((double)this.daoBy + d2 - this.daoStep / 2.0 + 2.0));
            } else {
                graphics.fillRect((int)((double)this.daoBx - this.daoStep / 2.0), (int)((double)this.daoBy - this.daoStep / 2.0), (int)((double)this.daoBx + d2 + this.daoStep / 2.0 - 2.0), (int)((double)this.daoBy + d2 + this.daoStep / 2.0 - 2.0));
                graphics.setColor(Color.black);
                graphics.drawRect((int)((double)this.daoBx - this.daoStep / 2.0), (int)((double)this.daoBy - this.daoStep / 2.0), (int)((double)this.daoBx + d2 + this.daoStep / 2.0 - 2.0), (int)((double)this.daoBy + d2 + this.daoStep / 2.0 - 2.0));
            }
        }
        graphics.setColor(bk_color);
        graphics.fillRect(this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy);
        if (!this.woodBoard) {
            graphics.setColor(Color.black);
            graphics.drawRect(this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy);
        }
        if (this.woodBoard) {
            this.trywood(graphics);
        }
    }

    protected void drawBackgroundYuan(Graphics graphics) {
        this.drawBackgroundVisual(graphics);
    }

    protected void drawBackgroundMobi(Graphics graphics) {
        this.drawBackgroundVisual(graphics);
    }

    protected void drawBackground(Graphics graphics) {
        bk_color = this.saturatedBoardColor ? bk_color_saturated : bk_color_light;
        graphics.setColor(bk_color);
        graphics.fillRect(this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy);
        if (!this.woodBoard) {
            graphics.setColor(Color.black);
            graphics.drawRect(this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy);
        }
        if (this.woodBoard) {
            this.trywood(graphics);
        }
    }

    protected void drawQiGeGoe(Graphics graphics) {
        this.draw_line_and_xing_Goe(this.bx, this.by, this.step, graphics);
    }

    protected void drawQiGeDao(Graphics graphics) {
        this.draw_line_and_xing_Dao(this.daoBx, this.daoBy, this.daoStep, graphics);
    }

    protected void drawQiGeYuan(Graphics graphics) {
        this.draw_line_and_xing_Yuan(this.daoBx, this.daoBy, this.daoStep, graphics);
    }

    private void draw_line_and_xing_Dao(int n, int n2, double d, Graphics graphics) {
        int n3 = 0;
        int n4 = 19 + this.getVisualMode() * 2;
        double d2 = 0.0;
        double d3 = d * (double)(n4 - 1);
        graphics.setColor(Color.black);
        for (n3 = 0; n3 < n4; ++n3) {
            graphics.drawLine((int)(d2 + (double)n), n2, (int)(d2 + (double)n), (int)((double)n2 + d3));
            graphics.drawLine(n, (int)((double)n2 + d2), (int)((double)n + d3), (int)((double)n2 + d2));
            d2 += d;
        }
        int n5 = (int)(d / 6.0);
        int n6 = n5 * 2;
        for (int i = 3 + this.getVisualMode(); i <= 15 + this.getVisualMode(); i += 6) {
            for (int j = 3 + this.getVisualMode(); j <= 15 + this.getVisualMode(); j += 6) {
                graphics.fillArc((int)((double)n + (double)i * d - (double)n5), (int)((double)n2 + (double)j * d - (double)n5), n6, n6, 0, 360);
            }
        }
    }

    private void draw_line_and_xing_Yuan(int n, int n2, double d, Graphics graphics) {
        int n3 = 0;
        int n4 = 19 + this.getVisualMode() * 2;
        double d2 = 0.0;
        double d3 = d * (double)(n4 - 1);
        graphics.setColor(Color.black);
        for (n3 = 0; n3 < n4; ++n3) {
            graphics.drawLine((int)(d2 + (double)n), (int)((double)n2 + d * (double)this.getVisualMode()), (int)(d2 + (double)n), (int)((double)n2 + d3 - d * (double)this.getVisualMode()));
            if (n3 >= this.getVisualMode() && n3 < n4 - this.getVisualMode()) {
                graphics.drawLine(n, (int)((double)n2 + d2), (int)((double)n + d3), (int)((double)n2 + d2));
            }
            d2 += d;
        }
        int n5 = (int)(d / 6.0);
        int n6 = n5 * 2;
        for (int i = 3 + this.getVisualMode(); i <= 15 + this.getVisualMode(); i += 6) {
            for (int j = 3 + this.getVisualMode(); j <= 15 + this.getVisualMode(); j += 6) {
                graphics.fillArc((int)((double)n + (double)i * d - (double)n5), (int)((double)n2 + (double)j * d - (double)n5), n6, n6, 0, 360);
            }
        }
    }

    private void draw_line_and_xing_Goe(int n, int n2, int n3, Graphics graphics) {
        int n4 = 0;
        int n5 = 19;
        int n6 = 0;
        int n7 = n3 * (n5 - 1);
        graphics.setColor(Color.black);
        for (n4 = 0; n4 < n5; ++n4) {
            graphics.drawLine(n6 + n, n2, n6 + n, n2 + n7);
            graphics.drawLine(n, n2 + n6, n + n7, n2 + n6);
            n6 += n3;
        }
        int n8 = n3 / 6;
        int n9 = n8 * 2;
        for (int i = 3; i <= 15; i += 6) {
            for (int j = 3; j <= 15; j += 6) {
                graphics.fillArc(n + i * n3 - n8, n2 + j * n3 - n8, n9, n9, 0, 360);
            }
        }
    }

    protected void draw_all_qizi_Dao(Graphics graphics, DispQiPan dispQiPan) {
        this.re_draw_qizi_Dao(graphics, dispQiPan, this.daoBx, this.daoBy, this.daoStep, qizi_white, qizi_black);
    }

    protected void draw_all_qizi_Mobi(Graphics graphics, DispQiPan dispQiPan) {
        this.re_draw_qizi_Mobi(graphics, dispQiPan, this.daoBx, this.daoBy, this.daoStep, qizi_white, qizi_black);
    }

    protected void draw_all_qizi_Yuan(Graphics graphics, DispQiPan dispQiPan) {
        this.re_draw_qizi_Yuan(graphics, dispQiPan, this.daoBx, this.daoBy, this.daoStep, qizi_white, qizi_black);
    }

    protected void draw_all_qizi_Goe(Graphics graphics, DispQiPan dispQiPan) {
        this.re_draw_qizi_Goe(graphics, dispQiPan, this.bx, this.by, this.step, qizi_white, qizi_black);
    }

    private void re_draw_qizi_Dao(Graphics graphics, DispQiPan dispQiPan, int n, int n2, double d, Color color, Color color2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.qz3D) {
            n3 = 0;
            n3 = this.bigStone ? (int)d : (int)(d * 6.0 / 7.0);
            this.stonePaint(n3, this);
        }
        int n4 = dispQiPan.maxNumber();
        for (n3 = 0; n3 <= 18; ++n3) {
            for (int i = 0; i <= 18; ++i) {
                boolean bl = dispQiPan.number[n3][i] == n4;
                this.draw_qizi_Dao(n3 + 1, i + 1, dispQiPan.value[n3][i], dispQiPan.tmpFlag[n3][i], dispQiPan.flag[n3][i], graphics2D, n, n2, d, dispQiPan.number[n3][i], bl, color, color2);
            }
        }
    }

    private void re_draw_qizi_Mobi(Graphics graphics, DispQiPan dispQiPan, int n, int n2, double d, Color color, Color color2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.qz3D) {
            n3 = 0;
            n3 = this.bigStone ? (int)d : (int)(d * 6.0 / 7.0);
            this.stonePaint(n3, this);
        }
        int n4 = dispQiPan.maxNumber();
        for (n3 = 0; n3 <= 18; ++n3) {
            for (int i = 0; i <= 18; ++i) {
                boolean bl = dispQiPan.number[n3][i] == n4;
                this.draw_qizi_Mobi(n3 + 1, i + 1, dispQiPan.value[n3][i], dispQiPan.tmpFlag[n3][i], dispQiPan.flag[n3][i], graphics2D, n, n2, d, dispQiPan.number[n3][i], bl, color, color2);
            }
        }
    }

    private void re_draw_qizi_Yuan(Graphics graphics, DispQiPan dispQiPan, int n, int n2, double d, Color color, Color color2) {
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.qz3D) {
            n3 = 0;
            n3 = this.bigStone ? (int)d : (int)(d * 6.0 / 7.0);
            this.stonePaint(n3, this);
        }
        int n4 = dispQiPan.maxNumber();
        for (n3 = 0; n3 <= 18; ++n3) {
            for (int i = 0; i <= 18; ++i) {
                boolean bl = dispQiPan.number[n3][i] == n4;
                this.draw_qizi_Yuan(n3 + 1, i + 1, dispQiPan.value[n3][i], dispQiPan.tmpFlag[n3][i], dispQiPan.flag[n3][i], graphics2D, n, n2, d, dispQiPan.number[n3][i], bl, color, color2);
            }
        }
    }

    private void re_draw_qizi_Goe(Graphics graphics, DispQiPan dispQiPan, int n, int n2, int n3, Color color, Color color2) {
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.qz3D) {
            n4 = 0;
            n4 = this.bigStone ? n3 : n3 * 6 / 7;
            this.stonePaint(n4, this);
        }
        int n5 = dispQiPan.maxNumber();
        for (n4 = 0; n4 <= 18; ++n4) {
            for (int i = 0; i <= 18; ++i) {
                boolean bl = dispQiPan.number[n4][i] == n5;
                this.draw_qizi_Goe(n4 + 1, i + 1, dispQiPan.value[n4][i], dispQiPan.tmpFlag[n4][i], dispQiPan.flag[n4][i], graphics2D, n, n2, n3, dispQiPan.number[n4][i], bl, color, color2);
            }
        }
    }

    protected void draw_qizi_Dao(int n, int n2, int n3, boolean bl, byte by, Graphics2D graphics2D, int n4, int n5, double d, int n6, boolean bl2, Color color, Color color2) {
        if (n > 19 | n < 1 | n2 > 19 | n2 < 1) {
            return;
        }
        int n7 = (int)(d / 5.0 * 2.0);
        int n8 = n7 * 2;
        if (this.bigStone) {
            n7 = (int)(d / 2.0);
            n8 = n7 * 2;
        }
        int n9 = (int)((double)n4 + (double)(n - 1 + this.getVisualMode()) * d - (double)n7);
        int n10 = (int)((double)n5 + (double)(n2 - 1 + this.getVisualMode()) * d - (double)n7);
        this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
        byte by2 = this.getVisualMode();
        if (n <= by2 || n > 19 - by2 || n2 <= by2 || n2 > 19 - by2) {
            if (n <= by2 || n > 19 - by2) {
                n9 = n <= by2 ? (int)((double)n4 + (double)(n - 1 + by2 + 19) * d - (double)n7) : (int)((double)n4 + (double)(n - 1 + by2 - 19) * d - (double)n7);
                n10 = (int)((double)n5 + (double)(n2 - 1 + by2) * d - (double)n7);
                this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
            }
            if (n2 <= by2 || n2 > 19 - by2) {
                n9 = (int)((double)n4 + (double)(n - 1 + by2) * d - (double)n7);
                n10 = n2 <= by2 ? (int)((double)n5 + (double)(n2 - 1 + by2 + 19) * d - (double)n7) : (int)((double)n5 + (double)(n2 - 1 + by2 - 19) * d - (double)n7);
                this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
            }
            if (!(n > by2 && n <= 19 - by2 || n2 > by2 && n2 <= 19 - by2)) {
                n9 = n <= by2 ? (int)((double)n4 + (double)(n - 1 + by2 + 19) * d - (double)n7) : (int)((double)n4 + (double)(n - 1 + by2 - 19) * d - (double)n7);
                n10 = n2 <= by2 ? (int)((double)n5 + (double)(n2 - 1 + by2 + 19) * d - (double)n7) : (int)((double)n5 + (double)(n2 - 1 + by2 - 19) * d - (double)n7);
                this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
            }
        }
    }

    protected void draw_qizi_Dao_real(int n, int n2, int n3, boolean bl, byte by, Graphics2D graphics2D, int n4, int n5, double d, int n6, boolean bl2, int n7, int n8, Color color, Color color2) {
        int n9;
        int n10;
        int n11;
        if (n3 == 2) {
            if (this.qz3D) {
                this.draw3DStone(n, n2, n8, graphics2D, color2, color, false);
            } else {
                graphics2D.setColor(color);
                graphics2D.fillArc(n, n2, n8, n8, 0, 360);
                graphics2D.setColor(color2);
                graphics2D.drawArc(n, n2, n8, n8, 0, 360);
            }
            if (bl2 && this.identifyLast && n6 > 0 && by == 0) {
                this.drawLastIdentify(n6, n, n2, n8, graphics2D, color2);
            }
            if (this.displayNumber && n6 > 0 && by == 0) {
                this.drawNumber(n6, n, n2, n8, graphics2D, color2);
            }
        } else if (n3 == 1) {
            if (this.qz3D) {
                this.draw3DStone(n, n2, n8, graphics2D, color2, color, true);
            } else {
                graphics2D.setColor(color2);
                graphics2D.fillArc(n, n2, n8, n8, 0, 360);
            }
            if (bl2 && this.identifyLast && n6 > 0 && by == 0) {
                this.drawLastIdentify(n6, n, n2, n8, graphics2D, color);
            }
            if (this.displayNumber && n6 > 0 && by == 0) {
                this.drawNumber(n6, n, n2, n8, graphics2D, color);
            }
        }
        if (bl) {
            int n12 = n8 / 4;
            int n13 = n + n7;
            int n14 = n2 + n7;
            graphics2D.setColor(Color.red);
            graphics2D.fillRect(n13 - n12, n14 - n12, n12 * 2, n12 * 2);
            return;
        }
        if (by == 31 && n3 == 1) {
            n11 = n8 / 4;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 31 && n3 == 2) {
            n11 = n8 / 4;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 9) {
            n11 = n8 / 4;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 11) {
            n11 = n8 / 6;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 13) {
            n11 = n8 / 8;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 15) {
            n11 = n8 / 10;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 17) {
            n11 = n8 / 12;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 10) {
            n11 = n8 / 4;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 12) {
            n11 = n8 / 6;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 14) {
            n11 = n8 / 8;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 16) {
            n11 = n8 / 10;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
        if (by == 18) {
            n11 = n8 / 12;
            n10 = n + n7;
            n9 = n2 + n7;
            graphics2D.setColor(color);
            graphics2D.fillRect(n10 - n11, n9 - n11, n11 * 2, n11 * 2);
        }
    }

    protected void draw_qizi_Mobi(int n, int n2, int n3, boolean bl, byte by, Graphics2D graphics2D, int n4, int n5, double d, int n6, boolean bl2, Color color, Color color2) {
        if (n > 19 | n < 1 | n2 > 19 | n2 < 1) {
            return;
        }
        int n7 = (int)(d / 5.0 * 2.0);
        int n8 = n7 * 2;
        if (this.bigStone) {
            n7 = (int)(d / 2.0);
            n8 = n7 * 2;
        }
        int n9 = (int)((double)n4 + (double)(n - 1 + this.getVisualMode()) * d - (double)n7);
        int n10 = (int)((double)n5 + (double)(n2 - 1 + this.getVisualMode()) * d - (double)n7);
        this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
        byte by2 = this.getVisualMode();
        if (n <= by2 || n > 19 - by2) {
            n9 = n <= by2 ? (int)((double)n4 + (double)(n - 1 + by2 + 19) * d - (double)n7) : (int)((double)n4 + (double)(n - 1 + by2 - 19) * d - (double)n7);
            n10 = (int)((double)n5 + (double)(19 - n2 + by2) * d - (double)n7);
            this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
        }
    }

    protected void draw_qizi_Yuan(int n, int n2, int n3, boolean bl, byte by, Graphics2D graphics2D, int n4, int n5, double d, int n6, boolean bl2, Color color, Color color2) {
        if (n > 19 | n < 1 | n2 > 19 | n2 < 1) {
            return;
        }
        int n7 = (int)(d / 5.0 * 2.0);
        int n8 = n7 * 2;
        if (this.bigStone) {
            n7 = (int)(d / 2.0);
            n8 = n7 * 2;
        }
        int n9 = (int)((double)n4 + (double)(n - 1 + this.getVisualMode()) * d - (double)n7);
        int n10 = (int)((double)n5 + (double)(n2 - 1 + this.getVisualMode()) * d - (double)n7);
        this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
        byte by2 = this.getVisualMode();
        if (n <= by2 || n > 19 - by2) {
            n9 = n <= by2 ? (int)((double)n4 + (double)(n - 1 + by2 + 19) * d - (double)n7) : (int)((double)n4 + (double)(n - 1 + by2 - 19) * d - (double)n7);
            n10 = (int)((double)n5 + (double)(n2 - 1 + by2) * d - (double)n7);
            this.draw_qizi_Dao_real(n9, n10, n3, bl, by, graphics2D, n4, n5, d, n6, bl2, n7, n8, color, color2);
        }
    }

    protected void draw_qizi_Goe(int n, int n2, int n3, boolean bl, byte by, Graphics2D graphics2D, int n4, int n5, int n6, int n7, boolean bl2, Color color, Color color2) {
        int n8;
        int n9;
        int n10;
        if (n > 19 | n < 1 | n2 > 19 | n2 < 1) {
            return;
        }
        int n11 = n6 / 5 * 2;
        int n12 = n11 * 2;
        if (this.bigStone) {
            n11 = n6 / 2;
            n12 = n11 * 2;
        }
        int n13 = n4 + (n - 1) * n6 - n11;
        int n14 = n5 + (n2 - 1) * n6 - n11;
        if (n3 == 2) {
            if (this.qz3D) {
                this.draw3DStone(n13, n14, n12, graphics2D, color2, color, false);
            } else {
                graphics2D.setColor(color);
                graphics2D.fillArc(n13, n14, n12, n12, 0, 360);
                graphics2D.setColor(color2);
                graphics2D.drawArc(n13, n14, n12, n12, 0, 360);
            }
            if (bl2 && this.identifyLast && n7 > 0 && by == 0) {
                this.drawLastIdentify(n7, n13, n14, n12, graphics2D, color2);
            }
            if (this.displayNumber && n7 > 0 && by == 0) {
                this.drawNumber(n7, n13, n14, n12, graphics2D, color2);
            }
        } else if (n3 == 1) {
            if (this.qz3D) {
                this.draw3DStone(n13, n14, n12, graphics2D, color2, color, true);
            } else {
                graphics2D.setColor(color2);
                graphics2D.fillArc(n13, n14, n12, n12, 0, 360);
            }
            if (bl2 && this.identifyLast && n7 > 0 && by == 0) {
                this.drawLastIdentify(n7, n13, n14, n12, graphics2D, color);
            }
            if (this.displayNumber && n7 > 0 && by == 0) {
                this.drawNumber(n7, n13, n14, n12, graphics2D, color);
            }
        }
        if (bl) {
            int n15 = n12 / 4;
            int n16 = n13 + n11;
            int n17 = n14 + n11;
            graphics2D.setColor(Color.red);
            graphics2D.fillRect(n16 - n15, n17 - n15, n15 * 2, n15 * 2);
            return;
        }
        if (by == 31 && n3 == 1) {
            n10 = n12 / 4;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 31 && n3 == 2) {
            n10 = n12 / 4;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 9) {
            n10 = n12 / 4;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 11) {
            n10 = n12 / 6;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 13) {
            n10 = n12 / 8;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 15) {
            n10 = n12 / 10;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 17) {
            n10 = n12 / 12;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color2);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 10) {
            n10 = n12 / 4;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 12) {
            n10 = n12 / 6;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 14) {
            n10 = n12 / 8;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 16) {
            n10 = n12 / 10;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
        if (by == 18) {
            n10 = n12 / 12;
            n9 = n13 + n11;
            n8 = n14 + n11;
            graphics2D.setColor(color);
            graphics2D.fillRect(n9 - n10, n8 - n10, n10 * 2, n10 * 2);
        }
    }

    private void drawNumber(int n, int n2, int n3, int n4, Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        if (n >= 1 && n <= 9) {
            graphics2D.setFont(new Font("TimesRoman", 0, (int)((double)n4 * 0.92)));
            graphics2D.drawString("" + n, (int)((double)n2 + (double)n4 * 0.26), (int)((double)n3 + (double)n4 * 0.83));
        } else if (n >= 10 && n <= 99) {
            graphics2D.setFont(new Font("TimesRoman", 0, (int)((double)n4 * 0.78)));
            graphics2D.drawString("" + n, (int)((double)n2 + (double)n4 * 0.09), (int)((double)n3 + (double)n4 * 0.8));
        } else if (n >= 100 && n <= 999) {
            graphics2D.setFont(new Font("TimesRoman", 0, (int)((double)n4 * 0.6)));
            graphics2D.drawString("" + n, (int)((double)n2 + (double)n4 * 0.02), (int)((double)n3 + (double)n4 * 0.7));
        }
    }

    private void drawLastIdentify(int n, int n2, int n3, int n4, Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        if (!this.idLastWithNumber) {
            int n5 = n4 / 5;
            int n6 = n2 + n4 / 2;
            int n7 = n3 + n4 / 2;
            graphics2D.drawLine(n6 - n5, n7, n6 + n5, n7);
            graphics2D.drawLine(n6, n7 - n5, n6, n7 + n5);
        } else {
            this.drawNumber(n, n2, n3, n4, graphics2D, color);
        }
    }

    private void draw3DStone(int n, int n2, int n3, Graphics2D graphics2D, Color color, Color color2, boolean bl) {
        if (!bl) {
            graphics2D.drawImage(this.WhiteStone, n, n2, this);
        } else {
            graphics2D.drawImage(this.BlackStone, n, n2, this);
        }
    }

    private int transferOriginX(int n) {
        int n2 = (this.originX + n) % 19;
        if (n2 < 0) {
            n2 += 19;
        }
        return n2;
    }

    private int transferOriginY(int n) {
        int n2 = (this.originY + n) % 19;
        if (n2 < 0) {
            n2 += 19;
        }
        return n2;
    }

    private void showTargetDao(Graphics graphics) {
        if (this.target.x == -1) {
            return;
        }
        int n = this.transferOriginX(this.target.x) + 1;
        int n2 = this.transferOriginY(this.target.y) + 1;
        byte by = this.getVisualMode();
        int n3 = (int)(this.daoStep / 4.0);
        int n4 = n3 + n3;
        int n5 = (int)((double)this.daoBx + (double)(n - 1 + by) * this.daoStep - (double)n3);
        int n6 = (int)((double)this.daoBy + (double)(n2 - 1 + by) * this.daoStep - (double)n3);
        graphics.setColor(targetColor);
        graphics.drawRect(n5, n6, n4, n4);
        if (n <= by || n > 19 - by || n2 <= by || n2 > 19 - by) {
            if (n <= by || n > 19 - by) {
                n5 = n <= by ? (int)((double)this.daoBx + (double)(n - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBx + (double)(n - 1 + by - 19) * this.daoStep - (double)n3);
                n6 = (int)((double)this.daoBy + (double)(n2 - 1 + by) * this.daoStep - (double)n3);
                graphics.setColor(targetColor);
                graphics.drawRect(n5, n6, n4, n4);
            }
            if (n2 <= by || n2 > 19 - by) {
                n5 = (int)((double)this.daoBx + (double)(n - 1 + by) * this.daoStep - (double)n3);
                n6 = n2 <= by ? (int)((double)this.daoBy + (double)(n2 - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBy + (double)(n2 - 1 + by - 19) * this.daoStep - (double)n3);
                graphics.setColor(targetColor);
                graphics.drawRect(n5, n6, n4, n4);
            }
            if (!(n > by && n <= 19 - by || n2 > by && n2 <= 19 - by)) {
                n5 = n <= by ? (int)((double)this.daoBx + (double)(n - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBx + (double)(n - 1 + by - 19) * this.daoStep - (double)n3);
                n6 = n2 <= by ? (int)((double)this.daoBy + (double)(n2 - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBy + (double)(n2 - 1 + by - 19) * this.daoStep - (double)n3);
                graphics.setColor(targetColor);
                graphics.drawRect(n5, n6, n4, n4);
            }
        }
    }

    private void showTargetMobi(Graphics graphics) {
        if (this.target.x == -1) {
            return;
        }
        byte by = this.getVisualMode();
        int n = this.transferOriginX(this.target.x) + 1;
        int n2 = this.transferOriginY(this.target.y) + 1;
        int n3 = (int)(this.daoStep / 4.0);
        int n4 = n3 + n3;
        int n5 = (int)((double)this.daoBx + (double)(n - 1 + by) * this.daoStep - (double)n3);
        int n6 = (int)((double)this.daoBy + (double)(n2 - 1 + by) * this.daoStep - (double)n3);
        graphics.setColor(targetColor);
        graphics.drawRect(n5, n6, n4, n4);
        if (n <= by || n > 19 - by) {
            n5 = n <= by ? (int)((double)this.daoBx + (double)(n - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBx + (double)(n - 1 + by - 19) * this.daoStep - (double)n3);
            n6 = (int)((double)this.daoBy + (double)(19 - n2 + by) * this.daoStep - (double)n3);
            graphics.setColor(targetColor);
            graphics.drawRect(n5, n6, n4, n4);
        }
    }

    private void showTargetYuan(Graphics graphics) {
        if (this.target.x == -1) {
            return;
        }
        byte by = this.getVisualMode();
        int n = this.transferOriginX(this.target.x) + 1;
        int n2 = this.transferOriginY(this.target.y) + 1;
        int n3 = (int)(this.daoStep / 4.0);
        int n4 = n3 + n3;
        int n5 = (int)((double)this.daoBx + (double)(n - 1 + by) * this.daoStep - (double)n3);
        int n6 = (int)((double)this.daoBy + (double)(n2 - 1 + by) * this.daoStep - (double)n3);
        graphics.setColor(targetColor);
        graphics.drawRect(n5, n6, n4, n4);
        if (n <= by || n > 19 - by) {
            n5 = n <= by ? (int)((double)this.daoBx + (double)(n - 1 + by + 19) * this.daoStep - (double)n3) : (int)((double)this.daoBx + (double)(n - 1 + by - 19) * this.daoStep - (double)n3);
            n6 = (int)((double)this.daoBy + (double)(n2 - 1 + by) * this.daoStep - (double)n3);
            graphics.setColor(targetColor);
            graphics.drawRect(n5, n6, n4, n4);
        }
    }

    private void showTargetGoe(Graphics graphics) {
        if (this.target.x == -1) {
            return;
        }
        int n = this.step / 4;
        int n2 = n + n;
        int n3 = this.bx + this.target.x * this.step - n;
        int n4 = this.by + this.target.y * this.step - n;
        graphics.setColor(targetColor);
        graphics.drawRect(n3, n4, n2, n2);
    }

    private void showTarget(Graphics graphics) {
        if (this.getGType() == 2) {
            this.showTargetGoe(graphics);
        } else if (this.getGType() == 3) {
            this.showTargetDao(graphics);
        } else if (this.getGType() == 4) {
            this.showTargetYuan(graphics);
        } else if (this.getGType() == 5) {
            this.showTargetMobi(graphics);
        }
    }

    @Override
    public void setIdLastWithNumber(boolean bl) {
        this.idLastWithNumber = bl;
        this.repaint();
    }

    public boolean getIdLastWithNumber() {
        return this.idLastWithNumber;
    }

    public void stonePaint(int n, Component component) {
        int n2 = boardColor.getRGB();
        int n3 = n2 & 0xFF;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = (n2 & 0xFF0000) >> 16;
        boolean bl = true;
        int n6 = n;
        if (this.BlackStone == null || this.BlackStone.getWidth(component) != n6 + 2) {
            int n7 = n6 + 2;
            int[] nArray = new int[n7 * n7];
            int[] nArray2 = new int[n7 * n7];
            double d = (double)n7 / 2.0 - 0.5;
            double d2 = d - 0.2;
            double d3 = Math.sqrt(3.0);
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n7; ++j) {
                    double d4 = (double)i - d;
                    double d5 = (double)j - d;
                    double d6 = d2 - Math.sqrt(d4 * d4 + d5 * d5);
                    if (d6 >= 0.0) {
                        int n9;
                        double d7 = d2 * d2 - d4 * d4 - d5 * d5;
                        d7 = d7 > 0.0 ? Math.sqrt(d7) * d3 : 0.0;
                        double d8 = d4;
                        double d9 = d5;
                        double d10 = Math.sqrt(6.0 * (d8 * d8 + d9 * d9 + d7 * d7));
                        d10 = (2.0 * d7 - d8 + d9) / d10;
                        double d11 = d10 > 0.9 ? (d10 - 0.9) * 10.0 : 0.0;
                        if (d6 > 0.8 || !bl) {
                            n9 = (int)(10.0 + 10.0 * d10 + d11 * 140.0);
                            nArray[n8] = 0xFF000000 | n9 << 16 | n9 << 8 | n9;
                            n9 = (int)(200.0 + 10.0 * d10 + d11 * 45.0);
                            nArray2[n8] = 0xFF000000 | n9 << 16 | n9 << 8 | n9;
                        } else {
                            d6 = (0.8 - d6) / 0.8;
                            n9 = (int)(10.0 + 10.0 * d10 + d11 * 140.0);
                            double d12 = d4 - d5 < d2 / 3.0 ? 1.0 : 0.7;
                            nArray[n8] = 0xFF000000 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n5) << 16 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n4) << 8 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n3);
                            n9 = (int)(200.0 + 10.0 * d10 + d11 * 45.0);
                            nArray2[n8] = 0xFF000000 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n5) << 16 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n4) << 8 | (int)((1.0 - d6) * (double)n9 + d6 * d12 * (double)n3);
                        }
                    } else {
                        nArray2[n8] = 0;
                        nArray[n8] = 0;
                    }
                    ++n8;
                }
            }
            this.BlackStone = this.createImage(new MemoryImageSource(n7, n7, ColorModel.getRGBdefault(), nArray, 0, n7));
            this.WhiteStone = this.createImage(new MemoryImageSource(n7, n7, ColorModel.getRGBdefault(), nArray2, 0, n7));
        }
    }

    protected synchronized boolean trywood(Graphics graphics) {
        int n = this.boardEx - this.boardBx;
        if (EmptyPaint.haveImage(n) && EmptyPaint.isSameColor(bk_color)) {
            graphics.drawImage(EmptyPaint.StaticImage, this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy, this);
            return true;
        }
        graphics.drawImage(EmptyPaint.StaticImage, this.boardBx, this.boardBy, this.boardEx - this.boardBx, this.boardEy - this.boardBy, this);
        if (this.epThread != null && this.epThread.isAlive()) {
            this.epThread.stopit();
        }
        this.epThread = new EmptyPaint(this, n, n, bk_color);
        return false;
    }

    private void drawCoordinateDao(Graphics2D graphics2D) {
        int n;
        if (!this.showCoordinate) {
            return;
        }
        int[] nArray = new int[indexYr.length];
        char[] cArray = new char[indexXr.length];
        for (n = 0; n < cArray.length; ++n) {
            cArray[(n + this.originX) % cArray.length] = indexXr[n];
        }
        for (n = this.originY; n < nArray.length; ++n) {
            nArray[n - this.originY] = indexYr[n];
        }
        for (n = 0; n < this.originY; ++n) {
            nArray[nArray.length + n - this.originY] = indexYr[n];
        }
        n = (int)(this.daoStep / 2.0);
        double d = 0.0;
        graphics2D.setFont(new Font("TimesRoman", 1, n));
        for (int i = 0; i <= 18; ++i) {
            graphics2D.drawString("" + cArray[i], (float)(d + (double)this.daoBx - this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()), (float)((double)this.daoBoardEy + this.daoStep / 2.0));
            graphics2D.drawString("" + cArray[i], (float)(d + (double)this.daoBx - this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()), (float)((double)this.daoBoardBy - this.daoStep / 4.0));
            graphics2D.drawString("" + nArray[18 - i], (float)((double)this.daoBoardEx + this.daoStep / 4.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            if (nArray[18 - i] >= 10) {
                graphics2D.drawString("" + nArray[18 - i], (float)((double)this.daoBoardBy - this.daoStep / 4.0 * 3.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            } else {
                graphics2D.drawString("" + nArray[18 - i], (float)((double)this.daoBoardBy - this.daoStep / 2.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            }
            d += this.daoStep;
        }
    }

    private void drawCoordinateYuan(Graphics2D graphics2D) {
        int n;
        if (!this.showCoordinate) {
            return;
        }
        int n2 = (int)(this.daoStep / 2.0);
        double d = 0.0;
        graphics2D.setFont(new Font("TimesRoman", 1, n2));
        int[] nArray = new int[indexYr.length];
        char[] cArray = new char[indexXr.length];
        for (n = 0; n < cArray.length; ++n) {
            cArray[(n + this.originX) % cArray.length] = indexXr[n];
        }
        for (n = this.originY; n < nArray.length; ++n) {
            nArray[n - this.originY] = indexYr[n];
        }
        for (n = 0; n < this.originY; ++n) {
            nArray[nArray.length + n - this.originY] = indexYr[n];
        }
        for (n = 0; n <= 18; ++n) {
            graphics2D.drawString("" + cArray[n], (float)(d + (double)this.daoBx - this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()), (float)((double)this.daoBoardEy + this.daoStep / 2.0 - this.daoStep * (double)this.getVisualMode()));
            graphics2D.drawString("" + cArray[n], (float)(d + (double)this.daoBx - this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()), (float)((double)this.daoBoardBy - this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            graphics2D.drawString("" + nArray[18 - n], (float)((double)this.daoBoardEx + this.daoStep / 4.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            if (nArray[18 - n] >= 10) {
                graphics2D.drawString("" + nArray[18 - n], (float)((double)this.daoBoardBy - this.daoStep / 4.0 * 3.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            } else {
                graphics2D.drawString("" + nArray[18 - n], (float)((double)this.daoBoardBy - this.daoStep / 2.0), (float)((double)this.daoBy + d + this.daoStep / 4.0 + this.daoStep * (double)this.getVisualMode()));
            }
            d += this.daoStep;
        }
    }

    private void drawCoordinateGoe(Graphics2D graphics2D) {
        if (!this.showCoordinate) {
            return;
        }
        int n = this.step / 2;
        int n2 = 0;
        graphics2D.setFont(new Font("TimesRoman", 1, n));
        for (int i = 0; i <= 18; ++i) {
            graphics2D.drawString("" + indexXr[i], n2 + this.bx - this.step / 4, this.boardEy + this.step / 2);
            graphics2D.drawString("" + indexXr[i], n2 + this.bx - this.step / 4, this.boardBy - this.step / 4);
            graphics2D.drawString("" + indexYr[18 - i], this.boardEx + this.step / 4, this.by + n2 + this.step / 4);
            if (i >= 0 && i <= 9) {
                graphics2D.drawString("" + indexYr[18 - i], this.boardBy - this.step / 4 * 3, this.by + n2 + this.step / 4);
            } else {
                graphics2D.drawString("" + indexYr[18 - i], this.boardBy - this.step / 2, this.by + n2 + this.step / 4);
            }
            n2 += this.step;
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.dqp == null) {
            return null;
        }
        try {
            QiPanPosition qiPanPosition = this.getPosition(mouseEvent.getX(), mouseEvent.getY());
            int n = qiPanPosition.x;
            int n2 = qiPanPosition.y;
            if (DispQiPan.exist(n, n2) && (this.dqp.value[n][n2] == 1 || this.dqp.value[n][n2] == 2)) {
                return "" + this.dqp.number[n][n2];
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.updateAll(graphics2D);
        return 0;
    }

    static {
        bk_color = bk_color_saturated = new Color(200, 147, 79, 100);
        qizi_white = new Color(220, 220, 220);
        qizi_black = new Color(30, 30, 30);
        targetColor = Color.red;
        boardColor = bk_color;
        indexYr = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        indexXr = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S'};
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            CvsQiPan.this.reSetQiPan();
        }
    }

    private class MouseExitAndDrop
    extends BoardMouseAdapter {
        private int dropCenterX;
        private int dropCenterY;

        public MouseExitAndDrop(CvsQiPan cvsQiPan2) {
            super(cvsQiPan2);
            this.dropCenterX = 9;
            this.dropCenterY = 9;
        }

        public void turnCenter(QiPanPosition qiPanPosition) {
            if (CvsQiPan.this.getGType() == 3) {
                CvsQiPan.this.repaint();
            } else if (CvsQiPan.this.getGType() == 4) {
                CvsQiPan.this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            CvsQiPan.this.target.x = -1;
            CvsQiPan.this.target.y = -1;
            CvsQiPan.this.repaint();
        }

        @Override
        public void rightButtonClick(QiPanPosition qiPanPosition) {
            if (CvsQiPan.this.getGType() == 3) {
                int n = this.dropCenterX - qiPanPosition.x;
                int n2 = this.dropCenterY - qiPanPosition.y;
                CvsQiPan.this.originX = (CvsQiPan.this.originX + n) % 19;
                if (CvsQiPan.this.originX < 0) {
                    CvsQiPan.this.originX += 19;
                }
                CvsQiPan.this.originY = (CvsQiPan.this.originY + n2) % 19;
                if (CvsQiPan.this.originY < 0) {
                    CvsQiPan.this.originY += 19;
                }
                this.dropCenterX = qiPanPosition.x;
                this.dropCenterY = qiPanPosition.y;
                CvsQiPan.this.repaint();
            } else if (CvsQiPan.this.getGType() == 4) {
                int n = this.dropCenterX - qiPanPosition.x;
                CvsQiPan.this.originX = (CvsQiPan.this.originX + n) % 19;
                if (CvsQiPan.this.originX < 0) {
                    CvsQiPan.this.originX += 19;
                }
                this.dropCenterX = qiPanPosition.x;
                CvsQiPan.this.repaint();
            }
        }

        @Override
        public void handleDrop(QiPanPosition qiPanPosition, QiPanPosition qiPanPosition2) {
            if (qiPanPosition == null || qiPanPosition2 == null) {
                return;
            }
            if (CvsQiPan.this.getGType() == 3) {
                int n = qiPanPosition2.x - qiPanPosition.x;
                int n2 = qiPanPosition2.y - qiPanPosition.y;
                CvsQiPan.this.originX = (CvsQiPan.this.originX + n) % 19;
                if (CvsQiPan.this.originX < 0) {
                    CvsQiPan.this.originX += 19;
                }
                CvsQiPan.this.originY = (CvsQiPan.this.originY + n2) % 19;
                if (CvsQiPan.this.originY < 0) {
                    CvsQiPan.this.originY += 19;
                }
                this.dropCenterX = (this.dropCenterX - n) % 19;
                if (this.dropCenterX < 0) {
                    this.dropCenterX += 19;
                }
                this.dropCenterY = (this.dropCenterY - n2) % 19;
                if (this.dropCenterY < 0) {
                    this.dropCenterY += 19;
                }
                CvsQiPan.this.repaint();
                return;
            }
            if (CvsQiPan.this.getGType() == 4) {
                int n = qiPanPosition2.x - qiPanPosition.x;
                CvsQiPan.this.originX = (CvsQiPan.this.originX + n) % 19;
                if (CvsQiPan.this.originX < 0) {
                    CvsQiPan.this.originX += 19;
                }
                this.dropCenterX = (this.dropCenterX - n) % 19;
                if (this.dropCenterX < 0) {
                    this.dropCenterX += 19;
                }
                CvsQiPan.this.repaint();
                return;
            }
        }
    }

    private class MouseMotion
    extends MouseMotionAdapter {
        private long precMoveTime = 0L;

        private MouseMotion() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!CvsQiPan.this.showTarget) {
                return;
            }
            QiPanPosition qiPanPosition = CvsQiPan.this.getPosition(mouseEvent.getX(), mouseEvent.getY());
            if (qiPanPosition == null) {
                CvsQiPan.this.target.y = -1;
                CvsQiPan.this.target.x = -1;
                CvsQiPan.this.repaint();
                return;
            }
            if (CvsQiPan.this.target.x == qiPanPosition.x && CvsQiPan.this.target.y == qiPanPosition.y) {
                return;
            }
            CvsQiPan.this.target = qiPanPosition;
            CvsQiPan.this.repaint();
        }
    }
}

