/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.SpringLayout;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJToggleButton;
import tianyuan.games.gui.goe.goeroom.BoardView;
import tianyuan.games.gui.goe.goeroom.GoCommandPane;
import tianyuan.games.gui.goe.goeroom.GoeRoom;

class StudyGameCommandPane
extends GoCommandPane {
    protected GoeRoom guiRoom;
    AbstractButton[] button1 = new AbstractButton[4];
    AbstractButton[] button2 = new AbstractButton[5];
    protected SizeListener seeSize = new SizeListener();

    StudyGameCommandPane() {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
    }

    StudyGameCommandPane(GoeRoom goeRoom) {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
        this.setGoeRoom(goeRoom);
    }

    public void setGoeRoom(GoeRoom goeRoom) {
        this.guiRoom = goeRoom;
        this.boardView.setBoard(goeRoom.board);
    }

    private void createButton() {
        this.button1[0] = new MyJButton(Global.lang.getKey("303_create_ref"));
        this.button1[1] = new MyJButton(Global.lang.getKey("303_publish_ref"));
        this.button1[2] = new MyJButton(Global.lang.getKey("303_canel_ref"));
        this.button1[3] = new MyJButton(Global.lang.getKey("303_exit_study"));
        this.button2[0] = new MyJToggleButton(Global.lang.getKey("120_test"));
        this.button2[3] = new MyJToggleButton(Global.lang.getKey("120_analyze"));
        this.boardView = new BoardView(null);
        this.button2[1] = this.boardView;
        this.button2[2] = new MyJToggleButton(Global.lang.getKey("120_quiet"));
        this.button2[4] = new MyJButton(Global.lang.getKey("120_exit"));
        this.button1[0].addActionListener(new CreateReferenceListener());
        this.button1[1].addActionListener(new UpLoadReferenceListener());
        this.button1[2].addActionListener(new CanelReferenceListener());
        this.button1[3].addActionListener(new ExitStudyListener());
        this.button2[0].addItemListener(new TestListener());
        this.button2[2].addItemListener(new QuietListener());
        this.button2[3].addItemListener(new AnalyzeListener());
        this.button2[4].addActionListener(new QuitRoomListener());
    }

    @Override
    protected void resetLayout() {
        int n;
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n2 = (dimension.width - 6) / 4;
        int n3 = (dimension.width - 10) / 5;
        int n4 = (dimension.height - 24) / 2;
        for (n = 0; n < this.button1.length; ++n) {
            this.addComp(this.button1[n], dimension.width / 4 * n + 2, 0, n2, n4);
        }
        for (n = 0; n < this.button2.length; ++n) {
            this.addComp(this.button2[n], dimension.width / 5 * n + 2, n4 + 4, n3, n4);
        }
        this.revalidate();
    }

    class QuitRoomListener
    implements ActionListener {
        QuitRoomListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
            Global.netDaemon.quitRoom(StudyGameCommandPane.this.guiRoom.coreData.roomNumber);
            Global.goRootPane.removeGoeRoom(StudyGameCommandPane.this.guiRoom);
            StudyGameCommandPane.this.guiRoom.closeRoom();
            Global.goRoomPanel.removeGoeRoom(StudyGameCommandPane.this.guiRoom);
        }
    }

    class QuietListener
    implements ItemListener {
        QuietListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                StudyGameCommandPane.this.guiRoom.board.setSound(false);
                StudyGameCommandPane.this.guiRoom.clock.setSound(false);
            } else {
                StudyGameCommandPane.this.guiRoom.board.setSound(true);
                StudyGameCommandPane.this.guiRoom.clock.setSound(true);
            }
        }
    }

    class AnalyzeListener
    implements ItemListener {
        AnalyzeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
        }
    }

    class TestListener
    implements ItemListener {
        TestListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
        }
    }

    class ExitStudyListener
    implements ActionListener {
        ExitStudyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
            StudyGameCommandPane.this.guiRoom.endStudyGame();
        }
    }

    class CanelReferenceListener
    implements ActionListener {
        CanelReferenceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
        }
    }

    class UpLoadReferenceListener
    implements ActionListener {
        UpLoadReferenceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
        }
    }

    class CreateReferenceListener
    implements ActionListener {
        CreateReferenceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StudyGameCommandPane.this.guiRoom == null) {
                return;
            }
        }
    }

    protected class SizeListener
    extends ComponentAdapter {
        protected SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            StudyGameCommandPane.this.resetLayout();
        }
    }
}

