/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import tianyuan.games.base.GoGameResult;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.GoMAreYouSureDialog;
import tianyuan.games.gui.goe.dialog.GoMRequestDialog;
import tianyuan.games.gui.goe.goeroom.GoGameControl;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.clk.ClockSnap;
import tianyuan.games.gui.goe.goeroom.qp.BoardMouseAdapter;
import tianyuan.games.gui.goe.goeroom.qp.QiPanPosition;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

public class NetInGameControl
extends GoGameControl {
    InGameMouseAdapter mouse = new InGameMouseAdapter();
    private ComputeGameResultMouseAdapter computeMouse = new ComputeGameResultMouseAdapter();
    private static final Cursor handCursor = new Cursor(12);
    private static final Cursor waitCursor = new Cursor(0);
    private static final Cursor seeGameCursor = new Cursor(0);
    private static final Cursor computeGameCursor = new Cursor(0);
    private boolean listenMouseInput = true;

    @Override
    public void set(GoeRoom goeRoom) {
        this.guiRoom = goeRoom;
        this.guiRoom.inGameCommand.setGoeRoom(goeRoom);
        this.begingGameSetting();
        this.mouse.setBoard(this.guiRoom.board);
        this.computeMouse.setBoard(this.guiRoom.board);
    }

    private void begingGameSetting() {
        boolean bl = this.guiRoom.board.getSound();
        this.guiRoom.board.setSound(false);
        this.guiRoom.clock.setRule(this.guiRoom.coreData.record.rule);
        this.guiRoom.clock.setSound(true);
        this.guiRoom.setInGameCommandPane();
        this.setBegin(this.guiRoom.coreData.record.rule, this.guiRoom.board);
        this.setBeginListenMouseInput();
        this.setGoGameRecord();
        this.guiRoom.board.addMouseListener(this.mouse);
        this.setCurrentListenMouseInput();
        this.setCurrentClockTimeFlag();
        this.displayBeEatedCount();
        this.guiRoom.computeCommand.enabledValidateButton();
        this.guiRoom.board.setSound(bl);
    }

    private void endGameSetting(GoGameResult goGameResult) {
        this.guiRoom.board.removeMouseListener(this.mouse);
        this.guiRoom.board.removeMouseListener(this.computeMouse);
        this.guiRoom.board.quitComputeMode();
        this.guiRoom.board.setCursor(seeGameCursor);
        this.guiRoom.seeControl.setFormInGameControl(this.guiRoom);
        this.guiRoom.clock.clock.stop();
        this.guiRoom.gamblingPane.clear();
    }

    private void isNeedStudyDialog() {
        if (this.guiRoom == null) {
            return;
        }
        if (this.guiRoom.coreData.status.getValue() == 8) {
            return;
        }
        GoMAreYouSureDialog goMAreYouSureDialog = new GoMAreYouSureDialog(Global.root, Global.lang.getKey("302_study"), Global.lang.getKey("302_want_study"), 10);
        if (goMAreYouSureDialog.isAgreed) {
            if (Global.netDaemon != null) {
                Global.netDaemon.go.agreeStudy(this.guiRoom.getRoomNumber(), Global.myName());
            }
        } else if (Global.netDaemon != null) {
            Global.netDaemon.go.refuseStudy(this.guiRoom.getRoomNumber(), Global.myName());
        }
    }

    protected void inGameModeToComputeMode() {
        this.guiRoom.setComputeCommandPane();
        this.guiRoom.board.removeMouseListener(this.mouse);
        this.guiRoom.board.addMouseListener(this.computeMouse);
        this.guiRoom.board.setCursor(computeGameCursor);
    }

    protected void computeModeToInGameMode() {
        this.guiRoom.setInGameCommandPane();
        this.guiRoom.board.removeMouseListener(this.computeMouse);
        this.guiRoom.board.addMouseListener(this.mouse);
        this.setCurrentListenMouseInput();
    }

    public void setRecordQiZiFromLocal(GoRecordQiZi goRecordQiZi) {
        this.setRecordQiZi(goRecordQiZi, true, this.guiRoom.board, this.guiRoom.clock.clock, this.guiRoom.chat, this.guiRoom.coreData);
        this.displayBeEatedCount();
    }

    public void setRecordQiZiFromNet(GoRecordQiZi goRecordQiZi) {
        this.setRecordQiZi(goRecordQiZi, true, this.guiRoom.board, this.guiRoom.clock.clock, this.guiRoom.chat, this.guiRoom.coreData);
        this.displayBeEatedCount();
        switch (goRecordQiZi.type) {
            case 1: {
                this.setListenMouseInput(true);
                break;
            }
            case 41: {
                this.inGameModeToComputeMode();
                break;
            }
            case 40: {
                this.endGameSetting(goRecordQiZi.serverResult);
                break;
            }
            case 42: {
                this.computeModeToInGameMode();
                break;
            }
            case 43: {
                if (this.guiRoom.computeCommand == null) break;
                this.guiRoom.computeCommand.enabledValidateButton();
                break;
            }
            case 2: {
                GoMRequestDialog goMRequestDialog = new GoMRequestDialog(Global.root, Global.lang.getKey("123_regret") + ": " + Global.lang.getKey("123_room") + " [" + this.guiRoom.coreData.roomNumber + "] ", this.guiRoom.coreData.blackOrWhiteNameWithLevel(goRecordQiZi.regretUser, Global.lang) + " " + Global.lang.getKey("123_regret") + ".");
                GoRecordQiZi goRecordQiZi2 = new GoRecordQiZi();
                if (goMRequestDialog.isAgreed) {
                    goRecordQiZi2.type = 3;
                    goRecordQiZi2.agreeUser = Global.myName();
                } else {
                    goRecordQiZi2.type = 4;
                    goRecordQiZi2.refuseUser = Global.myName();
                }
                this.setRecordQiZiFromLocal(goRecordQiZi2);
                if (Global.netDaemon == null) break;
                Global.netDaemon.go.onlyUserNameCommand(goRecordQiZi2.type, Global.myName(), this.guiRoom.coreData.roomNumber);
                break;
            }
            case 8: {
                GoMRequestDialog goMRequestDialog = new GoMRequestDialog(Global.root, Global.lang.getKey("123_peace") + ": " + Global.lang.getKey("123_room") + " [" + this.guiRoom.coreData.roomNumber + "] ", this.guiRoom.coreData.blackOrWhiteNameWithLevel(goRecordQiZi.whoPeaceGame, Global.lang) + " " + Global.lang.getKey("123_peace") + ".");
                GoRecordQiZi goRecordQiZi3 = new GoRecordQiZi();
                if (goMRequestDialog.isAgreed) {
                    goRecordQiZi3.type = 9;
                    goRecordQiZi3.whoAgreePeaceGame = Global.myName();
                } else {
                    goRecordQiZi3.type = 10;
                    goRecordQiZi3.whoRefusePeaceGame = Global.myName();
                }
                this.setRecordQiZiFromLocal(goRecordQiZi3);
                if (Global.netDaemon == null) break;
                Global.netDaemon.go.onlyUserNameCommand(goRecordQiZi3.type, Global.myName(), this.guiRoom.coreData.roomNumber);
                break;
            }
            case 11: {
                GoMRequestDialog goMRequestDialog = new GoMRequestDialog(Global.root, Global.lang.getKey("123_compute") + ": " + Global.lang.getKey("123_room") + " [" + this.guiRoom.coreData.roomNumber + "] ", this.guiRoom.coreData.blackOrWhiteNameWithLevel(goRecordQiZi.who_want_compute, Global.lang) + " " + Global.lang.getKey("123_compute") + ".");
                GoRecordQiZi goRecordQiZi4 = new GoRecordQiZi();
                if (goMRequestDialog.isAgreed) {
                    goRecordQiZi4.type = 12;
                    goRecordQiZi4.who_agree_opponent_compute = Global.myName();
                } else {
                    goRecordQiZi4.type = 13;
                    goRecordQiZi4.who_refuse_opponent_compute = Global.myName();
                }
                this.setRecordQiZiFromLocal(goRecordQiZi4);
                if (Global.netDaemon == null) break;
                Global.netDaemon.go.onlyUserNameCommand(goRecordQiZi4.type, Global.myName(), this.guiRoom.coreData.roomNumber);
                break;
            }
            case 21: {
                GoMRequestDialog goMRequestDialog = new GoMRequestDialog(Global.root, Global.lang.getKey("124_start_in_game") + ": " + Global.lang.getKey("123_room") + " [" + this.guiRoom.coreData.roomNumber + "] ", this.guiRoom.coreData.blackOrWhiteNameWithLevel(goRecordQiZi.reEnterRequestUser, Global.lang) + " " + Global.lang.getKey("123_re_enter_game_mode_request") + ".");
                GoRecordQiZi goRecordQiZi5 = new GoRecordQiZi();
                if (goMRequestDialog.isAgreed) {
                    goRecordQiZi5.type = 22;
                    goRecordQiZi5.agreeReEnterRequestUser = Global.myName();
                } else {
                    goRecordQiZi5.type = 23;
                    goRecordQiZi5.refuseReEnterRequestUser = Global.myName();
                }
                this.setRecordQiZiFromLocal(goRecordQiZi5);
                if (Global.netDaemon == null) break;
                Global.netDaemon.go.sendGoRecordQiZi(goRecordQiZi5, this.guiRoom.coreData.roomNumber);
                break;
            }
        }
    }

    public boolean myColorIsBlack() {
        return this.guiRoom.coreData.record.rule.blackName.equals(Global.myUserInfo.userName);
    }

    private boolean getBeginListenMouseInput() {
        if (this.myColorIsBlack() && this.isBlackFirst()) {
            return true;
        }
        return !this.myColorIsBlack() && !this.isBlackFirst();
    }

    private void setBeginListenMouseInput() {
        this.setListenMouseInput(this.getBeginListenMouseInput());
    }

    private void setCurrentListenMouseInput() {
        int n = this.guiRoom.board.getCurrentNumber();
        if (n % 2 == 0) {
            this.setListenMouseInput(this.getBeginListenMouseInput());
        } else {
            this.setListenMouseInput(!this.getBeginListenMouseInput());
        }
    }

    public boolean getListenMouseInput() {
        return this.listenMouseInput;
    }

    protected void setListenMouseInput(boolean bl) {
        this.listenMouseInput = bl;
        if (bl) {
            this.guiRoom.board.setCursor(handCursor);
        } else {
            this.guiRoom.board.setCursor(waitCursor);
        }
    }

    private class ComputeGameResultMouseAdapter
    extends BoardMouseAdapter {
        private ComputeGameResultMouseAdapter() {
        }

        @Override
        public void handleClick(MouseEvent mouseEvent) {
            QiPanPosition qiPanPosition = NetInGameControl.this.guiRoom.board.getPosition(mouseEvent.getX(), mouseEvent.getY());
            if (qiPanPosition == null) {
                return;
            }
            if (NetInGameControl.this.guiRoom.board.isTestMode()) {
                return;
            }
            NetInGameControl.this.guiRoom.board.setComputeSelect(qiPanPosition);
            NetInGameControl.this.guiRoom.computeCommand.enabledValidateButton();
            if (Global.netDaemon != null) {
                GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
                goRecordQiZi.type = 43;
                goRecordQiZi.selectPosition = qiPanPosition;
                Global.netDaemon.go.sendGoRecordQiZi(goRecordQiZi, NetInGameControl.this.guiRoom.coreData.roomNumber);
            }
        }
    }

    private class InGameMouseAdapter
    extends BoardMouseAdapter {
        private InGameMouseAdapter() {
        }

        @Override
        public void handleClick(MouseEvent mouseEvent) {
            if (NetInGameControl.this.listenMouseInput) {
                QiPanPosition qiPanPosition = NetInGameControl.this.guiRoom.board.getPosition(mouseEvent.getX(), mouseEvent.getY());
                if (qiPanPosition == null) {
                    return;
                }
                if (NetInGameControl.this.guiRoom.board.isTestMode()) {
                    return;
                }
                int n = NetInGameControl.this.myColorIsBlack() ? 1 : 2;
                QiZi qiZi = new QiZi(n, qiPanPosition.x, qiPanPosition.y);
                if (!NetInGameControl.this.guiRoom.board.setQiZi(qiZi)) {
                    return;
                }
                NetInGameControl.this.setListenMouseInput(false);
                NetInGameControl.this.displayBeEatedCount();
                ClockSnap clockSnap = new ClockSnap();
                if (NetInGameControl.this.guiRoom.clock.clock != null) {
                    NetInGameControl.this.guiRoom.clock.clock.click();
                    clockSnap = NetInGameControl.this.guiRoom.clock.clock.getClockSnap();
                }
                if (Global.netDaemon == null || !Global.netDaemon.go.sendQiZi(qiZi, clockSnap, NetInGameControl.this.guiRoom.coreData.roomNumber)) {
                    // empty if block
                }
            }
        }
    }
}

