/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tianyuan.games.base.GoGameIndex;
import tianyuan.games.base.GoGameRecord;
import tianyuan.games.base.UserInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.goeroom.GoBoardPane;
import tianyuan.games.gui.goe.goeroom.SeeGameRecordClock;
import tianyuan.games.gui.goe.goeroom.SeeGameRecordCommandPane;
import tianyuan.games.gui.goe.goeroom.SeeGameRecordControl;
import tianyuan.games.gui.goe.goeroom.qp.AnalysisReportDisplay;
import tianyuan.games.gui.goe.goeroom.qp.Cvs2QiPan;
import tianyuan.games.gui.goe.hall.TabbedInfoPane;
import tianyuan.games.gui.goe.table.GoGameRecordIndexTable;
import tianyuan.games.gui.goe.table.GoUserInfoList;

public class GoeSeeGameRecordPane
extends JPanel {
    UserInfo info;
    Vector<GoGameIndex> index;
    GoGameRecord record;
    SeeGameRecordControl control = new SeeGameRecordControl(this);
    Cvs2QiPan board;
    SeeGameRecordClock clock;
    GoUserInfoList gradePane;
    GoGameRecordIndexTable recordList;
    SeeGameRecordCommandPane commandPane;
    TabbedInfoPane tabbedInfoPane = new TabbedInfoPane();
    JPanel commandContainer = new JPanel();
    private JSplitPane right;
    protected JPanel rightPane = new JPanel();
    private SizeListener seeSize = new SizeListener();
    AnalysisReportDisplay analysisReportDisplay;

    public String getMyName() {
        return this.info.userName;
    }

    public String getMyTitle() {
        return this.info.nameWithGoLevel(Global.lang);
    }

    public void myClose() {
        Global.goRootPane.removeGoeSeeGameRecordPane(this);
    }

    public GoeSeeGameRecordPane(UserInfo userInfo) {
        this.info = userInfo;
        this.addComponentListener(new SizeListener());
        this.board = new GoBoardPane();
        this.clock = new SeeGameRecordClock();
        this.gradePane = new GoUserInfoList();
        this.gradePane.set(userInfo);
        this.recordList = new GoGameRecordIndexTable(this);
        this.tabbedInfoPane.add(Global.lang.getKey("129_game_record"), this.recordList);
        this.right = new JSplitPane(0, this.gradePane, this.tabbedInfoPane);
        this.right.setOneTouchExpandable(false);
        this.right.addComponentListener(new RightSizeListener());
        this.commandPane = new SeeGameRecordCommandPane(this);
        this.rightPane.add(this.clock);
        this.rightPane.add(this.right);
        this.commandContainer.add(this.commandPane);
        this.rightPane.add(this.commandContainer);
        this.tabbedInfoPane.addComponentListener(new TabbedInfoPaneSizeListener());
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
    }

    public void addIndex(Vector<GoGameIndex> vector, int n) {
        this.index = vector;
        this.recordList.add(vector, n);
    }

    public void setGoGameRecord(GoGameRecord goGameRecord) {
        this.record = goGameRecord;
        this.control.setRecord(goGameRecord);
    }

    private void setRightSize() {
        this.right.setDividerLocation(0.35);
        this.gradePane.revalidate();
        this.tabbedInfoPane.revalidate();
        this.right.revalidate();
    }

    protected void setAllSize() {
        Dimension dimension = this.getSize();
        GoeSeeGameRecordPane.limitSize(this.board, new Dimension(dimension.height - 1, dimension.height - 1));
        GoeSeeGameRecordPane.limitSize(this.rightPane, new Dimension(dimension.width - dimension.height + 1, dimension.height));
        GoeSeeGameRecordPane.limitSize(this.clock, new Dimension(dimension.width - dimension.height + 1, dimension.height / 6));
        GoeSeeGameRecordPane.limitSize(this.right, new Dimension(dimension.width - dimension.height + 1, dimension.height * 17 / 24));
        GoeSeeGameRecordPane.limitSize(this.commandPane, new Dimension(dimension.width - dimension.height - 1, dimension.height / 8 - 6));
        GoeSeeGameRecordPane.limitSize(this.commandContainer, new Dimension(dimension.width - dimension.height + 1, dimension.height / 8));
        this.setRightSize();
        this.validate();
        this.revalidate();
    }

    private static void limitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    public void enterAnalysisMode() {
        this.analysisReportDisplay = new AnalysisReportDisplay();
        this.board.enterAnalysisMode(this.analysisReportDisplay);
        this.analysisReportDisplay.setReport(this.board.getAnalysisQiPan().getAnalysisReport());
        this.tabbedInfoPane.add(Global.lang.getKey("120_analyze"), this.analysisReportDisplay);
        this.tabbedInfoPane.setSelectedComponent(this.analysisReportDisplay);
    }

    public void quitAnalysisMode() {
        this.board.quitAnalysisMode();
        this.tabbedInfoPane.removeAnalysisReportDisplay(this.analysisReportDisplay);
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeSeeGameRecordPane.this.setAllSize();
        }
    }

    private class TabbedInfoPaneSizeListener
    extends ComponentAdapter {
        private TabbedInfoPaneSizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeSeeGameRecordPane.this.gradePane.revalidate();
            GoeSeeGameRecordPane.this.tabbedInfoPane.revalidate();
            GoeSeeGameRecordPane.this.right.revalidate();
        }
    }

    private class RightSizeListener
    extends ComponentAdapter {
        private RightSizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoeSeeGameRecordPane.this.setRightSize();
        }
    }
}

