/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import tianyuan.games.base.GoGameRule;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.clk.MyNewClock;
import tianyuan.games.gui.goe.goeroom.clk.NewJPanelClock;

class GoClockPane
extends NewJPanelClock {
    private GoeRoom guiRoom;
    MyNewClock clock;

    public GoClockPane(GoeRoom goeRoom) {
        this.guiRoom = goeRoom;
    }

    @Override
    public void reportBlackTimeOut() {
        if (!this.isCanReport()) {
            return;
        }
        Global.netDaemon.go.onlyUserNameCommand(7, this.guiRoom.coreData.black, this.guiRoom.coreData.roomNumber);
        GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
        goRecordQiZi.type = 7;
        goRecordQiZi.whoTimeOut = this.guiRoom.coreData.black;
        this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
    }

    private boolean isCanReport() {
        if (this.guiRoom == null) {
            return false;
        }
        if (this.guiRoom.coreData == null) {
            return false;
        }
        if (!this.guiRoom.coreData.isRunner(Global.myName())) {
            return false;
        }
        return Global.netDaemon != null;
    }

    @Override
    public void reportWhiteTimeOut() {
        if (!this.isCanReport()) {
            return;
        }
        Global.netDaemon.go.onlyUserNameCommand(7, this.guiRoom.coreData.white, this.guiRoom.coreData.roomNumber);
        GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
        goRecordQiZi.type = 7;
        goRecordQiZi.whoTimeOut = this.guiRoom.coreData.white;
        this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
    }

    public void setRule(GoGameRule goGameRule) {
        this.setId(this.guiRoom.coreData.blackNameWithLevel2(Global.lang), this.guiRoom.coreData.whiteNameWithLevel2(Global.lang));
        if (this.clock != null) {
            this.clock.setStop();
        }
        this.clock = new MyNewClock(goGameRule.timeLimit_min / 60, goGameRule.timeLimit_min % 60, 0, goGameRule.timeLimit_readTime, goGameRule.timeLimit_readSec, this);
        if (goGameRule.isBlackFirst()) {
            this.clock.setTimeFlag(1);
        } else {
            this.clock.setTimeFlag(2);
        }
        this.clock.start();
    }

    public void setSound(boolean bl) {
        if (this.clock == null) {
            return;
        }
        this.clock.quiet = !bl;
    }
}

