/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor.maptree;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

public class MapTreeNode
extends DefaultMutableTreeNode {
    private static ImageIcon blackIcon;
    private static ImageIcon rootIcon;
    private static ImageIcon whiteIcon;
    private static ImageIcon stopOnceIcon;
    private boolean isRootFlag = false;
    private String title = "";
    private String explain = "";
    private List<QiZi> subKey = new Vector<QiZi>();
    private List<QiZi> marks = new Vector<QiZi>();
    private QiZi key = new QiZi(0, 0, 0);
    private int nodeNumber;

    MapTreeNode() {
    }

    MapTreeNode(Object object) {
        super(object);
        if (object instanceof QiZi) {
            this.setKey((QiZi)object);
        }
    }

    @Override
    public String toString() {
        return this.title;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() <= 0;
    }

    public void read(TyBaseInput tyBaseInput) throws IOException {
        this.title = tyBaseInput.readUTF();
        this.explain = tyBaseInput.readUTF();
        this.nodeNumber = tyBaseInput.readInt();
        this.key = QiZi.read(tyBaseInput);
        int n = tyBaseInput.readShort();
        for (int i = 0; i < n; ++i) {
            QiZi qiZi = QiZi.read(tyBaseInput);
            this.subKey.add(qiZi);
        }
        n = tyBaseInput.readShort();
        for (int i = 0; i < n; ++i) {
            QiZi qiZi = QiZi.read(tyBaseInput);
            this.marks.add(qiZi);
        }
    }

    public void write(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeUTF(this.title);
        tyBaseOutput.writeUTF(this.explain);
        tyBaseOutput.writeInt(this.nodeNumber);
        QiZi.write(tyBaseOutput, this.key);
        tyBaseOutput.writeShort(this.subKey.size());
        for (QiZi qiZi : this.subKey) {
            QiZi.write(tyBaseOutput, qiZi);
        }
        tyBaseOutput.writeShort(this.marks.size());
        for (QiZi qiZi : this.marks) {
            QiZi.write(tyBaseOutput, qiZi);
        }
    }

    public Icon getIcon(int n) {
        if (n <= 0) {
            return rootIcon;
        }
        if (this.key.getColor() == 1) {
            return blackIcon;
        }
        if (this.key.getColor() == 2) {
            return whiteIcon;
        }
        if (this.key.flag == 8) {
            return stopOnceIcon;
        }
        return rootIcon;
    }

    @Override
    public boolean isRoot() {
        return this.isRootFlag;
    }

    public void setRootFlag(boolean bl) {
        this.isRootFlag = bl;
    }

    public void setTitle(String string) {
        this.title = string == null ? "" : string;
    }

    public void appendTitle(String string) {
        if (string == null) {
            return;
        }
        this.title = this.title + string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setExplain(String string) {
        this.explain = string == null ? "" : string;
    }

    public void appendExplain(String string) {
        if (string == null) {
            return;
        }
        this.explain = this.explain + string;
    }

    public String getExplain() {
        return this.explain;
    }

    public void addMark(QiZi qiZi) {
        for (QiZi qiZi2 : this.marks) {
            if (!qiZi.isSameCoordinate(qiZi2)) continue;
            this.marks.remove(qiZi2);
            break;
        }
        this.marks.add(qiZi);
    }

    public List<QiZi> getMarks() {
        return this.marks;
    }

    public List<QiZi> getSubKey() {
        return this.subKey;
    }

    public int subKeyCount() {
        return this.subKey.size();
    }

    public void setSubKey(List<QiZi> list) {
        this.subKey = list;
    }

    public void addSubKey(QiZi qiZi) {
        this.subKey.add(qiZi);
    }

    public boolean removeSubKey(QiZi qiZi) {
        for (QiZi qiZi2 : this.subKey) {
            if (!qiZi2.equals(qiZi)) continue;
            this.subKey.remove(qiZi2);
            return true;
        }
        return false;
    }

    public boolean removeMark(int n, int n2) {
        for (QiZi qiZi : this.marks) {
            if (qiZi.getX() != n || qiZi.getY() != n2) continue;
            this.marks.remove(qiZi);
            return true;
        }
        return false;
    }

    public boolean removeMark(QiZi qiZi) {
        for (QiZi qiZi2 : this.marks) {
            if (!qiZi2.equals(qiZi)) continue;
            this.marks.remove(qiZi2);
            return true;
        }
        return false;
    }

    public void setKey(QiZi qiZi) {
        this.key = qiZi;
    }

    public void setKeyNumber(int n) {
        if (this.key != null) {
            this.key.setNumber(n);
            for (QiZi qiZi : this.subKey) {
                qiZi.setNumber(-n);
            }
        }
    }

    public int getKeyNumber() {
        if (this.getParent() == null) {
            return 0;
        }
        if (this.key == null || this.key.getColor() == 0) {
            MapTreeNode mapTreeNode = (MapTreeNode)this.getParent();
            return mapTreeNode.getKeyNumber();
        }
        return this.key.getNumber();
    }

    public QiZi getKey() {
        return this.key;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(int n) {
        this.nodeNumber = n;
    }

    static {
        try {
            blackIcon = new ImageIcon("./resource/ico/2_black.png");
            whiteIcon = new ImageIcon("./resource/ico/3_white.png");
            rootIcon = new ImageIcon("./resource/ico/5_info.png");
            stopOnceIcon = new ImageIcon("./resource/ico/4_stop_once.png");
        }
        catch (Exception exception) {
            System.out.println("Couldn't load images: " + exception);
        }
    }
}

