/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor.maptree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.phoenix.util.MyProperties;
import org.phoenix.util.RwProperties;
import tianyuan.games.gui.goe.editor.maptree.MapTreeNode;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

public class MapTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected static Font defaultFont;
    protected static final Color SelectedBackgroundColor;
    protected boolean selected;
    private static MyProperties lang;
    private static RwProperties paramter;

    public void setLangAndParamter(MyProperties myProperties, RwProperties rwProperties) {
        lang = myProperties;
        paramter = rwProperties;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        MapTreeNode mapTreeNode = (MapTreeNode)object;
        QiZi qiZi = mapTreeNode.getKey();
        String string = qiZi.getNumber() + "";
        String string2 = "(" + qiZi.getXChar() + "," + qiZi.getYIndex() + ")";
        String string3 = mapTreeNode.getExplain();
        this.setAllIcon(mapTreeNode.getIcon(n));
        String string4 = "";
        if (string3 != null && string3.length() > 0) {
            string4 = string4 + "*";
        }
        if (n <= 0) {
            string4 = lang.getKey("213_title") + string4 + " " + mapTreeNode.getTitle();
        } else if (n <= 0 || qiZi.flag == 8) {
            string4 = string4 + " " + mapTreeNode.getTitle();
        }
        if (qiZi.getColor() == 1 || qiZi.getColor() == 2) {
            string4 = string + string2 + string4 + " " + mapTreeNode.getTitle();
        } else if (qiZi.getColor() == 0) {
            string4 = " " + mapTreeNode.getTitle();
        }
        StringBuilder stringBuilder = new StringBuilder(string4);
        for (int i = 0; i < 150 - string4.length(); ++i) {
            stringBuilder.append(" ");
        }
        this.setText(stringBuilder.toString());
        if (bl) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(Color.black);
        }
        this.selected = bl;
        return this;
    }

    private void setAllIcon(Icon icon) {
        this.setIcon(icon);
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
    }

    @Override
    public void paint(Graphics graphics) {
        Icon icon = this.getIcon();
        Color color = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        graphics.setColor(color);
        if (icon != null && this.getText() != null) {
            int n = icon.getIconWidth() + this.getIconTextGap();
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
        } else {
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    static {
        SelectedBackgroundColor = Color.blue;
    }
}

