/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.dialog;

import java.util.Vector;
import org.phoenix.util.RwProperties;

public class AddressStorage {
    private RwProperties paramterAddr;
    private Vector<TimeAndAddr> mem = new Vector();

    public AddressStorage(String string) {
        this.paramterAddr = new RwProperties(string);
        this.paramterAddr.readIn();
        this.load();
    }

    public Vector<String> getAddrs() {
        Vector<String> vector = new Vector<String>();
        for (TimeAndAddr timeAndAddr : this.mem) {
            vector.add(timeAndAddr.addr);
        }
        return vector;
    }

    public void appendAddr(String string) {
        TimeAndAddr timeAndAddr = new TimeAndAddr();
        timeAndAddr.addr = string;
        timeAndAddr.time = System.currentTimeMillis();
        this.addToMem(timeAndAddr);
        this.saveMem();
    }

    private void load() {
        try {
            int n = this.paramterAddr.getInt("addr_count");
            for (int i = 0; i < n; ++i) {
                TimeAndAddr timeAndAddr = new TimeAndAddr();
                timeAndAddr.time = this.paramterAddr.getLong("addr_" + (i + 1) + "_time");
                timeAndAddr.addr = this.paramterAddr.getString("addr_" + (i + 1));
                this.addToMem(timeAndAddr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveMem() {
        int n = 0;
        for (TimeAndAddr timeAndAddr : this.mem) {
            this.paramterAddr.setKey("addr_" + (n + 1), timeAndAddr.addr);
            this.paramterAddr.setLong("addr_" + (n + 1) + "_time", timeAndAddr.time);
            ++n;
        }
        this.paramterAddr.setInt("addr_count", n);
        this.paramterAddr.writeOut();
    }

    private void addToMem(TimeAndAddr timeAndAddr) {
        for (TimeAndAddr object : this.mem) {
            if (!object.addr.equals(timeAndAddr.addr)) continue;
            object.time = timeAndAddr.time;
            return;
        }
        int n = 0;
        for (TimeAndAddr timeAndAddr2 : this.mem) {
            if (timeAndAddr2.time < timeAndAddr.time) {
                this.mem.add(n, timeAndAddr);
                return;
            }
            ++n;
        }
        this.mem.add(timeAndAddr);
    }

    class TimeAndAddr {
        long time;
        String addr;

        TimeAndAddr() {
        }
    }
}

