/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJTabbedPane;
import tianyuan.games.gui.goe.hall.CollegueBbs;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.net.ServerMessage;
import tianyuan.games.net.client.VoIpAdapter;
import tianyuan.games.sound.AudioFormatSelect;

public class CollogueJFrame
extends JFrame {
    Vector<CollegueBbs> allBbsItem = new Vector();
    CollogueJTabbedPane tabbedPane = new CollogueJTabbedPane();

    public CollogueJFrame() {
        this.setTitle(Global.lang.getKey("102_whisper"));
        this.add(this.tabbedPane);
        this.setLocationAndSize();
    }

    public void myReset() {
        this.tabbedPane.removeAll();
        this.allBbsItem.clear();
    }

    public CollegueBbs openUser(UserInfo userInfo) {
        for (CollegueBbs collegueBbs : this.allBbsItem) {
            if (!collegueBbs.getMyName().equals(userInfo.userName)) continue;
            this.tabbedPane.setSelectedComponent(collegueBbs);
            return collegueBbs;
        }
        CollegueBbs collegueBbs = new CollegueBbs(userInfo);
        this.allBbsItem.add(collegueBbs);
        this.tabbedPane.add(collegueBbs.getMyTitle(), collegueBbs);
        this.tabbedPane.setSelectedComponent(collegueBbs);
        return collegueBbs;
    }

    public void displayMessage(String string, String string2) {
        CollegueBbs collegueBbs = this.search(string2);
        if (collegueBbs != null) {
            this.tabbedPane.setSelectedComponent(collegueBbs);
        } else {
            UserAllInfo userAllInfo = Global.goRoomPanel.search(string2);
            if (userAllInfo == null) {
                return;
            }
            collegueBbs = this.openUser(userAllInfo.info);
        }
        this.setVisible(true);
        if (!string.equals("#?}{+-%$@")) {
            collegueBbs.displayMessage(null, string);
        }
    }

    public void displayMessage(ServerMessage serverMessage) {
        CollegueBbs collegueBbs = this.search(serverMessage.sender);
        if (collegueBbs != null) {
            this.tabbedPane.setSelectedComponent(collegueBbs);
        } else {
            UserAllInfo userAllInfo = Global.goRoomPanel.search(serverMessage.sender);
            if (userAllInfo == null) {
                return;
            }
            collegueBbs = this.openUser(userAllInfo.info);
        }
        this.setVisible(true);
        if (!serverMessage.body.equals("#?}{+-%$@")) {
            collegueBbs.displayMessage(serverMessage);
        }
    }

    private CollegueBbs search(String string) {
        for (CollegueBbs collegueBbs : this.allBbsItem) {
            if (!collegueBbs.getMyName().equals(string)) continue;
            return collegueBbs;
        }
        return null;
    }

    private void setLocationAndSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(System.getProperty("user.dir") + System.getProperty("file.separator") + "resource/image/multigo_hand1.png");
        if (image != null) {
            this.setIconImage(image);
        }
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = dimension.width / 3;
        int n4 = dimension.height / 3;
        this.setLocation(n3, n4);
        int n5 = dimension.width / 3;
        int n6 = dimension.height / 3;
        this.setSize(n5, n6);
    }

    public void setMenu() {
        JMenuBar jMenuBar = this.createMenuBar();
        this.setJMenuBar(jMenuBar);
    }

    JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Global.lang.getKey("201_voip_menu"), true);
        VoiceConnectAction voiceConnectAction = new VoiceConnectAction();
        jMenu.add(voiceConnectAction);
        VoiceDisConnectAction voiceDisConnectAction = new VoiceDisConnectAction();
        jMenu.add(voiceDisConnectAction);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public boolean addVoIpAdapter(VoIpAdapter voIpAdapter, String string) {
        for (CollegueBbs collegueBbs : this.allBbsItem) {
            if (!collegueBbs.getMyName().equals(string)) continue;
            collegueBbs.audioChannel = voIpAdapter;
            voIpAdapter.setGui(collegueBbs);
            return true;
        }
        return false;
    }

    class CollogueJTabbedPane
    extends MyJTabbedPane {
        private final JPopupMenu popup = new JPopupMenu();
        private CloseAction closeAction = new CloseAction();

        CollogueJTabbedPane() {
            this.popup.add(this.closeAction);
            this.addMouseListener(new PopupAdapter(this.popup, this));
        }

        class PopupAdapter
        extends PopupMenuMouseAdapter {
            public PopupAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
                super(jPopupMenu, jComponent);
            }

            @Override
            public void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    if (CollogueJFrame.this.allBbsItem.size() <= 1) {
                        CollogueJTabbedPane.this.closeAction.setEnabled(false);
                    } else {
                        CollogueJTabbedPane.this.closeAction.setEnabled(true);
                    }
                    this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        class CloseAction
        extends AbstractAction {
            CloseAction() {
                super(Global.lang.getKey("7_menu_user_quit"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CollegueBbs collegueBbs = (CollegueBbs)CollogueJTabbedPane.this.getSelectedComponent();
                if (collegueBbs == null) {
                    return;
                }
                for (CollegueBbs collegueBbs2 : CollogueJFrame.this.allBbsItem) {
                    if (!collegueBbs2.getMyName().equals(collegueBbs.getMyName())) continue;
                    CollogueJFrame.this.allBbsItem.remove(collegueBbs2);
                    break;
                }
                CollogueJTabbedPane.this.remove(collegueBbs);
            }
        }
    }

    class VoiceDisConnectAction
    extends AbstractAction {
        VoiceDisConnectAction() {
            super(Global.lang.getKey("201_close_voip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CollegueBbs collegueBbs = (CollegueBbs)CollogueJFrame.this.tabbedPane.getSelectedComponent();
            collegueBbs.displayMessage(null, " " + Global.lang.getKey("201_close_voip_message_src"));
            collegueBbs.audioChannel.close();
        }
    }

    class VoiceConnectAction
    extends AbstractAction {
        VoiceConnectAction() {
            super(Global.lang.getKey("201_request_voip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CollegueBbs collegueBbs = (CollegueBbs)CollogueJFrame.this.tabbedPane.getSelectedComponent();
            collegueBbs.displayMessage(null, " " + Global.lang.getKey("201_request_voip_message_src"));
            Global.netDaemon.audioTalkRts(collegueBbs.getMyName(), AudioFormatSelect.getAllFormat());
        }
    }
}

