/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import java.util.Vector;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.AdminField;
import tianyuan.games.base.GoField;
import tianyuan.games.base.Root;
import tianyuan.games.base.TpMoney;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class UserInfo
extends Root {
    public AdminField adminField = new AdminField();
    public TpMoney money = new TpMoney();
    public String userName;
    public String nickName;
    public String userPasswd;
    public int userNumber = -1;
    protected Vector<String> friends = new Vector();
    protected Vector<String> dislikes = new Vector();
    public GoField go = new GoField();

    public UserInfo() {
    }

    public String debugInfo() {
        return this.friends.size() + "  " + this.dislikes.size();
    }

    public void modifyInfo(UserInfo userInfo) {
        this.userPasswd = userInfo.userPasswd;
        this.go.modifyInfo(userInfo.go);
    }

    public String nameWithGoLevel() {
        return this.userName + "[" + this.go.currentLevel.toString() + "]";
    }

    public String nameWithGoLevel(MyProperties myProperties) {
        return this.userName + "[" + this.go.currentLevel.toString(myProperties) + "]";
    }

    public UserInfo(String string, String string2, String string3) {
        this.userName = string;
        this.userPasswd = string2;
        this.nickName = string3;
    }

    public void readForUserTable(TyBaseInput tyBaseInput) throws IOException {
        this.readMeat(tyBaseInput);
    }

    public void writeForUserTable(TyBaseOutput tyBaseOutput) throws IOException {
        this.writeMeat(tyBaseOutput);
    }

    public void readHead(TyBaseInput tyBaseInput) throws IOException {
        this.userNumber = tyBaseInput.readInt();
        this.userName = tyBaseInput.readUTF();
        this.userPasswd = tyBaseInput.readUTF();
        this.nickName = tyBaseInput.readUTF();
        this.go.readHead(tyBaseInput);
        this.money.read(tyBaseInput);
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        String string;
        int n;
        this.adminField.read(tyBaseInput);
        this.userNumber = tyBaseInput.readInt();
        this.userName = tyBaseInput.readUTF();
        this.userPasswd = tyBaseInput.readUTF();
        this.nickName = tyBaseInput.readUTF();
        this.go.read(tyBaseInput);
        int n2 = tyBaseInput.readShort();
        for (n = 0; n < n2; ++n) {
            string = tyBaseInput.readUTF();
            this.friends.add(string);
        }
        n2 = tyBaseInput.readShort();
        for (n = 0; n < n2; ++n) {
            string = tyBaseInput.readUTF();
            this.dislikes.add(string);
        }
        this.money.read(tyBaseInput);
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        this.adminField.write(tyBaseOutput);
        tyBaseOutput.writeInt(this.userNumber);
        tyBaseOutput.writeUTF(this.userName);
        tyBaseOutput.writeUTF(this.userPasswd);
        tyBaseOutput.writeUTF(this.nickName);
        this.go.write(tyBaseOutput);
        tyBaseOutput.writeShort(this.friends.size());
        for (String string : this.friends) {
            tyBaseOutput.writeUTF(string);
        }
        tyBaseOutput.writeShort(this.dislikes.size());
        for (String string : this.dislikes) {
            tyBaseOutput.writeUTF(string);
        }
        this.money.write(tyBaseOutput);
    }

    public void readRelationShip(TyBaseInput tyBaseInput) throws IOException {
        String string;
        int n;
        int n2 = tyBaseInput.readShort();
        for (n = 0; n < n2; ++n) {
            string = tyBaseInput.readUTF();
            this.friends.add(string);
        }
        n2 = tyBaseInput.readShort();
        for (n = 0; n < n2; ++n) {
            string = tyBaseInput.readUTF();
            this.dislikes.add(string);
        }
    }

    public void writeRelationShip(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeShort(this.friends.size());
        for (String string : this.friends) {
            tyBaseOutput.writeUTF(string);
        }
        tyBaseOutput.writeShort(this.dislikes.size());
        for (String string : this.dislikes) {
            tyBaseOutput.writeUTF(string);
        }
    }

    public void writeHead(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeInt(this.userNumber);
        tyBaseOutput.writeUTF(this.userName);
        tyBaseOutput.writeUTF(this.userPasswd);
        tyBaseOutput.writeUTF(this.nickName);
        this.go.writeHead(tyBaseOutput);
        this.money.write(tyBaseOutput);
    }

    public String relationShipToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("friends:");
        for (String string : this.friends) {
            stringBuffer.append(string);
        }
        stringBuffer.append("    dislikes:");
        for (String string : this.dislikes) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean isFriend(String string) {
        for (String string2 : this.friends) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isFriend(UserInfo userInfo) {
        return this.isFriend(userInfo.userName);
    }

    public boolean isDislike(String string) {
        for (String string2 : this.dislikes) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isDislike(UserInfo userInfo) {
        return this.isDislike(userInfo.userName);
    }

    public int friendTotal() {
        return this.friends.size();
    }

    public void addFriend(String string) {
        this.friends.add(string);
    }

    public void delFriend(String string) {
        this.friends.remove(string);
    }

    public int dislikeTotal() {
        return this.dislikes.size();
    }

    public void addDislike(String string) {
        this.dislikes.add(string);
    }

    public void delDislike(String string) {
        this.dislikes.remove(string);
    }
}

