/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.GoGameResult;
import tianyuan.games.base.Level;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class GoGameIndex
extends Root {
    public int number = 0;
    public short recordLength = 0;
    public String blackName;
    public String whiteName;
    public Level blackLevel;
    public Level whiteLevel;
    public long beginTime;
    public long endTime;
    public GoGameResult result;
    public String title = "";
    public static final int INDEX_MAX_LENGTH = 100;

    public String blackNameWithLevel(MyProperties myProperties) {
        return this.blackName + "[" + this.blackLevel.toString(myProperties) + "]";
    }

    public String whiteNameWithLevel(MyProperties myProperties) {
        return this.whiteName + "[" + this.whiteLevel.toString(myProperties) + "]";
    }

    public String getUseTime(MyProperties myProperties) {
        long l = Math.abs((this.endTime - this.beginTime) / 1000L);
        long l2 = l / 3600L;
        long l3 = (l - l2 * 3600L) / 60L;
        long l4 = l - l2 * 3600L - l3 * 60L;
        if (l3 == 0L && l2 == 0L) {
            return l4 + myProperties.getKey("129_second");
        }
        if (l2 == 0L) {
            return l3 + myProperties.getKey("129_minute") + l4 + myProperties.getKey("129_second");
        }
        return l2 + myProperties.getKey("129_hour") + l3 + myProperties.getKey("129_minute") + l4 + myProperties.getKey("129_second");
    }

    public String getBeginTime() {
        return this.toDateStr(this.beginTime);
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeInt(this.number);
        tyBaseOutput.writeShort(this.recordLength);
        tyBaseOutput.writeUTF(this.blackName);
        tyBaseOutput.writeUTF(this.whiteName);
        tyBaseOutput.writeLong(this.beginTime);
        tyBaseOutput.writeLong(this.endTime);
        this.blackLevel.write(tyBaseOutput);
        this.whiteLevel.write(tyBaseOutput);
        this.result.write(tyBaseOutput);
        tyBaseOutput.writeUTF(this.title);
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.number = tyBaseInput.readInt();
        this.recordLength = tyBaseInput.readShort();
        this.blackName = tyBaseInput.readUTF();
        this.whiteName = tyBaseInput.readUTF();
        this.beginTime = tyBaseInput.readLong();
        this.endTime = tyBaseInput.readLong();
        this.blackLevel = new Level();
        this.blackLevel.read(tyBaseInput);
        this.whiteLevel = new Level();
        this.whiteLevel.read(tyBaseInput);
        this.result = new GoGameResult();
        this.result.read(tyBaseInput);
        this.title = tyBaseInput.readUTF();
    }

    public static byte[] toArray(GoGameIndex goGameIndex) {
        byte[] byArray = new byte[100];
        return byArray;
    }

    public static GoGameIndex toObject(byte[] byArray) {
        GoGameIndex goGameIndex = new GoGameIndex();
        return goGameIndex;
    }
}

