/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.GoRoomInfo;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.EnterRoomPasswd;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.TableSorter;

public class GoUserRoomList2
extends JPanel {
    protected String[] columnNames = new String[]{Global.lang.getKey("103_passwd"), Global.lang.getKey("103_number"), Global.lang.getKey("103_status"), Global.lang.getKey("127_counter"), Global.lang.getKey("103_info"), Global.lang.getKey("103_title")};
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected JPopupMenu popup = new JPopupMenu();
    GoRoomInfos roomInfos = null;
    protected EnterRoomAction enterRoomAction = new EnterRoomAction();
    private SizeListener seeSize = new SizeListener();

    public String getTitle() {
        return Global.lang.getKey("127_title");
    }

    public GoUserRoomList2() {
        this.mtm = new MyTableModel();
        TableSorter tableSorter = new TableSorter(this.mtm);
        this.table = new JTable(tableSorter);
        this.table.setSelectionMode(0);
        tableSorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
        this.sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.popup.add(this.enterRoomAction);
        this.table.addMouseListener(new DoubleClickAdapter());
    }

    public void set(GoRoomInfos goRoomInfos) {
        this.roomInfos = goRoomInfos;
        for (GoRoomInfo goRoomInfo : goRoomInfos.getInfos()) {
            this.addALine(goRoomInfo);
        }
    }

    private String passwdDisp(boolean bl) {
        if (bl) {
            return "***";
        }
        return "";
    }

    protected void addALine(GoRoomInfo goRoomInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.passwdDisp(goRoomInfo.isLocked));
        vector.add(goRoomInfo.roomNumber);
        vector.add(goRoomInfo.status.toString());
        vector.add(goRoomInfo.counter);
        vector.add(goRoomInfo.info);
        vector.add(goRoomInfo.title);
        this.mtm.addRow(vector);
    }

    protected int getSelectedRoomNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("103_number").equals(this.mtm.getColumnName(i))) continue;
            Integer n3 = (Integer)this.mtm.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private void enterRoom() {
        int n = this.getSelectedRoomNumber();
        if (Global.goRoomPanel.isMeInThisRoom(n)) {
            Global.goRootPane.selectGoeRoom(n);
            return;
        }
        GoRoom goRoom = Global.goRoomPanel.searchRoom(n);
        if (goRoom == null) {
            return;
        }
        if (goRoom.isLocked()) {
            EnterRoomPasswd enterRoomPasswd = new EnterRoomPasswd(Global.root, goRoom.passwd);
            if (enterRoomPasswd.okSelect) {
                Global.netDaemon.enterRoom(n);
            }
        } else {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.enterRoom(n);
        }
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoUserRoomList2.this.setAllSize();
        }
    }

    class EnterRoomAction
    extends AbstractAction {
        EnterRoomAction() {
            super(Global.lang.getKey("103_enter_room"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoUserRoomList2.this.enterRoom();
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GoUserRoomList2.this.enterRoom();
            }
        }
    }
}

