/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.SpringLayout;
import tianyuan.games.base.GoRecordQiZi;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJToggleButton;
import tianyuan.games.gui.goe.dialog.GoMAreYouSureDialog;
import tianyuan.games.gui.goe.goeroom.BoardView;
import tianyuan.games.gui.goe.goeroom.GoCommandPane;
import tianyuan.games.gui.goe.goeroom.GoeRoom;
import tianyuan.games.gui.goe.goeroom.clk.ClockSnap;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;

class InGameCommandPanel
extends GoCommandPane {
    protected GoeRoom guiRoom;
    private boolean commandHasSendFlag = false;
    AbstractButton[][] button = new AbstractButton[2][4];
    protected SizeListener seeSize = new SizeListener();

    InGameCommandPanel() {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
    }

    InGameCommandPanel(GoeRoom goeRoom) {
        this.createButton();
        this.resetLayout();
        this.addComponentListener(this.seeSize);
        this.setGoeRoom(goeRoom);
    }

    public void setGoeRoom(GoeRoom goeRoom) {
        this.guiRoom = goeRoom;
        this.boardView.setBoard(goeRoom.board);
    }

    public void setCommandFlag(boolean bl) {
        this.commandHasSendFlag = bl;
    }

    private void createButton() {
        this.button[0][0] = new MyJToggleButton(Global.lang.getKey("119_test"));
        this.button[0][1] = new MyJButton(Global.lang.getKey("119_stop_one"));
        this.button[0][2] = new MyJButton(Global.lang.getKey("119_regret"));
        this.button[0][3] = new MyJToggleButton(Global.lang.getKey("119_quiet"));
        this.boardView = new BoardView(null);
        this.button[1][0] = this.boardView;
        this.button[1][1] = new MyJButton(Global.lang.getKey("119_compute"));
        this.button[1][2] = new MyJButton(Global.lang.getKey("119_peace"));
        this.button[1][3] = new MyJButton(Global.lang.getKey("119_giveup"));
        this.button[0][0].addItemListener(new TestListener());
        this.button[0][1].addActionListener(new StopOneListener());
        this.button[0][2].addActionListener(new RegretListener());
        this.button[0][3].addItemListener(new QuietListener());
        this.button[1][0].addActionListener(new AnalyzeListener());
        this.button[1][1].addActionListener(new ComputeListener());
        this.button[1][2].addActionListener(new PeaceListener());
        this.button[1][3].addActionListener(new GiveUpListener());
    }

    @Override
    protected void resetLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = (dimension.width - 8) / 4;
        int n2 = (dimension.height - 16) / 2;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.addComp(this.button[i][j], dimension.width / 4 * j + 2, dimension.height / 2 * i - 4 - i * 2, n, n2);
            }
        }
        this.revalidate();
    }

    protected class SizeListener
    extends ComponentAdapter {
        protected SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            InGameCommandPanel.this.resetLayout();
        }
    }

    class GiveUpListener
    implements ActionListener {
        GiveUpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            GoMAreYouSureDialog goMAreYouSureDialog = new GoMAreYouSureDialog(Global.root, Global.lang.getKey("119_giveup"), Global.lang.getKey("132_are_you_sure"), 15);
            if (!goMAreYouSureDialog.isAgreed) {
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.onlyUserNameCommand(5, Global.myName(), InGameCommandPanel.this.guiRoom.coreData.roomNumber);
            }
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.type = 5;
            goRecordQiZi.whoGiveUp = Global.myName();
            InGameCommandPanel.this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
        }
    }

    class PeaceListener
    implements ActionListener {
        PeaceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            if (!InGameCommandPanel.this.guiRoom.inControl.getListenMouseInput()) {
                return;
            }
            GoMAreYouSureDialog goMAreYouSureDialog = new GoMAreYouSureDialog(Global.root, Global.lang.getKey("119_peace"), Global.lang.getKey("132_are_you_sure"), 15);
            if (!goMAreYouSureDialog.isAgreed) {
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.onlyUserNameCommand(8, Global.myName(), InGameCommandPanel.this.guiRoom.coreData.roomNumber);
            }
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.type = 8;
            goRecordQiZi.whoPeaceGame = Global.myName();
            InGameCommandPanel.this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
        }
    }

    class RegretListener
    implements ActionListener {
        RegretListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            if (!InGameCommandPanel.this.guiRoom.inControl.getListenMouseInput()) {
                return;
            }
            if (!InGameCommandPanel.this.guiRoom.coreData.record.rule.canRegret) {
                return;
            }
            if (InGameCommandPanel.this.guiRoom.board.getNormalQiZiCount() < 2) {
                return;
            }
            GoMAreYouSureDialog goMAreYouSureDialog = new GoMAreYouSureDialog(Global.root, Global.lang.getKey("119_regret"), Global.lang.getKey("132_are_you_sure"), 15);
            if (!goMAreYouSureDialog.isAgreed) {
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.onlyUserNameCommand(2, Global.myName(), InGameCommandPanel.this.guiRoom.coreData.roomNumber);
            }
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.type = 2;
            goRecordQiZi.regretUser = Global.myName();
            InGameCommandPanel.this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
        }
    }

    class ComputeListener
    implements ActionListener {
        ComputeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            if (!InGameCommandPanel.this.guiRoom.inControl.getListenMouseInput()) {
                return;
            }
            GoMAreYouSureDialog goMAreYouSureDialog = new GoMAreYouSureDialog(Global.root, Global.lang.getKey("119_compute"), Global.lang.getKey("132_are_you_sure"), 15);
            if (!goMAreYouSureDialog.isAgreed) {
                return;
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.onlyUserNameCommand(11, Global.myName(), InGameCommandPanel.this.guiRoom.coreData.roomNumber);
            }
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.type = 11;
            goRecordQiZi.who_want_compute = Global.myName();
            InGameCommandPanel.this.guiRoom.inControl.setRecordQiZiFromLocal(goRecordQiZi);
        }
    }

    class AnalyzeListener
    implements ActionListener {
        AnalyzeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
        }
    }

    class QuietListener
    implements ItemListener {
        QuietListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            int n = itemEvent.getStateChange();
            if (n == 1) {
                InGameCommandPanel.this.guiRoom.board.setSound(false);
                InGameCommandPanel.this.guiRoom.clock.setSound(false);
            } else {
                InGameCommandPanel.this.guiRoom.board.setSound(true);
                InGameCommandPanel.this.guiRoom.clock.setSound(true);
            }
        }
    }

    class OptionListener
    implements ActionListener {
        OptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
        }
    }

    class StopOneListener
    implements ActionListener {
        StopOneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            if (InGameCommandPanel.this.guiRoom.inControl == null) {
                return;
            }
            if (!InGameCommandPanel.this.guiRoom.inControl.getListenMouseInput()) {
                return;
            }
            int n = InGameCommandPanel.this.guiRoom.inControl.myColorIsBlack() ? 1 : 2;
            QiZi qiZi = new QiZi(n, 9, 9);
            qiZi.flag = (byte)8;
            InGameCommandPanel.this.guiRoom.board.setQiZi(qiZi);
            InGameCommandPanel.this.guiRoom.inControl.setListenMouseInput(false);
            ClockSnap clockSnap = new ClockSnap();
            if (InGameCommandPanel.this.guiRoom.clock.clock != null) {
                InGameCommandPanel.this.guiRoom.clock.clock.click();
                clockSnap = InGameCommandPanel.this.guiRoom.clock.clock.getClockSnap();
            }
            if (Global.netDaemon != null) {
                Global.netDaemon.go.sendQiZi(qiZi, clockSnap, InGameCommandPanel.this.guiRoom.coreData.roomNumber);
            }
            GoRecordQiZi goRecordQiZi = new GoRecordQiZi();
            goRecordQiZi.type = 1;
            goRecordQiZi.qz = qiZi;
            goRecordQiZi.snap = clockSnap;
            InGameCommandPanel.this.guiRoom.inControl.printRecordQiZiMsg(goRecordQiZi, InGameCommandPanel.this.guiRoom.chat);
        }
    }

    class TestListener
    implements ItemListener {
        TestListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (InGameCommandPanel.this.guiRoom == null) {
                return;
            }
            int n = itemEvent.getStateChange();
            if (n == 1) {
                InGameCommandPanel.this.guiRoom.board.enterTestModeForInGame();
            } else {
                InGameCommandPanel.this.guiRoom.board.quitTestModeForInGame();
            }
        }
    }
}

