/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import tianyuan.games.gui.goe.editor.GoEditorInterface;

public class GoEditorToolBar
extends JToolBar {
    private GoEditorInterface editor;
    private byte toolBarStatus = 0;
    private ToolTipItem2[] tips = new ToolTipItem2[12];
    private ToolTipItem[] tipsButtons = new ToolTipItem[2];
    private ButtonGroup buttonGroup = new ButtonGroup();
    private byte count = 0;

    public void setEditor(GoEditorInterface goEditorInterface) {
        this.editor = goEditorInterface;
    }

    public byte getToolBarStatus() {
        return this.toolBarStatus;
    }

    public void setAllTipsEnabled(boolean bl) {
        int n;
        for (n = 0; n < this.tips.length; ++n) {
            this.tips[n].setEnabled(bl);
        }
        for (n = 0; n < this.tipsButtons.length; ++n) {
            this.tipsButtons[n].setEnabled(bl);
        }
    }

    public GoEditorToolBar() {
        super(0);
        this.setRollover(true);
        this.setFloatable(false);
        this.tips[0] = new ToolTipItem2("black white", new ImageIcon("./resource/ico/1_black_white2.png"), true);
        this.tips[1] = new ToolTipItem2("white black", new ImageIcon("./resource/ico/1_black_white.png"));
        this.tips[2] = new ToolTipItem2("black", new ImageIcon("./resource/ico/2_black.png"));
        this.tips[3] = new ToolTipItem2("white", new ImageIcon("./resource/ico/3_white.png"));
        this.tips[4] = new ToolTipItem2("delete", new ImageIcon("./resource/ico/8_delete.png"));
        this.tips[5] = new ToolTipItem2("A", new ImageIcon("./resource/ico/7_A.png"));
        this.tips[6] = new ToolTipItem2("a", new ImageIcon(this.getCharImage('a')));
        this.tips[7] = new ToolTipItem2("#", new ImageIcon(this.getCharImage('#')));
        this.tips[8] = new ToolTipItem2("%", new ImageIcon(this.getCharImage('%')));
        this.tips[9] = new ToolTipItem2("&", new ImageIcon(this.getCharImage('&')));
        this.tips[10] = new ToolTipItem2("$", new ImageIcon(this.getCharImage('$')));
        this.tips[11] = new ToolTipItem2("?", new ImageIcon(this.getCharImage('?')));
        for (int i = 0; i < this.tips.length; ++i) {
            this.buttonGroup.add(this.tips[i]);
            this.add(this.tips[i]);
            this.tips[i].setId((byte)i);
            if (i == 3 || i == 4) {
                this.addSeparator();
            }
            this.tips[i].addItemListener(this.tips[i]);
        }
        this.addSeparator();
        this.addSeparator();
        this.tipsButtons[0] = new ToolTipItem("add sub tree", new ImageIcon("./resource/ico/add_tree.png"), 0);
        this.add(this.tipsButtons[0]);
        this.tipsButtons[1] = new ToolTipItem("del sub tree", new ImageIcon("./resource/ico/del_tree.png"), 1);
        this.add(this.tipsButtons[1]);
    }

    public void clear() {
        this.toolBarStatus = 0;
    }

    private Image getCharImage(char c) {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(0, 0, 20, 20);
        graphics2D.setColor(Color.black);
        Font font = new Font("TimesRoman", 1, 16);
        graphics2D.setFont(font);
        graphics2D.drawString("" + c, 1, 14);
        return bufferedImage;
    }

    public byte getCount() {
        return this.count;
    }

    public void addCount() {
        this.count = this.count < 25 ? (byte)(this.count + 1) : (byte)0;
    }

    public void decCount() {
        this.count = this.count == 0 ? (byte)25 : (byte)(this.count - 1);
    }

    class ToolTipItem2
    extends JToggleButton
    implements ItemListener {
        byte toolTipItemId;

        ToolTipItem2(String string, ImageIcon imageIcon) {
            super(imageIcon);
            this.toolTipItemId = 0;
            this.setToolTipText(string);
        }

        ToolTipItem2(String string, ImageIcon imageIcon, boolean bl) {
            super(imageIcon, bl);
            this.toolTipItemId = 0;
            this.setToolTipText(string);
        }

        ToolTipItem2(String string, ImageIcon imageIcon, byte by) {
            super(imageIcon);
            this.toolTipItemId = 0;
            this.setToolTipText(string);
            this.toolTipItemId = by;
        }

        void setId(byte by) {
            this.toolTipItemId = by;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                GoEditorToolBar.this.toolBarStatus = this.toolTipItemId;
                if (this.toolTipItemId == 0) {
                    if (GoEditorToolBar.this.editor == null) {
                        return;
                    }
                    GoEditorToolBar.this.editor.setBlackFlag(true);
                } else if (this.toolTipItemId == 1) {
                    if (GoEditorToolBar.this.editor == null) {
                        return;
                    }
                    GoEditorToolBar.this.editor.setBlackFlag(false);
                } else if (this.toolTipItemId == 5) {
                    GoEditorToolBar.this.count = (byte)0;
                } else if (this.toolTipItemId == 6) {
                    GoEditorToolBar.this.count = (byte)0;
                }
            }
        }
    }

    class ToolTipItem
    extends JButton
    implements ActionListener {
        byte toolTipItemId;

        ToolTipItem(String string, ImageIcon imageIcon) {
            super(imageIcon);
            this.toolTipItemId = 0;
            this.setToolTipText(string);
            this.addActionListener(this);
        }

        ToolTipItem(String string, ImageIcon imageIcon, byte by) {
            super(imageIcon);
            this.toolTipItemId = 0;
            this.setToolTipText(string);
            this.toolTipItemId = by;
            this.addActionListener(this);
        }

        void setId(byte by) {
            this.toolTipItemId = by;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.toolTipItemId == 0) {
                GoEditorToolBar.this.editor.insertSubTree();
            } else {
                GoEditorToolBar.this.editor.removeSubTree();
            }
        }
    }
}

