/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.commonbbs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import tianyuan.games.base.commonbbs.CommonBbsItem;
import tianyuan.games.base.commonbbs.CommonBbsItemInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;

class CommonBbsUpLoader
extends MyJPanel {
    private JLabel titleLabel = new JLabel(Global.lang.getKey("243_title"));
    private JButton upLoad = new JButton(Global.lang.getKey("243_upload"));
    private JButton clearAll = new JButton(Global.lang.getKey("243_clear"));
    private JTextField title = new JTextField("");
    private JTextArea textBody = new JTextArea();
    private JScrollPane sp = new JScrollPane(this.textBody);

    CommonBbsUpLoader() {
        this.myReLayout();
        this.clearAll.addActionListener(new ClearListener());
        this.upLoad.addActionListener(new SubmitListener());
    }

    public void replyItem(CommonBbsItem commonBbsItem) {
        this.myClear();
        this.title.setText("Re: " + commonBbsItem.getTitle());
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        stringBuilder.append("\n-----------------------------------------------------\n");
        stringBuilder.append(this.infoStr(commonBbsItem.getInfo()));
        stringBuilder.append("     " + commonBbsItem.getBody());
        this.textBody.setText(stringBuilder.toString());
    }

    private String infoStr(CommonBbsItemInfo commonBbsItemInfo) {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("     " + Global.lang.getKey("241_view_author") + " ");
        stringBuilder.append(commonBbsItemInfo.author + "\n");
        stringBuilder.append("     " + Global.lang.getKey("241_view_title") + " ");
        stringBuilder.append(commonBbsItemInfo.title + "\n");
        stringBuilder.append("     " + Global.lang.getKey("241_view_create_time") + " ");
        stringBuilder.append(this.toDateStr(commonBbsItemInfo.createTime) + "\n");
        return stringBuilder.toString();
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = 87;
        int n2 = dimension.width - n * 3;
        int n3 = 30;
        this.myAddComp(this.titleLabel, 5, 3, n - 5, n3 - 6);
        this.myAddComp(this.title, n - 5, 3, n2, n3 - 6);
        this.myAddComp(this.upLoad, n + n2, 3, n - 5, n3 - 6);
        this.myAddComp(this.clearAll, n + n2 + n, 3, n - 5, n3 - 6);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 2);
        this.revalidate();
    }

    private void myClear() {
        this.textBody.setText("");
        this.title.setText("");
    }

    class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsUpLoader.this.myClear();
        }
    }

    class SubmitListener
    implements ActionListener {
        SubmitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommonBbsItem commonBbsItem = new CommonBbsItem();
            String string = CommonBbsUpLoader.this.title.getText();
            String string2 = CommonBbsUpLoader.this.textBody.getText();
            if (string == null || string.equals("")) {
                return;
            }
            if (string2 == null || string2.equals("")) {
                return;
            }
            commonBbsItem.setTitle(string);
            commonBbsItem.setBody(string2);
            commonBbsItem.setAuthor(Global.myName());
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.commonBbsAddItem(Global.commonBbs.getCurrentTopic(), commonBbsItem);
            CommonBbsUpLoader.this.myClear();
        }
    }
}

