/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import tianyuan.games.base.GoBbsData;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserSeeInGameCount;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.base.commonbbs.CommonBbsResultData;
import tianyuan.games.base.innermail.InnerMailResultData;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.AudioRTSRequestDialog;
import tianyuan.games.gui.goe.dialog.BeChallengedNoRule;
import tianyuan.games.gui.goe.dialog.ChallengeWithRule;
import tianyuan.games.gui.goe.dialog.Login;
import tianyuan.games.gui.goe.dialog.TimeLimitShowInfoDialog;
import tianyuan.games.gui.goe.dialog.TimeLimitShowWarningDialog;
import tianyuan.games.gui.goe.editor.GoNetEditor;
import tianyuan.games.gui.goe.editor.GoReader;
import tianyuan.games.net.GoServerResponse;
import tianyuan.games.net.ServerMessage;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.client.NetResponseSink;
import tianyuan.games.net.client.VoIpAdapter;

public class NetSink
implements NetResponseSink {
    NetListener nl;
    public LinkedBlockingQueue<ServerResponse> serverEventQueue = new LinkedBlockingQueue();

    public NetSink() {
        this.nl = new NetListener();
        this.nl.start();
    }

    private void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void runLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public void audioRTSProcess(ServerResponse serverResponse) {
        UserAllInfo userAllInfo = Global.goRoomPanel.search(serverResponse.audioTalkRtsRequestSrcUser);
        if (userAllInfo == null) {
            return;
        }
        Global.goCollogue.displayMessage(" " + Global.lang.getKey("201_request_voip_message_dest"), serverResponse.audioTalkRtsRequestSrcUser);
        new AudioRTSRequestDialog(Global.root, userAllInfo, serverResponse);
    }

    public void audioCTSProcess(ServerResponse serverResponse) {
        if (serverResponse.audioTalkCtsUserResult == 1) {
            Global.goCollogue.displayMessage(" " + Global.lang.getKey("201_agree_voip_src"), serverResponse.audioTalkCtsRequestSrcUser);
            if (serverResponse.audioTalkCtsFormatResult == 4) {
                VoIpAdapter voIpAdapter = new VoIpAdapter(serverResponse.audioTalkCtsRequestSrcUserIp, serverResponse.audioTalkCtsRequestSrcUserP2pPort);
                Global.goCollogue.addVoIpAdapter(voIpAdapter, serverResponse.audioTalkCtsRequestSrcUser);
            }
        } else {
            Global.goCollogue.displayMessage(" " + Global.lang.getKey("201_refuse_voip_src"), serverResponse.audioTalkCtsRequestSrcUser);
        }
    }

    public void audioRRTSProcess(ServerResponse serverResponse) {
        System.out.println("audioRRTSProcess");
    }

    @Override
    public void displayMessage(ServerMessage serverMessage) {
        Global.goRoomPanel.displayMessage(serverMessage);
    }

    @Override
    public void connectError() {
        Global.resetAll();
        this.showWarningDialog(Global.lang.getKey("106_net_connect_error"));
    }

    @Override
    public void netWorkBroken() {
        Global.resetAll();
        this.showWarningDialog(Global.lang.getKey("106_net_error"));
    }

    public void loginSucceedOrNewUser(ServerResponse serverResponse) {
        Global.publicSetting = serverResponse.publicSetting;
        Global.myUserInfo = serverResponse.myInfo;
        Global.myUserTmpInfo = serverResponse.myTmpInfo;
        Global.goRoomPanel.add(serverResponse.myInfo, serverResponse.myTmpInfo, serverResponse.userAllInfos, serverResponse.rooms);
        if (serverResponse.myInfo.adminField.isNetManager) {
            Global.setNetManagerUI();
        } else {
            Global.setNormalUserUI();
        }
        Global.root.setTitle(Global.myName() + " - " + Global.getServerAddress() + " - " + Global.lang.getKey("1_client_name") + " - " + "  " + serverResponse.clientTitle);
        Global.netDaemon.bbsGetMyCollectionQiPuIndex(9000000);
        Global.netDaemon.innerMailInBoxGetIndex(9000000);
        Global.netDaemon.innerMailOutBoxGetIndex(9000000);
        Global.goQipuBbs.setBbsTopics(serverResponse.bbsTopics);
        Global.commonBbs.setBbsTopics(serverResponse.commonBbsTopics);
        Global.goQipuBbs.setManagerFlag(serverResponse.myInfo.adminField.isNetManager);
        if (Global.goRoomPanel.getGoeRoomsCount() == 0) {
            // empty if block
        }
        this.showInfoDialogWithTimeLimit(Global.lang.getKey("1_welcome") + ": " + Global.myNameWithGoLevel() + "\n " + serverResponse.clientWelcomeMsg, 6);
    }

    @Override
    public void oneRoomCreated(GoRoom goRoom) {
        Global.goRoomPanel.oneRoomCreated(goRoom);
    }

    @Override
    public void oneRoomExit(int n) {
        Global.goRoomPanel.oneRoomEnd(n);
    }

    @Override
    public void userGoInRoom(String string, int n) {
        Global.goRoomPanel.userGoInRoom(string, n);
    }

    @Override
    public void userGoOutRoom(String string, int n) {
        Global.goRoomPanel.userGoOutRoom(string, n);
    }

    public void netManagerUserTable(Vector<UserInfo> vector) {
        Global.netManagerAllUser.add(vector);
    }

    public void addManagerUserInfo(UserInfo userInfo) {
        Global.netManagerAllUser.add(userInfo);
    }

    public void userTablePageProcess(Vector<UserInfo> vector, int n) {
        Global.netManagerAllUser.setPage(vector, n);
    }

    public void serverManagerCommandResultProcess(String string, String string2) {
        Global.serverManagerCommander.displayMessage(string, string2);
    }

    public void commonBbsResponseProcess(CommonBbsResultData commonBbsResultData) {
        switch (commonBbsResultData.type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Global.commonBbs.addItem(commonBbsResultData.topicName, commonBbsResultData.itemInfo);
                break;
            }
            case 4: {
                Global.commonBbs.delItem(commonBbsResultData.topicName, commonBbsResultData.commonBbsItemNumber);
                break;
            }
            case 5: {
                Global.commonBbs.getItem(commonBbsResultData.topicName, commonBbsResultData.commonBbsData);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                Global.commonBbs.setItemIndex(commonBbsResultData.topicName, commonBbsResultData.pageNumber, commonBbsResultData.index);
            }
        }
    }

    public void innerMailResponseProcess(InnerMailResultData innerMailResultData) {
        switch (innerMailResultData.type) {
            case 1: {
                Global.innerMail.sendMail(innerMailResultData.info);
                break;
            }
            case 2: {
                Global.innerMail.getMail(innerMailResultData.mailboxType, innerMailResultData.mail);
                break;
            }
            case 3: {
                Global.innerMail.delMail(innerMailResultData.mailboxType, innerMailResultData.mailNumber);
                break;
            }
            case 4: {
                Global.innerMail.getIndex(innerMailResultData.mailboxType, innerMailResultData.pageNumber, innerMailResultData.index);
                break;
            }
            case 5: {
                Global.innerMail.newMail(innerMailResultData.info);
                break;
            }
            case 6: {
                this.showWarningDialogWithTimeLimit(Global.lang.getKey("254_user") + " " + innerMailResultData.mail.head.receiver + " " + Global.lang.getKey("254_not_exist"), 10);
                Global.innerMail.receiverNotExist(innerMailResultData.mail);
            }
        }
    }

    public void goBbsResponseProcess(GoBbsData goBbsData) {
        switch (goBbsData.type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (goBbsData.isMyCollectionData) {
                    Global.goQipuBbs.addMyCollectionGoQiPuSucceed(goBbsData.gqpInfo);
                    break;
                }
                Global.goQipuBbs.addGoQiPuSucceed(goBbsData.topicName, goBbsData.gqpInfo);
                break;
            }
            case 13: {
                if (goBbsData.isMyCollectionData) {
                    Global.goQipuBbs.modifyMyCollectionGoQiPuSucceed(goBbsData.gqpInfo);
                } else {
                    Global.goQipuBbs.modifyGoQiPuSucceed(goBbsData.topicName, goBbsData.gqpInfo);
                }
                this.showInfoDialogWithTimeLimit(Global.lang.getKey("255_modify_qipu_succeed"), 10);
                break;
            }
            case 4: {
                if (goBbsData.isMyCollectionData) {
                    Global.goQipuBbs.delMyCollectionGoQiPuSucceed(goBbsData.goQiPuNumber);
                    break;
                }
                Global.goQipuBbs.delGoQiPuSucceed(goBbsData.topicName, goBbsData.goQiPuNumber);
                break;
            }
            case 5: {
                if (goBbsData.isMyCollectionData) {
                    Global.goRootPane.addGoNetEditorPane(new GoNetEditor(true, Global.lang.getKey("220_collection"), goBbsData.qiPu, goBbsData.goQiPuNumber), true);
                    break;
                }
                if (goBbsData.gqpInfo.author.equals(Global.myName())) {
                    Global.goRootPane.addGoNetEditorPane(new GoNetEditor(false, goBbsData.topicName, goBbsData.qiPu, goBbsData.goQiPuNumber), true);
                    break;
                }
                Global.goRootPane.addGoReaderPane(new GoReader(goBbsData.topicName, goBbsData.qiPu, goBbsData.goQiPuNumber), true);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (goBbsData.isMyCollectionData) {
                    Global.goQipuBbs.setMyCollectionQiPuIndex(goBbsData.pageNumber, goBbsData.index);
                    break;
                }
                Global.goQipuBbs.setQiPuIndex(goBbsData.topicName, goBbsData.pageNumber, goBbsData.index);
                break;
            }
        }
    }

    public void goResponseProcess(GoServerResponse goServerResponse) {
        switch (goServerResponse.type) {
            case 10: {
                UserAllInfo userAllInfo = Global.goRoomPanel.search(goServerResponse.inventionUser);
                if (userAllInfo == null) break;
                new BeChallengedNoRule(Global.root, userAllInfo);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 41: {
                UserAllInfo userAllInfo = Global.goRoomPanel.search(goServerResponse.challenge_rule.source);
                if (userAllInfo == null) {
                    System.out.println("challenger");
                    return;
                }
                ChallengeWithRule challengeWithRule = new ChallengeWithRule(Global.root, goServerResponse.challenge_rule);
                break;
            }
            case 42: {
                Global.goRoomPanel.refuse(goServerResponse);
                break;
            }
            case 43: {
                Global.goRoomPanel.beginGame(goServerResponse.beginGameRecord, goServerResponse.beginGameRoomNumber);
                break;
            }
            case 44: {
                Global.goRoomPanel.publishGameStatus(goServerResponse.goGameStatus, goServerResponse.statusGoRoomNumber);
                break;
            }
            case 45: {
                Global.goRoomPanel.publishGameRecordHead(goServerResponse.headGoGameRecord, goServerResponse.headRoomNumber);
                break;
            }
            case 46: {
                Global.goRoomPanel.publishUserGameCount(goServerResponse.counterUserName, goServerResponse.counterInGameCounter, goServerResponse.counterSeeGameCounter);
                break;
            }
            case 47: {
                for (UserSeeInGameCount userSeeInGameCount : goServerResponse.blockUserSeeInGameCount) {
                    Global.goRoomPanel.publishUserGameCount(userSeeInGameCount.counterUserName, userSeeInGameCount.counterInGameCounter, userSeeInGameCount.counterSeeGameCounter);
                }
                break;
            }
            case 48: {
                Global.goRoomPanel.infoHeadChange(goServerResponse.info);
                break;
            }
            case 50: {
                Global.goRoomPanel.returnGoGameIndex(goServerResponse.userNameOfGoGameIndex, goServerResponse.returnGoGameIndex, goServerResponse.pageNumberOfGameIndex);
                break;
            }
            case 51: {
                Global.goRoomPanel.returnGoGameRecord(goServerResponse.userNameOfGoGameRecord, goServerResponse.returnGoGameRecord);
                break;
            }
            case 60: {
                Global.goRoomPanel.sendRecordQiZi(goServerResponse.rqz, goServerResponse.rqzRoomNumber, goServerResponse.rqzIsInGame);
                break;
            }
            case 71: {
                Global.goRoomPanel.agreeStudyGame(goServerResponse.agreeStudyGameUserName, goServerResponse.agreeStudyGameRoomNumber);
                break;
            }
            case 72: {
                Global.goRoomPanel.refuseStudyGame(goServerResponse.refuseStudyGameUserName, goServerResponse.refuseStudyGameRoomNumber);
                break;
            }
            case 73: {
                Global.goRoomPanel.beginStudyGame(goServerResponse.beginStudyGameRoomNumber);
                break;
            }
            case 74: {
                Global.goRoomPanel.endStudyGame(goServerResponse.endStudyGameRoomNumber);
                break;
            }
            case 80: {
                Global.goRoomPanel.gamblingAddMoney(goServerResponse.gamblingRoomNumber, goServerResponse.gamblingUser, goServerResponse.gamblingIsSelectBlackWin);
                break;
            }
            case 81: {
                Global.goRoomPanel.gamblingGameInfo(goServerResponse.gamblingGameInfoRoomNumber, goServerResponse.goGamblingGameInfo);
                break;
            }
            default: {
                System.out.println("unknown GoServerResponse type" + goServerResponse.type);
            }
        }
    }

    public void searchUserDetialResult(UserInfo userInfo, GoRoomInfos goRoomInfos, int n, boolean bl, boolean bl2, String string) {
        if (n == -2) {
            if (Global.netManagerAllUser != null) {
                Global.netManagerAllUser.clearAndAddItem(userInfo);
            }
        } else if (bl) {
            Global.goRoomPanel.reportUserDetial(bl2, userInfo, goRoomInfos, n);
        } else {
            Global.goRoomPanel.userNoFind(string, n);
        }
    }

    public void infoChangeProcess(UserInfo userInfo, UserTmpInfo userTmpInfo) {
        Global.goRoomPanel.infoChange(userInfo, userTmpInfo);
    }

    protected void passwdWrong() {
        this.showWarningDialog(Global.lang.getKey("1_passwd_wrong"));
        Global.resetAll();
        Login login = new Login(Global.root);
        Global.loginProcess(login);
    }

    protected void loginSucceed() {
        this.showInfoDialogWithTimeLimit(Global.lang.getKey("106_login_succeed"), 6);
    }

    private void showWarningDialogWithTimeLimit(String string, int n) {
        TimeLimitShowWarningDialog timeLimitShowWarningDialog = new TimeLimitShowWarningDialog(string, n);
        timeLimitShowWarningDialog.doShow();
    }

    private void showWarningDialog(String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        JDialog jDialog = jOptionPane.createDialog(Global.root, "   ");
        jDialog.setVisible(true);
    }

    private void showInfoDialog(String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 1);
        JDialog jDialog = jOptionPane.createDialog(Global.root, "   ");
        jDialog.setVisible(true);
    }

    private void showInfoDialogWithTimeLimit(String string, int n) {
        TimeLimitShowInfoDialog timeLimitShowInfoDialog = new TimeLimitShowInfoDialog(string, n);
        timeLimitShowInfoDialog.doShow();
    }

    @Override
    public void put(ServerResponse serverResponse) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.serverEventQueue.put(serverResponse);
                break;
            }
            catch (InterruptedException interruptedException) {
                Global.sleepSec(1);
                System.out.println("serverEventQueue.put error.");
                continue;
            }
        }
    }

    private class RunForUpdateSwing
    implements Runnable {
        ServerResponse sr;

        private RunForUpdateSwing() {
        }

        public void setValue(ServerResponse serverResponse) {
            this.sr = serverResponse;
        }

        @Override
        public void run() {
            try {
                if (this.sr.type == 1 || this.sr.type == 2) {
                    NetSink.this.loginSucceedOrNewUser(this.sr);
                } else if (this.sr.type == 4) {
                    Global.exitSystem();
                } else if (this.sr.type == 17) {
                    if (this.sr.oneUserLoginInfo.userName.equals(Global.myUserInfo.userName)) {
                        return;
                    }
                    Global.goRoomPanel.oneUserLogin(this.sr.oneUserLoginInfo, this.sr.oneUserLoginTmpInfo);
                } else if (this.sr.type == 18) {
                    Global.goRoomPanel.oneUserLogout(this.sr.logoutUserName);
                } else if (this.sr.type == 19) {
                    Global.goRoomPanel.oneUserBreakLine(this.sr.breakLineUserName);
                } else if (this.sr.type == 20) {
                    Global.goRoomPanel.oneUserBreakLineTimeOut(this.sr.breakLineTimeOutUserName);
                } else if (this.sr.type == 21) {
                    System.out.println("SAME_NAME_USER_LOGIN_SUCCEED");
                } else if (this.sr.type == 121) {
                    NetSink.this.infoChangeProcess(this.sr.changeInfo, this.sr.changeTmpInfo);
                } else if (this.sr.type == 3) {
                    NetSink.this.passwdWrong();
                } else if (this.sr.type == 30) {
                    NetSink.this.oneRoomCreated(this.sr.createdRoom);
                } else if (this.sr.type == 31) {
                    NetSink.this.oneRoomExit(this.sr.endRoomNumber);
                } else if (this.sr.type == 52) {
                    NetSink.this.searchUserDetialResult(this.sr.searchUserResult, this.sr.searchUserResultRoom, this.sr.searchUserResultSourceRoomNumber, this.sr.isBeSearchedUserFind, this.sr.isBeSearchedUserOnLine, this.sr.beSearchedUser);
                } else if (this.sr.type == 40) {
                    NetSink.this.displayMessage(this.sr.serverMessage);
                } else if (this.sr.type == 50) {
                    NetSink.this.userGoInRoom(this.sr.goInUser, this.sr.goInRoomNumber);
                } else if (this.sr.type == 51) {
                    NetSink.this.userGoOutRoom(this.sr.goOutUser, this.sr.goOutRoomNumber);
                } else if (this.sr.type == 60) {
                    NetSink.this.netManagerUserTable(this.sr.adminUserTable);
                } else if (this.sr.type == 61) {
                    NetSink.this.addManagerUserInfo(this.sr.adminOneUserCreate);
                } else if (this.sr.type == 62) {
                    NetSink.this.userTablePageProcess(this.sr.userTablePage, this.sr.pageNumberOfUserTable);
                } else if (this.sr.type == 70) {
                    NetSink.this.goResponseProcess(this.sr.goResponse);
                } else if (this.sr.type == 76) {
                    NetSink.this.audioRTSProcess(this.sr);
                } else if (this.sr.type == 77) {
                    NetSink.this.audioCTSProcess(this.sr);
                } else if (this.sr.type == 78) {
                    NetSink.this.audioRRTSProcess(this.sr);
                } else if (this.sr.type == 79) {
                    NetSink.this.goBbsResponseProcess(this.sr.goBbsDataResponse);
                } else if (this.sr.type == 80) {
                    NetSink.this.commonBbsResponseProcess(this.sr.commonBbsDataResponse);
                } else if (this.sr.type == 81) {
                    NetSink.this.innerMailResponseProcess(this.sr.innerMailDataResponse);
                } else if (this.sr.type == 100) {
                    Global.goRoomPanel.oneUserExitStudyRoomStatus(this.sr.exitStudyRoomNumber, this.sr.exitStudyUserName);
                } else if (this.sr.type == 101) {
                    Global.goRoomPanel.studyRefPublish(this.sr.publishStudyRefRoomNumber, this.sr.publishStudyRefMotherNumber, this.sr.publishStudyRefMotherPosition, this.sr.publishStudyRef, this.sr.publishRefAuthor, this.sr.publishRefNumber);
                } else if (this.sr.type == 102) {
                    Global.goRoomPanel.studyRefDelete(this.sr.delPublishStudyRefRoomNumber, this.sr.delPublishStudyRefNumber, this.sr.delPublishRefCommander);
                } else if (this.sr.type == 120) {
                    Global.goRoomPanel.updateUserMoneyChange(this.sr.usernameAndMoneys);
                } else if (this.sr.type == 123) {
                    NetSink.this.serverManagerCommandResultProcess(this.sr.serverManagerCommand, this.sr.serverManagerCommandResult);
                } else {
                    System.out.println("unknown type server response :" + this.sr.type);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class NetListener
    extends Thread {
        private NetListener() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ServerResponse serverResponse;
                        if ((serverResponse = NetSink.this.serverEventQueue.take()) == null) {
                            NetSink.this.sleepSec(1);
                            continue;
                        }
                        RunForUpdateSwing runForUpdateSwing = new RunForUpdateSwing();
                        runForUpdateSwing.setValue(serverResponse);
                        this.run(runForUpdateSwing);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void run(Runnable runnable) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

