/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.UIManager;
import org.phoenix.util.LogTool;
import org.phoenix.util.MyProperties;
import org.phoenix.util.RwProperties;
import tianyuan.games.base.PublicSetting;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.gui.BottomPane;
import tianyuan.games.gui.Client;
import tianyuan.games.gui.MyAllRootPane;
import tianyuan.games.gui.NetSink;
import tianyuan.games.gui.chat.MyChatRootPane;
import tianyuan.games.gui.chat.hall.ChatRoomPanel;
import tianyuan.games.gui.commonbbs.CommonBbsMainPane;
import tianyuan.games.gui.goe.CollogueJFrame;
import tianyuan.games.gui.goe.MyGoRootPane;
import tianyuan.games.gui.goe.dialog.AddressStorage;
import tianyuan.games.gui.goe.dialog.Login;
import tianyuan.games.gui.goe.hall.GoRoomPanel;
import tianyuan.games.gui.goe.qipubbs.BbsMainPane;
import tianyuan.games.gui.innermail.InnerMailMainPane;
import tianyuan.games.gui.netmanager.MyNetManagerRootPane;
import tianyuan.games.gui.netmanager.NetManagerCommander;
import tianyuan.games.gui.netmanager.table.NetManagerTable;
import tianyuan.games.net.client.NetResponse;
import tianyuan.games.net.client.NetResponseSink;
import tianyuan.games.net.client.P2pDaemon;

public class Global {
    public static final int CLIENT_VERSION = 1010;
    public static UserInfo myUserInfo;
    public static UserTmpInfo myUserTmpInfo;
    public static MyProperties lang;
    public static RwProperties paramter;
    public static RwProperties paramterLang;
    public static AddressStorage addrStorage;
    public static PublicSetting publicSetting;
    public static Client root;
    public static BottomPane bPane;
    public static CollogueJFrame goCollogue;
    public static BbsMainPane goQipuBbs;
    public static CommonBbsMainPane commonBbs;
    public static InnerMailMainPane innerMail;
    public static GoRoomPanel goRoomPanel;
    public static ChatRoomPanel chatRoomPanel;
    public static NetManagerTable netManagerAllUser;
    public static NetManagerCommander serverManagerCommander;
    public static MyAllRootPane rootPane;
    public static MyGoRootPane goRootPane;
    public static MyChatRootPane chatRootPane;
    public static MyNetManagerRootPane netManagerRootPane;
    public static NetResponse netDaemon;
    public static P2pDaemon p2pDaemon;
    public static NetResponseSink netSink;
    public static LogTool log;
    public static int tcpPort;

    public static String myName() {
        if (myUserInfo == null) {
            return null;
        }
        return Global.myUserInfo.userName;
    }

    public static String myNameWithGoLevel() {
        if (myUserInfo == null) {
            return "";
        }
        return myUserInfo.nameWithGoLevel(lang);
    }

    public static boolean isAdmin() {
        return Global.myUserInfo.adminField.isNetManager;
    }

    public static long myMoney() {
        return Global.myUserInfo.money.longValue();
    }

    public static void decMoney(short s) {
        Global.myUserInfo.money.dec(s);
    }

    public static void revalidate() {
        commonBbs.setAllSize();
        innerMail.setAllSize();
        goQipuBbs.setAllSize();
    }

    public static void setLeftRightTabbedLayout() {
        rootPane.setLeftTabbedLayout();
        goRootPane.setRightTabbedLayout();
    }

    public static void setTopBottomTabbedLayout() {
        rootPane.setBottomTabbedLayout();
        goRootPane.setTopTabbedLayout();
    }

    public static void setNetManagerUI() {
        netManagerRootPane = new MyNetManagerRootPane();
        rootPane.add(lang.getKey("100_net_manager"), netManagerRootPane);
        netManagerAllUser = new NetManagerTable();
        netManagerRootPane.add(lang.getKey("100_all_user_manager"), netManagerAllUser);
        serverManagerCommander = new NetManagerCommander();
        netManagerRootPane.add(lang.getKey("100_server_manager"), serverManagerCommander);
        commonBbs.setManagerFlag(true);
        root.validate();
    }

    public static void setNormalUserUI() {
        root.validate();
    }

    public static String getServerAddress() {
        return netDaemon.getServerAddress();
    }

    public static void init(String string) {
        try {
            log.setLevel(Level.OFF);
            paramter = new RwProperties("./resource/properties/paramter");
            paramter.readIn();
            addrStorage = new AddressStorage("./resource/properties/paramter_addr");
            paramterLang = new RwProperties("./resource/properties/paramter_lang");
            paramterLang.readIn();
            String string2 = paramterLang.getString("1_filename");
            FileInputStream fileInputStream = null;
            fileInputStream = string != null ? new FileInputStream("./resource/properties/" + string) : (string2 != null && !string2.equals("") ? new FileInputStream("./resource/properties/" + string2) : new FileInputStream("./resource/properties/lang"));
            lang = new MyProperties(fileInputStream);
            Global.styleSet();
            goCollogue = new CollogueJFrame();
        }
        catch (Exception exception) {
            System.out.println("Global init fail. ");
            exception.printStackTrace();
        }
    }

    public static void resetAll() {
        if (goRootPane != null) {
            goRootPane.reset();
        }
        if (goRoomPanel != null) {
            goRoomPanel.reset();
        }
        if (netManagerAllUser != null) {
            netManagerAllUser.reset();
            rootPane.remove(netManagerRootPane);
        }
        if (chatRoomPanel != null) {
            chatRoomPanel.reset();
        }
        if (netDaemon != null) {
            netDaemon.reset();
            netDaemon = null;
        }
        if (goCollogue != null) {
            goCollogue.myReset();
        }
        if (goQipuBbs != null) {
            goQipuBbs.myReset();
        }
        if (commonBbs != null) {
            commonBbs.myReset();
        }
        if (innerMail != null) {
            // empty if block
        }
    }

    public static void loginProcess(Login login) {
        if (login.isCanUse) {
            if (login.isProxySet) {
                Properties properties = System.getProperties();
                properties.put("socksProxyPort", login.proxy_port.getText());
                properties.put("socksProxyHost", login.proxy_address.getText());
                System.setProperties(properties);
            }
            netDaemon = new NetResponse(login.getServerAddress(), login.userName.getText(), new String(login.passwd.getPassword()), login.newUserLevel, tcpPort);
        } else {
            Global.exitSystem();
        }
    }

    public static void sleepSec(int n) {
        if (n < 0) {
            return;
        }
        if (n == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void mailToAction(String string) {
        innerMail.mailToAction(string);
        rootPane.setSelectedComponent(innerMail);
    }

    public static void styleSet() {
        boolean bl = false;
        try {
            if (bl) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exitSystem() {
        System.exit(0);
    }

    public static Font[] getAllFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        return fontArray;
    }

    public static String[] getAllFontName() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        return stringArray;
    }

    public static UIManager.LookAndFeelInfo[] getAllLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        return lookAndFeelInfoArray;
    }

    static {
        publicSetting = new PublicSetting();
        netSink = new NetSink();
        log = new LogTool();
        tcpPort = 7703;
    }
}

