/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import tianyuan.games.base.GameResult;
import tianyuan.games.base.GoGrade;
import tianyuan.games.base.GoGradeDetial;
import tianyuan.games.base.GoGradeHistory;
import tianyuan.games.base.Level;
import tianyuan.games.base.LevelGradeUpDown;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class GoField
extends Root {
    public Level currentLevel = new Level(1);
    public GoGrade total = new GoGrade();
    public boolean isAcceptInvitation = true;
    public boolean isAcceptPersonMessage = true;
    public GoGrade currentGrade;
    public GoGradeDetial currentDetial;
    public GoGradeHistory history;
    public byte openRoomTotal = (byte)5;
    public boolean isCanSeeGame = true;
    public boolean isCanInFirendGame = true;
    public boolean isCanInNoFirendGame = true;

    public GoField() {
        this.serverSideInit();
    }

    public int getCurrentLevelDetail() {
        return this.currentLevel.getDetail();
    }

    public void modifyInfo(GoField goField) {
        this.isAcceptInvitation = goField.isAcceptInvitation;
        this.isAcceptPersonMessage = goField.isAcceptPersonMessage;
    }

    public void writeHead(TyBaseOutput tyBaseOutput) throws IOException {
        this.currentLevel.write(tyBaseOutput);
        this.total.write(tyBaseOutput);
        tyBaseOutput.writeBoolean(this.isAcceptInvitation);
        tyBaseOutput.writeBoolean(this.isAcceptPersonMessage);
    }

    public void readHead(TyBaseInput tyBaseInput) throws IOException {
        this.currentLevel.read(tyBaseInput);
        this.total.read(tyBaseInput);
        this.isAcceptInvitation = tyBaseInput.readBoolean();
        this.isAcceptPersonMessage = tyBaseInput.readBoolean();
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        this.writeHead(tyBaseOutput);
        if (this.currentGrade == null) {
            this.currentGrade = new GoGrade();
        }
        this.currentGrade.write(tyBaseOutput);
        if (this.currentDetial == null) {
            this.currentDetial = new GoGradeDetial();
        }
        this.currentDetial.write(tyBaseOutput);
        if (this.history == null) {
            this.history = new GoGradeHistory();
        }
        this.history.write(tyBaseOutput);
        tyBaseOutput.writeByte(this.openRoomTotal);
        tyBaseOutput.writeBoolean(this.isCanSeeGame);
        tyBaseOutput.writeBoolean(this.isCanInFirendGame);
        tyBaseOutput.writeBoolean(this.isCanInNoFirendGame);
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.readHead(tyBaseInput);
        this.currentGrade = new GoGrade();
        this.currentGrade.read(tyBaseInput);
        this.currentDetial = new GoGradeDetial();
        this.currentDetial.read(tyBaseInput);
        this.history = new GoGradeHistory();
        this.history.read(tyBaseInput);
        this.openRoomTotal = tyBaseInput.readByte();
        this.isCanSeeGame = tyBaseInput.readBoolean();
        this.isCanInFirendGame = tyBaseInput.readBoolean();
        this.isCanInNoFirendGame = tyBaseInput.readBoolean();
    }

    public void serverSideInit() {
        this.currentGrade = new GoGrade();
        this.currentDetial = new GoGradeDetial();
        this.history = new GoGradeHistory();
    }

    public void clientSideClip() {
        this.currentGrade = null;
        this.currentDetial = null;
        this.history = null;
    }

    public void registGameResult(GameResult gameResult) {
        GoGrade goGrade = new GoGrade();
        goGrade.total = 1;
        if (gameResult == GameResult.win) {
            goGrade.win = 1;
        } else if (gameResult == GameResult.fail) {
            goGrade.fail = 1;
        } else if (gameResult == GameResult.peace) {
            goGrade.peace = 1;
        } else if (gameResult == GameResult.resultless) {
            // empty if block
        }
        this.currentDetial.add(gameResult);
        this.add(goGrade);
        this.computeLevel();
    }

    public void addCurrentBreakLine(int n) {
        GoGrade goGrade = new GoGrade();
        goGrade.inGameBreakLine = n;
        this.add(goGrade);
    }

    public void addCurrentFlee(int n) {
        GoGrade goGrade = new GoGrade();
        goGrade.inGameFlee = n;
        this.add(goGrade);
    }

    private void add(GoGrade goGrade) {
        this.currentGrade.add(goGrade);
        this.total.add(goGrade);
        this.history.add(this.currentLevel, goGrade);
    }

    private void computeLevel() {
        byte by = LevelGradeUpDown.compute(this.currentLevel, this.currentGrade);
        if (by == 1) {
            this.currentLevel.add();
            this.currentGrade.clear();
            this.currentDetial.clear();
        } else if (by == 2) {
            this.currentLevel.dec();
            this.currentGrade.clear();
            this.currentDetial.clear();
        } else if (by == 3) {
            this.currentGrade.clear();
            this.currentDetial.clear();
        } else if (by != 4 && by == 5) {
            System.out.println("error in computeLevel.");
        }
    }
}

