/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.IOException;
import java.util.Vector;
import tianyuan.games.base.RoomStatus;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.UserAllInfo;
import tianyuan.games.base.UserInfo;
import tianyuan.games.base.UserTmpInfo;
import tianyuan.games.net.ServerResponse;
import tianyuan.games.net.server.ClientAdapter;

public class Room
extends Root {
    public int roomNumber = -1;
    public String title = " ";
    public String info = " ";
    public String passwd = "";
    public RoomStatus status = new RoomStatus(1);
    private long lastAgreeOrRefuseStudyTime = -1L;
    private boolean lastAgreeOrRefuseStudyUsed = false;
    private boolean lastAgreeStudy = false;
    public Vector<ClientAdapter> members = new Vector();
    public Vector<UserAllInfo> userinfos = new Vector();

    public boolean isLocked() {
        return this.passwd != null && this.passwd.length() != 0;
    }

    public void setStudyStatus(boolean bl) {
        if (!this.lastAgreeOrRefuseStudyUsed) {
            this.lastAgreeOrRefuseStudyUsed = true;
            this.lastAgreeStudy = bl;
            this.lastAgreeOrRefuseStudyTime = System.currentTimeMillis();
        } else {
            long l = System.currentTimeMillis();
            if (l - this.lastAgreeOrRefuseStudyTime > 15000L) {
                this.lastAgreeOrRefuseStudyUsed = true;
                this.lastAgreeStudy = bl;
                this.lastAgreeOrRefuseStudyTime = l;
            } else if (this.lastAgreeStudy && bl) {
                this.status.setValue((byte)8);
                this.lastAgreeOrRefuseStudyUsed = true;
                this.lastAgreeStudy = true;
                this.lastAgreeOrRefuseStudyTime = l;
            }
        }
    }

    public ClientAdapter searchMember(String string) {
        for (ClientAdapter clientAdapter : this.members) {
            if (!clientAdapter.info.userName.equals(string)) continue;
            return clientAdapter;
        }
        return null;
    }

    public UserInfo searchInfoOnServer(String string) {
        for (ClientAdapter clientAdapter : this.members) {
            if (!clientAdapter.info.userName.equals(string)) continue;
            return clientAdapter.info;
        }
        return null;
    }

    public void sendRoomInfo(ServerResponse serverResponse) {
        for (ClientAdapter clientAdapter : this.members) {
            clientAdapter.put(serverResponse);
        }
    }

    public void sendGoRecordQiZi() {
    }

    public boolean goIn(ClientAdapter clientAdapter) {
        for (ClientAdapter clientAdapter2 : this.members) {
            if (clientAdapter2.info == null || !clientAdapter2.info.userName.equals(clientAdapter.info.userName)) continue;
            this.members.remove(clientAdapter2);
            this.members.add(clientAdapter);
            return false;
        }
        this.members.add(clientAdapter);
        return true;
    }

    public void goIn(UserAllInfo userAllInfo) {
        this.userinfos.add(userAllInfo);
    }

    public boolean goOut(ClientAdapter clientAdapter) {
        for (ClientAdapter clientAdapter2 : this.members) {
            if (!clientAdapter2.getName().equals(clientAdapter.info.userName)) continue;
            this.members.remove(clientAdapter2);
            return true;
        }
        return false;
    }

    public void goOut(UserAllInfo userAllInfo) {
        for (UserAllInfo userAllInfo2 : this.userinfos) {
            if (!userAllInfo2.info.userName.equals(userAllInfo.info.userName)) continue;
            this.userinfos.remove(userAllInfo2);
            break;
        }
    }

    public void goOut(String string) {
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (!userAllInfo.info.userName.equals(string)) continue;
            this.userinfos.remove(userAllInfo);
            break;
        }
    }

    public boolean isMember(String string) {
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (!string.equals(userAllInfo.info.userName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstMember(String string) {
        int n = 0;
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (string.equals(userAllInfo.info.userName) && n == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String firstMemberName() {
        int n = 0;
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (n == 0) {
                return userAllInfo.info.userName;
            }
            ++n;
        }
        return "";
    }

    public UserAllInfo secondMember() {
        int n = 0;
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (n == 1) {
                return userAllInfo;
            }
            ++n;
        }
        return null;
    }

    public UserAllInfo getUser(String string) {
        for (UserAllInfo userAllInfo : this.userinfos) {
            if (!string.equals(userAllInfo.info.userName)) continue;
            return userAllInfo;
        }
        return null;
    }

    public boolean isMember(ClientAdapter clientAdapter) {
        for (ClientAdapter clientAdapter2 : this.members) {
            if (!clientAdapter.info.userName.equals(clientAdapter2.info.userName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.readHead(tyBaseInput);
    }

    public void readHead(TyBaseInput tyBaseInput) throws IOException {
        this.roomNumber = tyBaseInput.readInt();
        this.passwd = tyBaseInput.readUTF();
        this.title = tyBaseInput.readUTF();
        this.info = tyBaseInput.readUTF();
        this.status.setValue(tyBaseInput.readByte());
        int n = tyBaseInput.readInt();
        for (int i = 0; i < n; ++i) {
            UserAllInfo userAllInfo = new UserAllInfo();
            userAllInfo.info = new UserInfo();
            userAllInfo.info.read(tyBaseInput);
            userAllInfo.tmpInfo = new UserTmpInfo();
            userAllInfo.tmpInfo.read(tyBaseInput);
            this.userinfos.add(userAllInfo);
        }
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        this.writeHead(tyBaseOutput);
    }

    public void writeHead(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeInt(this.roomNumber);
        tyBaseOutput.writeUTF(this.passwd);
        tyBaseOutput.writeUTF(this.title);
        tyBaseOutput.writeUTF(this.info);
        tyBaseOutput.writeByte(this.status.getValue());
        tyBaseOutput.writeInt(this.members.size());
        for (ClientAdapter clientAdapter : this.members) {
            clientAdapter.info.write(tyBaseOutput);
            clientAdapter.tmpInfo.write(tyBaseOutput);
        }
    }
}

