/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.net.server.DataServerRequest;
import tianyuan.games.net.server.DataServerResponse;

class DataServerAdapter {
    private String dataServerIp = "";
    private int dataServerTcpPort = 1110;
    private NetSender sender = null;
    private NetListener listener = null;
    private TyBaseOutput dout = null;
    private Socket dataChannel = null;
    private TyBaseInput din;
    private LinkedBlockingQueue<DataServerRequest> inQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<DataServerResponse> outQueue = new LinkedBlockingQueue();

    DataServerAdapter(String string, int n) {
        this.dataServerIp = string;
        this.dataServerTcpPort = n;
        this.sender = new NetSender();
        this.listener = new NetListener();
        this.listener.setPriority(10);
        this.listener.start();
    }

    public DataServerResponse get() {
        return null;
    }

    public void put(DataServerRequest dataServerRequest) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.inQueue.put(dataServerRequest);
                return;
            }
            catch (InterruptedException interruptedException) {
                DataServerAdapter.sleepSec(1);
                continue;
            }
        }
    }

    private boolean processResponse(TyBaseInput tyBaseInput) {
        try {
            DataServerResponse dataServerResponse = new DataServerResponse();
            dataServerResponse.read(tyBaseInput);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void senderStart() {
        this.sender.start();
    }

    private static void sleepSec(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class NetSender
    extends Thread {
        private NetSender() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        DataServerRequest dataServerRequest;
                        if ((dataServerRequest = (DataServerRequest)DataServerAdapter.this.inQueue.take()) == null) {
                            DataServerAdapter.sleepSec(1);
                            continue;
                        }
                        dataServerRequest.write(DataServerAdapter.this.dout);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class NetListener
    extends Thread {
        private NetListener() {
        }

        @Override
        public void run() {
            try {
                DataServerAdapter.this.dataChannel = new Socket(DataServerAdapter.this.dataServerIp, DataServerAdapter.this.dataServerTcpPort);
                DataInputStream dataInputStream = new DataInputStream(DataServerAdapter.this.dataChannel.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(DataServerAdapter.this.dataChannel.getOutputStream());
                DataServerAdapter.this.din = new TyBaseInputStream(dataInputStream);
                DataServerAdapter.this.dout = new TyBaseOutputStream(dataOutputStream);
                DataServerAdapter.this.senderStart();
                while (DataServerAdapter.this.processResponse(DataServerAdapter.this.din)) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

