/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.net.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.base.TyBaseOutput;
import tianyuan.games.base.TyBaseOutputStream;
import tianyuan.games.net.client.P2pMessage;

public class P2pAdapter {
    public String userName;
    private InputThread ti;
    private OutputThread to;
    private TyBaseInput in;
    private TyBaseOutput out;
    private Socket sk = null;
    public LinkedBlockingQueue<P2pMessage> inputQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<P2pMessage> outputQueue = new LinkedBlockingQueue();
    private AtomicBoolean stopFlag = new AtomicBoolean(false);

    public P2pAdapter(Socket socket) {
        try {
            this.sk = socket;
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.in = new TyBaseInputStream(dataInputStream);
            this.out = new TyBaseOutputStream(dataOutputStream);
            this.ti = new InputThread();
            this.to = new OutputThread();
            this.ti.start();
            this.to.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public P2pAdapter(String string, int n) {
        CreateSocketThread createSocketThread = new CreateSocketThread();
        createSocketThread.ip = string;
        createSocketThread.port = n;
        createSocketThread.start();
    }

    public void closeAdapter() {
        this.stopFlag.set(true);
        try {
            this.outputQueue.put(new P2pMessage());
            this.sk.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reportClose() {
    }

    public void reportUserName() {
    }

    private class InputThread
    extends Thread {
        private InputThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    while (true) {
                        P2pMessage p2pMessage = new P2pMessage();
                        p2pMessage.read(P2pAdapter.this.in);
                        if (P2pAdapter.this.stopFlag.get()) break block2;
                        if (p2pMessage.type == 3) {
                            P2pAdapter.this.userName = p2pMessage.destUserName;
                            continue;
                        }
                        P2pAdapter.this.inputQueue.put(p2pMessage);
                    }
                }
                catch (Exception exception) {
                    if (!P2pAdapter.this.stopFlag.get()) continue;
                }
                break;
            }
        }
    }

    private class OutputThread
    extends Thread {
        private OutputThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    while (true) {
                        P2pMessage p2pMessage = P2pAdapter.this.outputQueue.take();
                        if (P2pAdapter.this.stopFlag.get()) break block2;
                        p2pMessage.write(P2pAdapter.this.out);
                    }
                }
                catch (Exception exception) {
                    if (!P2pAdapter.this.stopFlag.get()) continue;
                }
                break;
            }
            P2pAdapter.this.reportClose();
        }
    }

    private class CreateSocketThread
    extends Thread {
        String ip;
        int port;
        Socket s;

        private CreateSocketThread() {
        }

        @Override
        public void run() {
            try {
                this.s = new Socket(this.ip, this.port);
                DataInputStream dataInputStream = new DataInputStream(this.s.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(this.s.getOutputStream());
                P2pAdapter.this.in = new TyBaseInputStream(dataInputStream);
                P2pAdapter.this.out = new TyBaseOutputStream(dataOutputStream);
                P2pAdapter.this.ti = new InputThread();
                P2pAdapter.this.to = new OutputThread();
                P2pAdapter.this.ti.start();
                P2pAdapter.this.to.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

