/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.innermail;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tianyuan.games.base.innermail.InnerMail;
import tianyuan.games.base.innermail.InnerMailHead;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.innermail.InnerMailDownTabbedPane;
import tianyuan.games.gui.innermail.InnerMailReader;
import tianyuan.games.gui.innermail.InnerMailUpTabbedPane;

public class InnerMailMainPane
extends JPanel {
    protected InnerMailUpTabbedPane mailUpTabbedPane;
    protected InnerMailDownTabbedPane mailDownTabbedPane;
    private JSplitPane root;
    private RootSizeListener seeSize = new RootSizeListener();

    public InnerMailMainPane() {
        this.mailUpTabbedPane = new InnerMailUpTabbedPane();
        this.mailDownTabbedPane = new InnerMailDownTabbedPane();
        this.root = new JSplitPane(0, this.mailUpTabbedPane, this.mailDownTabbedPane);
        this.add((Component)this.root, "Center");
        this.root.setOneTouchExpandable(false);
        this.addComponentListener(new RootSizeListener());
    }

    public void reply(InnerMail innerMail) {
        this.mailDownTabbedPane.replyItem(innerMail);
    }

    public void closeInnerMailReader(InnerMailReader innerMailReader) {
        this.mailDownTabbedPane.remove(innerMailReader);
    }

    public void newMail(InnerMailHead innerMailHead) {
        this.mailUpTabbedPane.inBoxView.add(innerMailHead);
    }

    public void mailToAction(String string) {
        this.mailDownTabbedPane.mailToAction(string);
    }

    public void sendMail(InnerMailHead innerMailHead) {
        this.mailUpTabbedPane.outBoxView.add(innerMailHead);
    }

    public void delMail(byte by, int n) {
        if (by == InnerMail.READING_MAIL_BOX) {
            this.mailUpTabbedPane.inBoxView.del(n);
        } else if (by == InnerMail.SENDING_MAIL_BOX) {
            this.mailUpTabbedPane.outBoxView.del(n);
        }
    }

    public void getMail(byte by, InnerMail innerMail) {
        InnerMailReader innerMailReader = new InnerMailReader();
        innerMailReader.setItem(innerMail);
        if (by == InnerMail.READING_MAIL_BOX) {
            innerMailReader.setKey(Global.lang.getKey("251_inbox") + " : " + (innerMail.getNumber() + 1));
        } else if (by == InnerMail.SENDING_MAIL_BOX) {
            innerMailReader.setKey(Global.lang.getKey("251_outbox") + " : " + (innerMail.getNumber() + 1));
        }
        this.mailDownTabbedPane.addReader(innerMailReader);
    }

    public void receiverNotExist(InnerMail innerMail) {
        this.mailDownTabbedPane.innerMailSend.setItem(innerMail);
    }

    public void getIndex(byte by, int n, InnerMailHead[] innerMailHeadArray) {
        if (by == InnerMail.READING_MAIL_BOX) {
            this.mailUpTabbedPane.inBoxView.setPage(innerMailHeadArray, n);
        } else if (by == InnerMail.SENDING_MAIL_BOX) {
            this.mailUpTabbedPane.outBoxView.setPage(innerMailHeadArray, n);
        }
    }

    public void setAllSize() {
        Dimension dimension = this.getSize();
        InnerMailMainPane.limitSize(this.root, new Dimension(dimension.width - 1, dimension.height - 1));
        this.root.setDividerLocation(0.53);
        this.root.revalidate();
        this.validate();
        this.revalidate();
    }

    private static void limitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    private class RootSizeListener
    extends ComponentAdapter {
        private RootSizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            InnerMailMainPane.this.setAllSize();
        }
    }
}

