/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import tianyuan.games.base.GoRoom;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.EnterRoomPasswd;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;
import tianyuan.games.net.server.Room;

class TabbedRunGameListItem
extends JPanel {
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm = new MyTableModel();
    protected TableSorter sorter = new TableSorter(this.mtm);
    protected JPopupMenu popup = new JPopupMenu();
    protected SeeGameAction seeGameAction = new SeeGameAction();
    protected String[] columnNames = new String[]{Global.lang.getKey("104_passwd"), Global.lang.getKey("104_number"), Global.lang.getKey("104_status"), Global.lang.getKey("104_audience"), Global.lang.getKey("104_black"), Global.lang.getKey("104_white"), Global.lang.getKey("104_info"), Global.lang.getKey("104_title")};
    private SizeListener seeSize = new SizeListener();

    public TabbedRunGameListItem() {
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.popup.add(this.seeGameAction);
        this.table.addMouseListener(new PopupMenuMouseAdapter(this.popup, this.table));
        this.table.addMouseListener(new DoubleClickAdapter());
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
    }

    protected int getRowCount() {
        return this.table.getRowCount();
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new RunGameTableCellRenderer());
        }
    }

    protected int getSelectedRoomNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("104_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    public void enterRoom() {
        int n = this.getSelectedRoomNumber();
        if (Global.goRoomPanel.isMeInThisRoom(n)) {
            Global.goRootPane.selectGoeRoom(n);
            return;
        }
        GoRoom goRoom = Global.goRoomPanel.searchRoom(n);
        if (goRoom == null) {
            return;
        }
        if (goRoom.isLocked()) {
            EnterRoomPasswd enterRoomPasswd = new EnterRoomPasswd(Global.root, goRoom.passwd);
            if (enterRoomPasswd.okSelect) {
                Global.netDaemon.enterRoom(n);
            }
        } else {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.enterRoom(n);
        }
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        int n = this.table.getColumnCount();
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int[] nArray = new int[]{n2 / 20, n2 / 20, n2 / 20, n2 / 20, n2 / 10, n2 / 10, n2 / 10, n2 / 10};
        int[] nArray2 = new int[]{n2 / 10, n2 / 10, n2 / 10, n2 / 5, n2 / 5, n2 / 5, n2 / 5, n2 / 2};
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.columnNames[i]);
            tableColumn.setMinWidth(nArray[i]);
            tableColumn.setMaxWidth(nArray2[i]);
        }
        this.table.doLayout();
    }

    private String passwdDisp(Room room) {
        if (room.isLocked()) {
            return "***";
        }
        return "";
    }

    public void add(GoRoom goRoom) {
        this.addALine(goRoom, this.mtm);
    }

    public void del(int n) {
        this.delALine(n);
    }

    public void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    public void modify(GoRoom goRoom) {
        int n = this.searchRow(goRoom.roomNumber);
        if (n < 0) {
            return;
        }
        this.setValue(this.columnNames[0], this.passwdDisp(goRoom), n);
        this.setValue(this.columnNames[2], goRoom.status, n);
        this.setValue(this.columnNames[3], new Integer(goRoom.userinfos.size()), n);
        this.setValue(this.columnNames[4], goRoom.blackNameWithLevel(Global.lang), n);
        this.setValue(this.columnNames[5], goRoom.whiteNameWithLevel(Global.lang), n);
        this.setValue(this.columnNames[6], goRoom.info, n);
        this.setValue(this.columnNames[7], goRoom.title, n);
    }

    private void addALine(GoRoom goRoom, MyTableModel myTableModel) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.passwdDisp(goRoom));
        vector.add(new Integer(goRoom.roomNumber));
        vector.add(goRoom.status.toString());
        vector.add(new Integer(goRoom.userinfos.size()));
        vector.add(goRoom.blackNameWithLevel(Global.lang));
        vector.add(goRoom.whiteNameWithLevel(Global.lang));
        vector.add(goRoom.info);
        vector.add(goRoom.title);
        myTableModel.addRow(vector);
    }

    private void delALine(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("104_number").compareTo(this.sorter.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof Integer) || (Integer)object != n) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    private int searchRow(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("104_number").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof Integer) || (Integer)object != n) continue;
                return j;
            }
        }
        return -1;
    }

    private void setValue(String string, Object object, int n) {
        int n2 = -1;
        int n3 = this.mtm.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (string.compareTo(this.mtm.getColumnName(i)) != 0) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        this.mtm.setValueAt(object, n, n2);
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            TabbedRunGameListItem.this.setAllSize();
        }
    }

    class RunGameTableCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        RunGameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.isHostRecordRow(n)) {
                this.setForeground(HOST_FOREGROUND);
                this.setBackground(HOST_BACKGROUND);
            } else {
                this.setForeground(NORMAL_ITEM_FOREGROUND);
                this.setBackground(NORMAL_ITEM_BACKGROUND);
            }
            if (bl) {
                this.setForeground(SELECT_ITEM_FOREGROUND);
                this.setBackground(SELECT_ITEM_BACKGROUND);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            String string = (String)TabbedRunGameListItem.this.sorter.getValueAt(n, 4);
            String string2 = (String)TabbedRunGameListItem.this.sorter.getValueAt(n, 5);
            if (string.equals(Global.myNameWithGoLevel())) {
                return true;
            }
            return string2.equals(Global.myNameWithGoLevel());
        }
    }

    class SeeGameAction
    extends AbstractAction {
        SeeGameAction() {
            super(Global.lang.getKey("104_see_game"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TabbedRunGameListItem.this.enterRoom();
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                TabbedRunGameListItem.this.enterRoom();
            }
        }
    }
}

