/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import tianyuan.games.base.GoRoom;
import tianyuan.games.base.GoRoomInfo;
import tianyuan.games.base.GoRoomInfos;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.EnterRoomPasswd;
import tianyuan.games.gui.goe.table.ListRoot;

public class GoUserRoomList
extends ListRoot {
    protected String[] columnNames = new String[]{Global.lang.getKey("127_room_number"), Global.lang.getKey("127_status"), Global.lang.getKey("127_counter")};
    GoRoomInfos roomInfos = null;
    protected EnterRoomAction enterRoomAction = new EnterRoomAction();
    private SizeListener seeSize = new SizeListener();

    public GoUserRoomList() {
        super(Global.lang.getKey("127_title"));
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.addComponentListener(this.seeSize);
        this.popup.add(this.enterRoomAction);
        this.table.addMouseListener(new DoubleClickAdapter());
    }

    public void set(GoRoomInfos goRoomInfos) {
        this.roomInfos = goRoomInfos;
        for (GoRoomInfo goRoomInfo : goRoomInfos.getInfos()) {
            this.addALine(goRoomInfo);
        }
    }

    protected void addALine(GoRoomInfo goRoomInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(goRoomInfo.roomNumber);
        vector.add(goRoomInfo.status.toString());
        vector.add(goRoomInfo.counter);
        this.mtm.addRow(vector);
    }

    protected int getSelectedRoomNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("127_room_number").equals(this.mtm.getColumnName(i))) continue;
            Integer n3 = (Integer)this.mtm.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private void enterRoom() {
        int n = this.getSelectedRoomNumber();
        if (Global.goRoomPanel.isMeInThisRoom(n)) {
            Global.goRootPane.selectGoeRoom(n);
            return;
        }
        GoRoom goRoom = Global.goRoomPanel.searchRoom(n);
        if (goRoom == null) {
            return;
        }
        if (goRoom.isLocked()) {
            EnterRoomPasswd enterRoomPasswd = new EnterRoomPasswd(Global.root, goRoom.passwd);
            if (enterRoomPasswd.okSelect) {
                Global.netDaemon.enterRoom(n);
            }
        } else {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.enterRoom(n);
        }
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoUserRoomList.this.setAllSize();
        }
    }

    class EnterRoomAction
    extends AbstractAction {
        EnterRoomAction() {
            super(Global.lang.getKey("103_enter_room"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoUserRoomList.this.enterRoom();
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GoUserRoomList.this.enterRoom();
            }
        }
    }
}

