/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import tianyuan.games.base.GameReferenceIndex;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.table.MyTable;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.TableSorter;

public class GameReferenceTable
extends MyJPanel {
    protected MyTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm = new MyTableModel();
    protected TableSorter sorter = new TableSorter(this.mtm);
    protected String[] columnNames = new String[]{Global.lang.getKey("305_number"), Global.lang.getKey("305_start_step"), Global.lang.getKey("305_title"), Global.lang.getKey("305_length"), Global.lang.getKey("305_author"), Global.lang.getKey("305_time")};
    protected JPopupMenu popup = new JPopupMenu();
    protected SeeReferenceAction seeAction;
    private SizeListener seeSize = new SizeListener();

    public GameReferenceTable() {
        this.table = new MyTable(this.sorter);
        this.table.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new DoubleClickAdapter());
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
        this.setPopupMenu();
        this.sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.table.setModel(this.sorter);
        this.setColumnWidth();
    }

    public void add(Vector<GameReferenceIndex> vector) {
        for (GameReferenceIndex gameReferenceIndex : vector) {
            this.addALine(gameReferenceIndex);
        }
    }

    public void add(GameReferenceIndex gameReferenceIndex) {
        this.addALine(gameReferenceIndex);
    }

    private void addALine(GameReferenceIndex gameReferenceIndex) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(gameReferenceIndex.number);
        vector.add(gameReferenceIndex.startStep);
        vector.add(gameReferenceIndex.title);
        vector.add(gameReferenceIndex.length);
        vector.add(gameReferenceIndex.author);
        vector.add(gameReferenceIndex.publishTime);
        this.mtm.addRow(vector);
    }

    public void del(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("305_number").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (!(object instanceof Integer) || (Integer)object != n) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void setPopupMenu() {
        this.seeAction = new SeeReferenceAction();
        this.popup.add(this.seeAction);
    }

    private void sendGetReferenceCommand() {
        if (Global.netDaemon == null) {
            return;
        }
    }

    private int getSelectNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("305_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private void setAllSize() {
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[0]);
        tableColumn.setPreferredWidth(40);
        tableColumn = this.table.getColumn(this.columnNames[1]);
        tableColumn.setPreferredWidth(40);
        tableColumn = this.table.getColumn(this.columnNames[2]);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.columnNames[3]);
        tableColumn.setPreferredWidth(40);
        tableColumn = this.table.getColumn(this.columnNames[4]);
        tableColumn.setPreferredWidth(80);
        tableColumn = this.table.getColumn(this.columnNames[5]);
        tableColumn.setPreferredWidth(250);
        this.table.doLayout();
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }
    }

    class SeeReferenceAction
    extends AbstractAction {
        SeeReferenceAction() {
            super(Global.lang.getKey("129_see"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GameReferenceTable.this.sendGetReferenceCommand();
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GameReferenceTable.this.sendGetReferenceCommand();
            }
        }
    }
}

