/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.qipubbs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import tianyuan.games.base.GoQiPuInfo;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.dialog.MyJPanel;
import tianyuan.games.gui.goe.hall.PagePane;
import tianyuan.games.gui.goe.qipubbs.BbsMenuTreeNode;
import tianyuan.games.gui.goe.table.MyTableModel;
import tianyuan.games.gui.goe.table.PopupMenuMouseAdapter;
import tianyuan.games.gui.goe.table.StaticColor;
import tianyuan.games.gui.goe.table.TableSorter;

public class GoBbsQiPuListTable
extends MyJPanel {
    protected JTable table;
    protected JScrollPane sp;
    protected MyTableModel mtm;
    protected GoBbsTableSorter sorter;
    protected JLabel title = new JLabel("");
    protected BbsPager pagePane = new BbsPager();
    protected JButton quitButton = new JButton(Global.lang.getKey("220_quit"));
    protected Vector<GoQiPuInfo> qpInfos = new Vector();
    private BbsMenuTreeNode menuKey = null;
    protected String[] columnNames = new String[]{Global.lang.getKey("220_number"), Global.lang.getKey("220_title"), Global.lang.getKey("220_summary"), Global.lang.getKey("220_author"), Global.lang.getKey("220_play_price"), Global.lang.getKey("220_buy_price"), Global.lang.getKey("220_play_counter"), Global.lang.getKey("220_buy_counter"), Global.lang.getKey("220_difficult"), Global.lang.getKey("220_size"), Global.lang.getKey("220_create_time")};
    protected JPopupMenu popup = new JPopupMenu();
    protected DeleteAction deleteAction = null;
    protected ReadAction readAction = null;
    protected BuyAction buyAction = null;

    public void setMenuKey(BbsMenuTreeNode bbsMenuTreeNode) {
        this.menuKey = bbsMenuTreeNode;
    }

    public String getKey() {
        return this.title.getText();
    }

    private void removeMyselfFromContentPane() {
        Global.goQipuBbs.removeTopicView(this);
        if (this.menuKey != null) {
            this.menuKey.setTopicView(null);
        }
    }

    public GoBbsQiPuListTable(String string) {
        this.mtm = new MyTableModel();
        this.sorter = new GoBbsTableSorter(this.mtm);
        this.table = new JTable(this.sorter);
        this.table.setSelectionMode(0);
        this.table.setDragEnabled(true);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(true);
        this.setPopupMenu();
        this.table.addMouseListener(new DoubleClickAdapter());
        this.sp = new JScrollPane(this.table);
        this.mtm.setColumnIdentifiers(this.columnNames);
        this.table.setModel(this.sorter);
        this.setTableCellRenderer();
        this.title.setText(string);
        this.quitButton.addActionListener(new QuitListener());
    }

    public void setPage(GoQiPuInfo[] goQiPuInfoArray, int n) {
        this.delAll();
        this.pagePane.setNumber(n + 1);
        for (int i = 0; i < goQiPuInfoArray.length; ++i) {
            this.addALine(goQiPuInfoArray[i]);
        }
    }

    private int getSelectNumber() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        int n2 = this.sorter.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("220_number").equals(this.sorter.getColumnName(i))) continue;
            Integer n3 = (Integer)this.sorter.getValueAt(n, i);
            return n3;
        }
        return -1;
    }

    private void sendGetGoQiPuCommand(boolean bl, boolean bl2) {
        if (Global.netDaemon == null) {
            return;
        }
        if (bl && !bl2) {
            Global.netDaemon.bbsGetGoQiPuReadNoPay(this.getKey(), this.getSelectNumber() - 1);
        } else if (!bl && !bl2) {
            Global.netDaemon.bbsGetGoQiPuReadAndPay(this.getKey(), this.getSelectNumber() - 1);
        } else if (bl && bl2) {
            Global.netDaemon.bbsGetGoQiPuBuyNoPay(this.getKey(), this.getSelectNumber() - 1);
        } else {
            Global.netDaemon.bbsGetGoQiPuBuyAndPay(this.getKey(), this.getSelectNumber() - 1);
        }
    }

    private void sendDelGoQiPuCommand() {
        if (Global.netDaemon == null) {
            return;
        }
        Global.netDaemon.bbsDelGoQiPu(this.getKey(), this.getSelectNumber() - 1);
    }

    private void readOperation() {
        boolean bl = false;
        boolean bl2 = false;
        if (Global.isAdmin()) {
            bl = true;
            bl2 = true;
        } else {
            GoQiPuInfo goQiPuInfo = this.getSelectedGoQiPuInfo();
            if (goQiPuInfo == null) {
                return;
            }
            if (goQiPuInfo.author == null || goQiPuInfo.author.equals("")) {
                return;
            }
            if (goQiPuInfo.number <= 0) {
                return;
            }
            if (goQiPuInfo.author.equals(Global.myName())) {
                bl = true;
                bl2 = true;
            } else {
                bl = Global.myMoney() >= (long)goQiPuInfo.readPrice;
                Global.decMoney(goQiPuInfo.readPrice);
            }
        }
        if (bl) {
            this.sendGetGoQiPuCommand(bl2, false);
        }
    }

    private void deleteOperation() {
        this.sendDelGoQiPuCommand();
    }

    private void buyOperation() {
        boolean bl = false;
        boolean bl2 = false;
        if (Global.isAdmin()) {
            bl = true;
            bl2 = true;
        } else {
            GoQiPuInfo goQiPuInfo = this.getSelectedGoQiPuInfo();
            if (goQiPuInfo == null) {
                return;
            }
            if (goQiPuInfo.author == null || goQiPuInfo.author.equals("")) {
                return;
            }
            if (goQiPuInfo.number <= 0) {
                return;
            }
            if (goQiPuInfo.author.equals(Global.myName())) {
                bl = true;
                bl2 = true;
            } else {
                bl = Global.myMoney() >= (long)goQiPuInfo.buyPrice;
                Global.decMoney(goQiPuInfo.buyPrice);
            }
        }
        if (bl) {
            this.sendGetGoQiPuCommand(bl2, true);
        }
    }

    protected GoQiPuInfo getSelectedGoQiPuInfo() {
        GoQiPuInfo goQiPuInfo = new GoQiPuInfo();
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return goQiPuInfo;
        }
        int n2 = this.sorter.getColumnCount();
        goQiPuInfo.number = -1;
        goQiPuInfo.author = null;
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (Global.lang.getKey("220_number").equals(this.sorter.getColumnName(i))) {
                object = (Integer)this.sorter.getValueAt(n, i);
                goQiPuInfo.number = (Integer)object;
            }
            if (Global.lang.getKey("220_play_price").equals(this.sorter.getColumnName(i))) {
                object = (Byte)this.sorter.getValueAt(n, i);
                goQiPuInfo.readPrice = (Byte)object;
            }
            if (Global.lang.getKey("220_buy_price").equals(this.sorter.getColumnName(i))) {
                object = (Short)this.sorter.getValueAt(n, i);
                goQiPuInfo.buyPrice = (Short)object;
            }
            if (!Global.lang.getKey("220_author").equals(this.sorter.getColumnName(i))) continue;
            goQiPuInfo.author = object = (String)this.sorter.getValueAt(n, i);
        }
        return goQiPuInfo;
    }

    private void setActionEnabled(boolean bl, boolean bl2, boolean bl3) {
        this.deleteAction.setEnabled(bl);
        this.readAction.setEnabled(bl2);
        this.buyAction.setEnabled(bl3);
    }

    public void add(GoQiPuInfo goQiPuInfo) {
        this.addALine(goQiPuInfo);
    }

    public void clear() {
        this.delAll();
    }

    public void del(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (Global.lang.getKey("220_number").compareTo(this.mtm.getColumnName(i)) != 0) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Integer n3 = (Integer)this.mtm.getValueAt(j, i);
                if (n3 - 1 != n) continue;
                this.mtm.removeRow(j);
                return;
            }
        }
    }

    public void modify(GoQiPuInfo goQiPuInfo) {
        int n = this.searchRow(goQiPuInfo.number + 1);
        if (n < 0) {
            return;
        }
        this.setValue(this.columnNames[0], new Integer(goQiPuInfo.number + 1), n);
        this.setValue(this.columnNames[1], goQiPuInfo.title, n);
        this.setValue(this.columnNames[2], goQiPuInfo.explain, n);
        this.setValue(this.columnNames[3], goQiPuInfo.author, n);
        this.setValue(this.columnNames[4], goQiPuInfo.readPrice, n);
        this.setValue(this.columnNames[5], goQiPuInfo.buyPrice, n);
        this.setValue(this.columnNames[6], goQiPuInfo.readerCounter, n);
        this.setValue(this.columnNames[7], goQiPuInfo.buyCounter, n);
        this.setValue(this.columnNames[8], goQiPuInfo.difficultLevel, n);
        this.setValue(this.columnNames[9], goQiPuInfo.size, n);
        this.setValue(this.columnNames[10], this.toDateStr(goQiPuInfo.createTime), n);
    }

    protected void addALine(GoQiPuInfo goQiPuInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Integer(goQiPuInfo.number + 1));
        vector.add(goQiPuInfo.title);
        vector.add(goQiPuInfo.explain);
        vector.add(goQiPuInfo.author);
        vector.add(goQiPuInfo.readPrice);
        vector.add(goQiPuInfo.buyPrice);
        vector.add(goQiPuInfo.readerCounter);
        vector.add(goQiPuInfo.buyCounter);
        vector.add(goQiPuInfo.difficultLevel);
        vector.add(goQiPuInfo.size);
        vector.add(this.toDateStr(goQiPuInfo.createTime));
        this.mtm.addRow(vector);
    }

    private int searchRow(int n) {
        int n2 = this.mtm.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!Global.lang.getKey("220_number").equals(this.mtm.getColumnName(i))) continue;
            for (int j = 0; j < this.mtm.getRowCount(); ++j) {
                Object object = this.mtm.getValueAt(j, i);
                if (object == null || !(object instanceof Integer) || (Integer)object != n) continue;
                return j;
            }
        }
        return -1;
    }

    private void setValue(String string, Object object, int n) {
        int n2 = -1;
        int n3 = this.mtm.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (string.compareTo(this.mtm.getColumnName(i)) != 0) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        this.mtm.setValueAt(object, n, n2);
    }

    private String toDateStr(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3, Locale.getDefault());
        return dateFormat.format(date);
    }

    private void delAll() {
        int n = this.sorter.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.mtm.removeRow(0);
        }
    }

    @Override
    protected void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = dimension.width - n;
        int n3 = 25;
        this.myAddComp(this.title, 5, 3, n - 6, n3 - 6);
        this.myAddComp(this.pagePane, n + 1 - 60, 0, n2 - 1 - 60, n3);
        this.myAddComp(this.quitButton, n + 1 - 60 + n2 - 1 - 54, 2, 82, n3 - 2);
        this.myAddComp(this.sp, 0, n3 + 1, dimension.width, dimension.height - n3 - 1);
        this.setAllSize();
        this.revalidate();
    }

    private void setAllSize() {
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        TableColumn tableColumn = this.table.getColumn(this.columnNames[0]);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.table.getColumn(this.columnNames[1]);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.columnNames[2]);
        tableColumn.setPreferredWidth(350);
        tableColumn = this.table.getColumn(this.columnNames[10]);
        tableColumn.setPreferredWidth(230);
        this.table.doLayout();
    }

    private void setTableCellRenderer() {
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.table.getColumnName(i));
            tableColumn.setCellRenderer(new GoBbsCellRenderer());
        }
    }

    protected void setPopupMenu() {
        this.readAction = new ReadAction(this);
        this.buyAction = new BuyAction(this);
        this.deleteAction = new DeleteAction(this);
        this.popup.add(this.readAction);
        this.popup.add(this.buyAction);
        this.popup.add(this.deleteAction);
        this.table.addMouseListener(new PopupActionAdapter(this.popup, this.table));
    }

    class GoBbsCellRenderer
    extends DefaultTableCellRenderer
    implements StaticColor {
        GoBbsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isHostRecordRow(int n) {
            return false;
        }
    }

    class GoBbsTableSorter
    extends TableSorter {
        GoBbsTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isHostRecord(int n) {
            return false;
        }

        @Override
        public int compareRowsByColumn(int n, int n2, int n3) {
            TableModel tableModel = this.model;
            if (this.ascending) {
                if (this.isHostRecord(n)) {
                    return -1;
                }
                if (this.isHostRecord(n2)) {
                    return 1;
                }
            } else {
                if (this.isHostRecord(n)) {
                    return 1;
                }
                if (this.isHostRecord(n2)) {
                    return -1;
                }
            }
            return super.compareRowsByColumn(n, n2, n3);
        }
    }

    class BuyAction
    extends RootAction {
        BuyAction(GoBbsQiPuListTable goBbsQiPuListTable2) {
            super(Global.lang.getKey("220_buy"), goBbsQiPuListTable2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoBbsQiPuListTable.this.buyOperation();
        }
    }

    class ReadAction
    extends RootAction {
        ReadAction(GoBbsQiPuListTable goBbsQiPuListTable2) {
            super(Global.lang.getKey("220_read"), goBbsQiPuListTable2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoBbsQiPuListTable.this.readOperation();
        }
    }

    class DeleteAction
    extends RootAction {
        DeleteAction(GoBbsQiPuListTable goBbsQiPuListTable2) {
            super(Global.lang.getKey("220_delete"), goBbsQiPuListTable2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoBbsQiPuListTable.this.deleteOperation();
        }
    }

    class RootAction
    extends AbstractAction {
        GoBbsQiPuListTable father;

        RootAction(String string, GoBbsQiPuListTable goBbsQiPuListTable2) {
            super(string);
            this.father = goBbsQiPuListTable2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class BbsPager
    extends PagePane {
        BbsPager() {
        }

        @Override
        protected void doOperation(int n) {
            if (Global.netDaemon == null) {
                return;
            }
            Global.netDaemon.bbsGetQiPuIndexInTopic(GoBbsQiPuListTable.this.getKey(), n - 1);
        }
    }

    class PopupActionAdapter
    extends PopupMenuMouseAdapter {
        public PopupActionAdapter(JPopupMenu jPopupMenu, JComponent jComponent) {
            super(jPopupMenu, jComponent);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (Global.isAdmin()) {
                    GoBbsQiPuListTable.this.setActionEnabled(true, true, true);
                } else {
                    GoQiPuInfo goQiPuInfo = GoBbsQiPuListTable.this.getSelectedGoQiPuInfo();
                    if (goQiPuInfo == null) {
                        return;
                    }
                    if (goQiPuInfo.author == null || goQiPuInfo.author.equals("")) {
                        return;
                    }
                    if (goQiPuInfo.number <= 0) {
                        return;
                    }
                    if (goQiPuInfo.author.equals(Global.myName())) {
                        GoBbsQiPuListTable.this.setActionEnabled(true, true, true);
                    } else {
                        boolean bl = Global.myMoney() >= (long)goQiPuInfo.readPrice;
                        boolean bl2 = Global.myMoney() >= (long)goQiPuInfo.buyPrice;
                        GoBbsQiPuListTable.this.setActionEnabled(false, bl, bl2);
                    }
                }
                this.popup.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DoubleClickAdapter
    extends MouseAdapter {
        private DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                GoBbsQiPuListTable.this.readOperation();
            }
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoBbsQiPuListTable.this.removeMyselfFromContentPane();
        }
    }
}

