/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.hall;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.MyJButton;
import tianyuan.games.gui.MyJLabel;
import tianyuan.games.gui.goe.dialog.MyJPanel;

public class PagePane
extends MyJPanel {
    int currentNumber = 1;
    MyJButton next = new MyJButton(">");
    MyJButton prev = new MyJButton("<");
    MyJButton first = new MyJButton("|<");
    MyJButton last = new MyJButton(">|");
    MyJLabel page = new MyJLabel(Global.lang.getKey("131_page") + ":");
    JTextField pageNumber = new JTextField();

    public PagePane() {
        this.page.setHorizontalAlignment(4);
        this.myReLayout();
        this.next.addActionListener(new NextListener());
        this.prev.addActionListener(new PrevListener());
        this.last.addActionListener(new LastListener());
        this.first.addActionListener(new FirstListener());
        this.pageNumber.addActionListener(new PageNumberListener());
    }

    @Override
    public void myReLayout() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        Dimension dimension = this.getSize();
        int n = dimension.width / 6;
        int n2 = dimension.height;
        int n3 = dimension.width / 150;
        int n4 = dimension.height / 10;
        this.myAddComp(this.page, n3 * 3, n4, n, n2 - n4 * 2);
        this.myAddComp(this.pageNumber, n + n3 * 3, n4, n - n3 * 5, n2 - n4 * 2);
        this.myAddComp(this.first, n * 2 + n3, n4, n - n3 * 2, n2 - n4 * 2);
        this.myAddComp(this.prev, n * 3 + n3, n4, n - n3 * 2, n2 - n4 * 2);
        this.myAddComp(this.next, n * 4 + n3, n4, n - n3 * 2, n2 - n4 * 2);
        this.myAddComp(this.last, n * 5 + n3, n4, n - n3 * 2, n2 - n4 * 2);
        this.revalidate();
    }

    public void setNumber(int n) {
        this.currentNumber = n;
        this.pageNumber.setText(n + "");
    }

    protected void doOperation(int n) {
    }

    class PageNumberListener
    implements ActionListener {
        PageNumberListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PagePane.this.currentNumber = new Integer(PagePane.this.pageNumber.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            PagePane.this.pageNumber.setText(PagePane.this.currentNumber + "");
            PagePane.this.doOperation(PagePane.this.currentNumber);
        }
    }

    class LastListener
    implements ActionListener {
        LastListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PagePane.this.currentNumber = 100000;
            PagePane.this.pageNumber.setText(PagePane.this.currentNumber + "");
            PagePane.this.doOperation(PagePane.this.currentNumber);
        }
    }

    class FirstListener
    implements ActionListener {
        FirstListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PagePane.this.currentNumber = 1;
            PagePane.this.pageNumber.setText(PagePane.this.currentNumber + "");
            PagePane.this.doOperation(PagePane.this.currentNumber);
        }
    }

    class NextListener
    implements ActionListener {
        NextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ++PagePane.this.currentNumber;
            PagePane.this.pageNumber.setText(PagePane.this.currentNumber + "");
            PagePane.this.doOperation(PagePane.this.currentNumber);
        }
    }

    class PrevListener
    implements ActionListener {
        PrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            --PagePane.this.currentNumber;
            PagePane.this.pageNumber.setText(PagePane.this.currentNumber + "");
            PagePane.this.doOperation(PagePane.this.currentNumber);
        }
    }
}

