/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.goeroom.qp;

import java.util.Vector;
import tianyuan.games.gui.goe.goeroom.qp.AnalysisReport;
import tianyuan.games.gui.goe.goeroom.qp.DispQiPan;
import tianyuan.games.gui.goe.goeroom.qp.InfectionQiPan;
import tianyuan.games.gui.goe.goeroom.qp.QiPanPosition;
import tianyuan.games.gui.goe.goeroom.qp.QiZi;
import tianyuan.games.gui.goe.goeroom.qp.QiZiGroup2;

public class AnalysisQiPan {
    private DispQiPan dqp;
    private int blackTieMu = 0;
    private Vector<QiZiGroup2> blackStrings = new Vector();
    private Vector<QiZiGroup2> whiteStrings = new Vector();
    private Vector<QiZiGroup2> emptyAreas = new Vector();
    private InfectionQiPan ifqp;
    static final int[] INFECTION_GENE = new int[]{64, 32, 16, 8, 4, 2, 1};

    public AnalysisQiPan(DispQiPan dispQiPan) {
        this.dqp = dispQiPan;
        this.construct();
    }

    public AnalysisQiPan(DispQiPan dispQiPan, int n) {
        this.dqp = dispQiPan;
        this.blackTieMu = n;
        this.construct();
    }

    public AnalysisReport getAnalysisReport() {
        AnalysisReport analysisReport = new AnalysisReport();
        analysisReport.blackArea = this.getBlackArea();
        analysisReport.whiteArea = this.getWhiteArea();
        analysisReport.blackPotential = this.getBlackPotential();
        analysisReport.whitePotential = this.getWhitePotential();
        return analysisReport;
    }

    public void setMouseClick(QiPanPosition qiPanPosition) {
        for (QiZiGroup2 qiZiGroup2 : this.blackStrings) {
            if (!qiZiGroup2.isPositionOnThisGroup(qiPanPosition)) continue;
            qiZiGroup2.turnDeadFlag(this.dqp);
            break;
        }
        for (QiZiGroup2 qiZiGroup2 : this.whiteStrings) {
            if (!qiZiGroup2.isPositionOnThisGroup(qiPanPosition)) continue;
            qiZiGroup2.turnDeadFlag(this.dqp);
            break;
        }
        this.ifqp = new InfectionQiPan(this.dqp);
        this.ifqp.computeInfection();
        this.computeBlock();
    }

    public InfectionQiPan getInfectionQiPan() {
        return this.ifqp;
    }

    private void construct() {
        Vector<QiZi> vector = this.dqp.getAllQiZi();
        for (QiZi qiZi : vector) {
            if (qiZi.getColor() == 1) {
                this.add(qiZi, this.blackStrings);
                continue;
            }
            if (qiZi.getColor() == 2) {
                this.add(qiZi, this.whiteStrings);
                continue;
            }
            if (qiZi.getColor() != 0) continue;
            this.add(qiZi, this.emptyAreas);
        }
        this.ifqp = new InfectionQiPan(this.dqp);
        this.ifqp.computeInfection();
        this.computeBlock();
    }

    public int getBlackArea() {
        return this.ifqp.getBlackArea() * 200 - this.blackTieMu;
    }

    public int getWhiteArea() {
        return this.ifqp.getWhiteArea() * 200 + this.blackTieMu;
    }

    public int getBlackPotential() {
        return this.ifqp.getBlackPotential();
    }

    public int getWhitePotential() {
        return this.ifqp.getWhitePotential();
    }

    private void computeBlock() {
        this.ifqp.computeBlock();
    }

    private void add(QiZi qiZi, Vector<QiZiGroup2> vector) {
        Vector<QiZiGroup2> vector2 = new Vector<QiZiGroup2>();
        QiZiGroup2 qiZiGroup2 = new QiZiGroup2();
        qiZiGroup2.add(qiZi);
        for (QiZiGroup2 qiZiGroup22 : vector) {
            if (!qiZiGroup22.adjacent(qiZi)) continue;
            vector2.add(qiZiGroup22);
        }
        for (QiZiGroup2 qiZiGroup22 : vector2) {
            vector.remove(qiZiGroup22);
            qiZiGroup2.add(qiZiGroup22);
        }
        vector.add(qiZiGroup2);
    }
}

