/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import tianyuan.games.gui.LanguagePropertySet;
import tianyuan.games.gui.goe.dialog.TimeLimitShowInfoDialog;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.GoEditorListener;

public class LocalGoEditorMain
extends JFrame
implements GoEditorListener {
    private HelpAction helpAction = null;
    private MailToAction mailToAction = null;
    private HomePageAction homePageAction = null;
    private ContentAction contentAction = null;
    private LanguagePropertySet langCn = null;
    private LanguagePropertySet langFtCn = null;
    private LanguagePropertySet langEn = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    GoEditor editor;

    public static void main(String[] stringArray) {
        GoEditor.init(null);
        LocalGoEditorMain localGoEditorMain = new LocalGoEditorMain();
        localGoEditorMain.createAll();
    }

    public LocalGoEditorMain() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LocalGoEditorMain.this.editor.quit();
            }
        });
        this.setDefaultCloseOperation(0);
        JMenuBar jMenuBar = this.createMenuBar();
        this.setJMenuBar(jMenuBar);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Image image = toolkit.getImage(System.getProperty("user.dir") + System.getProperty("file.separator") + "./resource/ico/1_black_white2.png");
        if (image != null) {
            this.setIconImage(image);
        }
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = dimension.width / 10;
        int n4 = dimension.height / 10;
        this.setLocation(n3, n4);
        int n5 = dimension.width / 4 * 3;
        int n6 = dimension.height / 4 * 3;
        this.setSize(n5, n6);
        this.setExtendedState(6);
    }

    JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(GoEditor.lang.getKey("1_language_type"), true);
        this.langCn = new LanguagePropertySet("1_language_cn", "lang.cn", GoEditor.lang, GoEditor.paramterLang);
        jMenu.add(this.langCn);
        this.langFtCn = new LanguagePropertySet("1_language_ftcn", "lang.ftcn", GoEditor.lang, GoEditor.paramterLang);
        jMenu.add(this.langFtCn);
        this.langEn = new LanguagePropertySet("1_language_en", "lang.en", GoEditor.lang, GoEditor.paramterLang);
        jMenu.add(this.langEn);
        this.buttonGroup.add(this.langCn);
        this.buttonGroup.add(this.langFtCn);
        this.buttonGroup.add(this.langEn);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(GoEditor.lang.getKey("7_menu_help"), true);
        this.helpAction = new HelpAction();
        jMenu2.add(this.helpAction);
        this.mailToAction = new MailToAction();
        jMenu2.add(this.mailToAction);
        this.contentAction = new ContentAction();
        this.homePageAction = new HomePageAction();
        jMenu2.add(this.homePageAction);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    public void createAll() {
        this.editor = new GoEditor(this);
        this.getContentPane().add(this.editor);
        this.setVisible(true);
    }

    @Override
    public void setGoEditorTitle(String string) {
        this.setTitle(string);
    }

    @Override
    public String getGoEditorTitle() {
        return this.getTitle();
    }

    class ContentAction
    extends AbstractAction {
        ContentAction() {
            super(GoEditor.lang.getKey("7_menu_content"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class HomePageAction
    extends AbstractAction {
        HomePageAction() {
            super(GoEditor.lang.getKey("7_menu_page"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI("http://www.tpweiqi.com"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class MailToAction
    extends AbstractAction {
        MailToAction() {
            super(GoEditor.lang.getKey("7_menu_mailto"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                try {
                    desktop.mail(new URI("mailto:busyper@gmail.com"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            super(GoEditor.lang.getKey("7_menu_about"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            if (GoEditor.lang.getKey("1_language").equals("Chinese")) {
                string = "tpweiqi go editor v1.0 \n\u4f5c\u8005: busyper \n\u90ae\u7bb1: busyper@gmail.com \n           busyper@126.com \n\u4e3b\u9875: http://www.tpweiqi.com \n";
            } else if (GoEditor.lang.getKey("1_language").equals("English")) {
                string = "tpweiqi editor v1.0 \nAuthor: busyper \nE_mail: busyper@gmail.com \n                busyper@126.com \nHome page: http://www.tpweiqi.com \n";
            }
            TimeLimitShowInfoDialog timeLimitShowInfoDialog = new TimeLimitShowInfoDialog(string, 30);
            timeLimitShowInfoDialog.doShow();
        }
    }
}

