/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import tianyuan.games.base.GoQiPu;
import tianyuan.games.base.TyBaseInputStream;
import tianyuan.games.gui.Global;
import tianyuan.games.gui.goe.editor.GoBrower;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.MyGoFileFilter;
import tianyuan.games.gui.goe.editor.maptree.QiPu;

public class GoUpLoader
extends JPanel {
    private GoBrower board;
    private UpLoadCommandPane commandPane;
    private SizeListener seeSize = new SizeListener();

    public GoUpLoader() {
        this.createComp();
        this.layoutComp();
        this.addComponentListener(this.seeSize);
        this.setAllSize();
    }

    public void myReset() {
        this.board.clear();
        this.commandPane.myReset();
    }

    private void createComp() {
        GoEditor.init(null);
        GoEditor.lang = Global.lang;
        GoEditor.paramter = Global.paramter;
        this.board = new GoBrower();
        this.commandPane = new UpLoadCommandPane();
    }

    private void layoutComp() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.commandPane);
    }

    void setAllSize() {
        Dimension dimension = this.getSize();
        GoUpLoader.limitSize(this.board, new Dimension(dimension.height * 16 / 10, dimension.height));
        GoUpLoader.limitSize(this.commandPane, new Dimension(dimension.width - dimension.height * 16 / 10, dimension.height));
        this.revalidate();
    }

    private static void limitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    class UpLoadCommandPane
    extends JPanel {
        JLabel filename;
        JTextField filenameInput;
        JButton open;
        JButton submit;
        JProgressBar processBar;
        JLabel difficult;
        JComboBox difficultInput;
        JLabel readPrice;
        JComboBox readPriceInput;
        JLabel buyPrice;
        JComboBox buyPriceInput;
        JLabel title;
        JTextField titleInput;
        JLabel summary;
        JTextField summaryInput;
        int summaryInputReadInLength = 0;
        IsFreeSet isFree;
        private String currentDir = "";

        public UpLoadCommandPane() {
            this.createComp();
            this.addListener();
            this.myReLayout();
        }

        public void myReset() {
            this.filenameInput.setText("");
            this.titleInput.setText("");
            this.summaryInput.setText("");
        }

        private void createComp() {
            int n;
            this.filename = new JLabel(Global.lang.getKey("221_filename"));
            this.filenameInput = new JTextField("");
            this.filenameInput.setEditable(false);
            this.open = new JButton(Global.lang.getKey("221_select"));
            this.processBar = new JProgressBar(0, 100);
            this.submit = new JButton(Global.lang.getKey("221_upload"));
            this.difficult = new JLabel(Global.lang.getKey("221_difficult"));
            this.difficultInput = new JComboBox();
            this.difficultInput.setEditable(false);
            for (n = 1; n <= 10; ++n) {
                this.difficultInput.addItem(new Integer(n));
            }
            this.readPrice = new JLabel(Global.lang.getKey("221_read_price"));
            this.readPriceInput = new JComboBox();
            this.readPriceInput.setEditable(false);
            for (n = 1; n <= 10; ++n) {
                this.readPriceInput.addItem(new Integer(n));
            }
            this.buyPrice = new JLabel(Global.lang.getKey("221_buy_price"));
            this.buyPriceInput = new JComboBox();
            this.buyPriceInput.setEditable(false);
            for (n = 10; n <= 100; n += 10) {
                this.buyPriceInput.addItem(new Integer(n));
            }
            this.title = new JLabel(Global.lang.getKey("221_title"));
            this.titleInput = new JTextField("");
            this.summary = new JLabel(Global.lang.getKey("221_summary"));
            this.summaryInput = new JTextField("");
            this.isFree = new IsFreeSet(Global.lang.getKey("221_free"));
            this.filename.setHorizontalAlignment(4);
            this.readPrice.setHorizontalAlignment(4);
            this.buyPrice.setHorizontalAlignment(4);
            this.summary.setHorizontalAlignment(4);
            this.title.setHorizontalAlignment(4);
            this.difficult.setHorizontalAlignment(4);
        }

        protected void myAddComp(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            Spring spring = Spring.constant(n);
            Spring spring2 = Spring.constant(n2);
            Spring spring3 = Spring.constant(n3);
            Spring spring4 = Spring.constant(n4);
            this.add((Component)jComponent, new SpringLayout.Constraints(spring, spring2, spring3, spring4));
        }

        protected void addListener() {
            this.open.addActionListener(new OpenListener());
            this.submit.addActionListener(new SubmitListener());
        }

        protected void myReLayout() {
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            int n = 22;
            int n2 = 65;
            int n3 = 90;
            Dimension dimension = this.getSize();
            int n4 = dimension.height;
            int n5 = dimension.width;
            int n6 = n4 / 12;
            int n7 = n4 / 40;
            int n8 = n5 / 20;
            int n9 = n5 / 20;
            n4 = n4 - n6 - n7;
            n5 = n5 - n8 - n9;
            int n10 = 6;
            int n11 = 20;
            int n12 = n4 / n10;
            int n13 = n5 / n11;
            int n14 = n5 / 50;
            int n15 = (n4 - n * n11) / (n11 * 2);
            this.myAddComp(this.filename, n8 + n14, n6 + n15, n3, n);
            this.myAddComp(this.filenameInput, n8 + n14 + n3, n6 + n15, n13 * 7 + n2 + 5, n);
            this.myAddComp(this.open, n8 + n14 + n3 + n13 * 7 + n2 + 12, n6 + n15, n2, n);
            this.myAddComp(this.title, n8 + n14, n6 + n15 + n12, n3, n);
            this.myAddComp(this.titleInput, n8 + n14 + n3, n6 + n15 + n12, n8 + n14 + n3 + n13 * 7 + n2 + 12 + n2 - (n8 + n14 + n3), n);
            this.myAddComp(this.summary, n8 + n14, n6 + n15 + n12 * 2, n3, n);
            this.myAddComp(this.summaryInput, n8 + n14 + n3, n6 + n15 + n12 * 2, n8 + n14 + n3 + n13 * 7 + n2 + 12 + n2 - (n8 + n14 + n3), n);
            this.myAddComp(this.isFree, n8 + n14, n6 + n15 + n12 * 3, n3, n);
            this.myAddComp(this.difficult, n8 + n14 + n3 + 5, n6 + n15 + n12 * 3, n3, n);
            this.myAddComp(this.difficultInput, n8 + n14 + n3 * 2 + 10, n6 + n15 + n12 * 3, n3 / 2, n);
            this.myAddComp(this.readPrice, n8 + n14, n6 + n15 + n12 * 4, n3, n);
            this.myAddComp(this.readPriceInput, n8 + n14 + n3 + 5, n6 + n15 + n12 * 4, n3 / 2, n);
            this.myAddComp(this.buyPrice, n8 + n14 + n3 * 2 + 10, n6 + n15 + n12 * 4, n3, n);
            this.myAddComp(this.buyPriceInput, n8 + n14 + n3 * 3 + 20, n6 + n15 + n12 * 4, n3 / 2, n);
            this.myAddComp(this.submit, n8 + n14 + n8 + n14 + n3 + n13 * 7 + n2 + 12 + n2 - (n8 + n14 + n3) + 5, n6 + n15 + n12 * 5, n2 + 25, n);
            this.revalidate();
        }

        void readInSgfFile() {
            File file = new File(this.filenameInput.getText());
            try {
                if (file == null) {
                    return;
                }
                QiPu qiPu = new QiPu(file);
                GoUpLoader.this.board.setQiPu(qiPu);
                GoUpLoader.this.board.selectEnd();
                this.currentDir = file.getPath();
                this.currentDir = file.getParent();
                GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                GoEditor.paramter.writeOut();
                this.titleInput.setText(qiPu.getTitle());
                this.summaryInput.setText(qiPu.getExplain());
                this.summaryInputReadInLength = this.summaryInput.getText().length();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
            }
        }

        void readInFile() {
            File file = new File(this.filenameInput.getText());
            try {
                if (file == null) {
                    return;
                }
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                TyBaseInputStream tyBaseInputStream = new TyBaseInputStream(dataInputStream);
                QiPu qiPu = new QiPu();
                qiPu.read(tyBaseInputStream);
                GoUpLoader.this.board.setQiPu(qiPu);
                GoUpLoader.this.board.selectEnd();
                this.currentDir = file.getPath();
                this.currentDir = file.getParent();
                GoEditor.paramter.setKey("22_current_dir", this.currentDir);
                GoEditor.paramter.writeOut();
                tyBaseInputStream.close();
                this.titleInput.setText(qiPu.getTitle());
                this.summaryInput.setText(qiPu.getExplain());
                this.summaryInputReadInLength = this.summaryInput.getText().length();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, file.getName() + ":" + GoEditor.lang.getKey("214_file_open_error"));
            }
        }

        boolean openFile() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new MyGoFileFilter());
            this.currentDir = GoEditor.paramter.getString("22_current_dir");
            if (this.currentDir != null && !this.currentDir.equals("")) {
                try {
                    File file = new File(this.currentDir);
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            if (file != null && n == 0) {
                this.filenameInput.setText(file.toString());
                return true;
            }
            return false;
        }

        void sendFile() {
            GoQiPu goQiPu = new GoQiPu();
            goQiPu.qp = GoUpLoader.this.board.getQiPu();
            if (goQiPu.qp.getQiPuSize() <= 1) {
                return;
            }
            goQiPu.qp.setTitle(this.titleInput.getText());
            String string = this.summaryInput.getText();
            if (string.length() != this.summaryInputReadInLength) {
                goQiPu.qp.setExplain(string);
            }
            Integer n = (Integer)this.buyPriceInput.getSelectedItem();
            Integer n2 = (Integer)this.readPriceInput.getSelectedItem();
            Integer n3 = (Integer)this.difficultInput.getSelectedItem();
            goQiPu.difficult = n3.byteValue();
            goQiPu.buyPrice = n.shortValue();
            goQiPu.readPrice = n2.byteValue();
            goQiPu.isFree = this.isFree.isSelected();
            if (goQiPu.isFree) {
                goQiPu.readPrice = 0;
                goQiPu.buyPrice = 0;
            }
            Global.netDaemon.bbsAddGoQiPu(Global.goQipuBbs.getCurrentTopic(), goQiPu);
        }

        void priceCompEnabled(boolean bl) {
            this.readPriceInput.setEnabled(bl);
            this.buyPriceInput.setEnabled(bl);
        }

        class IsFreeSet
        extends JCheckBox
        implements ItemListener {
            public IsFreeSet(String string) {
                super(string, false);
                this.addItemListener(this);
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.isSelected()) {
                    UpLoadCommandPane.this.priceCompEnabled(false);
                } else {
                    UpLoadCommandPane.this.priceCompEnabled(true);
                }
            }
        }

        class SubmitListener
        implements ActionListener {
            SubmitListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpLoadCommandPane.this.sendFile();
            }
        }

        class OpenListener
        implements ActionListener {
            OpenListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UpLoadCommandPane.this.openFile()) {
                    String string = UpLoadCommandPane.this.filenameInput.getText();
                    if (string.endsWith("twq") || string.endsWith("TWQ")) {
                        UpLoadCommandPane.this.readInFile();
                    } else if (string.endsWith("sgf") || string.endsWith("SGF")) {
                        UpLoadCommandPane.this.readInSgfFile();
                    }
                }
            }
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoUpLoader.this.commandPane.myReLayout();
            GoUpLoader.this.setAllSize();
        }
    }
}

