/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.gui.goe.editor;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import tianyuan.games.gui.goe.editor.GoEditor;
import tianyuan.games.gui.goe.editor.GoEditorBoard;
import tianyuan.games.gui.goe.editor.GoEditorCommandPane;
import tianyuan.games.gui.goe.editor.GoEditorMap;
import tianyuan.games.gui.goe.editor.GoEditorTextInfo;
import tianyuan.games.gui.goe.editor.GoNetEditorCommandPane;
import tianyuan.games.gui.goe.editor.GoReaderCommandPane;
import tianyuan.games.gui.goe.editor.maptree.QiPu;
import tianyuan.games.gui.goe.goeroom.qp.AnalysisReportDisplay;

public class GoEditorMainPane
extends JPanel
implements TreeSelectionListener {
    public GoEditorMap treeMap;
    public GoEditorBoard board;
    GoEditorTextInfo textInfo;
    GoEditorCommandPane commandPane;
    GoReaderCommandPane readerCommandPane;
    GoNetEditorCommandPane netEditorCommandPane;
    AnalysisReportDisplay analysisReportDisplay;
    private TreePath beSelectedPath;
    private JSplitPane right;
    protected JPanel rightPane = new JPanel();
    private SizeListener seeSize = new SizeListener();

    public void enterAnalysisMode() {
        this.treeMap.setCanUsed(false);
        this.analysisReportDisplay = new AnalysisReportDisplay();
        this.analysisReportDisplay.setLang(GoEditor.lang);
        this.board.enterAnalysisMode(this.analysisReportDisplay);
        this.analysisReportDisplay.setReport(this.board.getAnalysisQiPan().getAnalysisReport());
        this.textInfo.add(GoEditor.lang.getKey("120_analyze"), this.analysisReportDisplay);
        this.textInfo.setSelectedComponent(this.analysisReportDisplay);
    }

    public void quitAnalysisMode() {
        this.treeMap.setCanUsed(true);
        this.board.quitAnalysisMode();
        this.textInfo.removeAnalysisReportDisplay(this.analysisReportDisplay);
    }

    public void enterTestMode() {
        this.board.enterTestModeForReader();
    }

    public void quitTestMode() {
        this.board.quitTestModeForReader();
    }

    public QiPu getQiPu() {
        return new QiPu(this.treeMap.getTreeModel());
    }

    public void setQiPu(QiPu qiPu) {
        this.treeMap.setTreeModel(qiPu.getTreeModel());
    }

    public void selectEnd() {
        this.treeMap.selectEnd();
    }

    public void clear() {
        this.treeMap.clear();
        this.textInfo.clear();
    }

    GoEditorMainPane(GoEditor goEditor, String string) {
        this.treeMap = new GoEditorMap(goEditor, this);
        this.treeMap.setEditable(false);
        this.board = new GoEditorBoard(goEditor);
        this.netEditorCommandPane = new GoNetEditorCommandPane(goEditor, this.board);
        this.textInfo = new GoEditorTextInfo(goEditor);
        this.addComponentListener(this.seeSize);
        this.right = new JSplitPane(0, this.textInfo, this.treeMap);
        this.right.setOneTouchExpandable(true);
        this.right.addComponentListener(new RightSizeListener());
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.rightPane.add(this.netEditorCommandPane);
        this.rightPane.add(this.right);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
        this.board.setSound(true);
    }

    GoEditorMainPane(GoEditor goEditor, int n) {
        this.treeMap = new GoEditorMap(goEditor, this);
        this.treeMap.setEditable(false);
        this.board = new GoEditorBoard(goEditor);
        this.readerCommandPane = new GoReaderCommandPane(goEditor, this.board);
        this.textInfo = new GoEditorTextInfo(goEditor);
        this.addComponentListener(this.seeSize);
        this.right = new JSplitPane(0, this.textInfo, this.treeMap);
        this.right.setOneTouchExpandable(true);
        this.right.addComponentListener(new RightSizeListener());
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.rightPane.add(this.readerCommandPane);
        this.rightPane.add(this.right);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
        this.board.setSound(true);
    }

    GoEditorMainPane(GoEditor goEditor, boolean bl) {
        this.treeMap = new GoEditorMap(goEditor, this);
        this.treeMap.setEditable(false);
        this.board = new GoEditorBoard(goEditor);
        this.board.setSound(false);
        this.board.setAllFlag(false, false, false, true, false, false, false, false);
        this.textInfo = new GoEditorTextInfo(goEditor);
        this.textInfo.setEditable(false);
        this.addComponentListener(this.seeSize);
        this.right = new JSplitPane(0, this.textInfo, this.treeMap);
        this.right.setOneTouchExpandable(true);
        this.right.addComponentListener(new RightSizeListener());
        this.commandPane = new GoEditorCommandPane(goEditor, this.board);
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        if (!bl) {
            this.rightPane.add(this.commandPane);
        }
        this.rightPane.add(this.right);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
    }

    GoEditorMainPane(GoEditor goEditor) {
        this.treeMap = new GoEditorMap(goEditor, this);
        this.board = new GoEditorBoard(goEditor);
        this.textInfo = new GoEditorTextInfo(goEditor);
        this.addComponentListener(this.seeSize);
        this.right = new JSplitPane(0, this.textInfo, this.treeMap);
        this.right.setOneTouchExpandable(true);
        this.right.addComponentListener(new RightSizeListener());
        this.commandPane = new GoEditorCommandPane(goEditor, this.board);
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.rightPane.add(this.commandPane);
        this.rightPane.add(this.right);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.board);
        this.add(this.rightPane);
        this.setAllSize();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        String string = this.treeMap.valueChanged(treeSelectionEvent, this.textInfo.getExplain());
        if (string != null || string.length() > 0) {
            this.textInfo.setExplain(string);
        }
        TreePath treePath = treeSelectionEvent.getPath();
        boolean bl = true;
        if (treePath != null && this.beSelectedPath != null) {
            if (treePath.equals(this.beSelectedPath)) {
                bl = false;
            }
        } else if (treePath == null) {
            bl = false;
        }
        if (bl && treePath.getPathCount() > 0) {
            this.board.setPath(treePath, this.treeMap.getTreeModel());
        }
        this.beSelectedPath = treePath;
    }

    void setAllSize() {
        Dimension dimension = this.getSize();
        GoEditorMainPane.limitSize(this.board, new Dimension(dimension.height - 1, dimension.height - 1));
        GoEditorMainPane.limitSize(this.rightPane, new Dimension(dimension.width - dimension.height + 1, dimension.height));
        if (this.readerCommandPane != null) {
            GoEditorMainPane.limitSize(this.right, new Dimension(dimension.width - dimension.height, dimension.height * 9 / 10 - 2));
        } else if (this.netEditorCommandPane != null) {
            GoEditorMainPane.limitSize(this.right, new Dimension(dimension.width - dimension.height, dimension.height * 9 / 10 - 2));
        } else {
            GoEditorMainPane.limitSize(this.right, new Dimension(dimension.width - dimension.height, dimension.height * 4 / 5 - 1));
        }
        this.right.setDividerLocation(0.4);
        this.validate();
        this.revalidate();
    }

    private void setRightSize() {
        this.right.setDividerLocation(0.4);
        this.right.revalidate();
    }

    private static void limitSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
    }

    private class RightSizeListener
    extends ComponentAdapter {
        private RightSizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoEditorMainPane.this.setRightSize();
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GoEditorMainPane.this.setAllSize();
        }
    }
}

