/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class Level
extends Root {
    private int value;
    private int levelDetail = 0;

    public Level() {
        this.value = 1;
    }

    public Level(int n) {
        this.value = n;
        if (this.value > 9) {
            this.value = 9;
        } else if (this.value < -30) {
            this.value = -30;
        } else if (this.value == 0) {
            this.value = 1;
        }
    }

    public int value() {
        return this.value;
    }

    public int getDetail() {
        return this.levelDetail;
    }

    public void setDetail(int n) {
        this.levelDetail = n;
    }

    public String toString() {
        if (this.value > 0) {
            return this.value + "d";
        }
        if (this.value < 0) {
            return -this.value + "j";
        }
        return " ";
    }

    public String toString(MyProperties myProperties) {
        if (this.value > 0) {
            return this.value + myProperties.getKey("122_duan");
        }
        if (this.value < 0) {
            return -this.value + myProperties.getKey("122_ji");
        }
        return " ";
    }

    public void add() {
        this.value = this.value >= 9 ? 9 : (this.value == -1 ? 1 : ++this.value);
    }

    public void dec() {
        this.value = this.value <= -30 ? -30 : (this.value == 1 ? -1 : --this.value);
    }

    public int compare(Level level) {
        if (Math.abs(this.value - level.value()) < 2) {
            return 0;
        }
        if (Math.abs(this.value - level.value()) == 2 && Math.abs(this.value) == Math.abs(level.value())) {
            return 0;
        }
        if (this.value > level.value()) {
            return 1;
        }
        return -1;
    }

    public int compare2(Level level) {
        if (this.value > 0 && level.value() < 0) {
            return this.value - (level.value() + 1);
        }
        if (this.value < 0 && level.value() > 0) {
            return this.value - (level.value() - 1);
        }
        return this.value - level.value();
    }

    public static Level change(String string) {
        if (string.endsWith("d") || string.endsWith("j")) {
            try {
                Integer n = new Integer(string.substring(0, string.length() - 2));
                return new Level(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.value = tyBaseInput.readByte();
        this.levelDetail = tyBaseInput.readShort();
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeByte(this.value);
        tyBaseOutput.writeShort((short)this.levelDetail);
    }

    class LevelValueAndLevelDetailBase {
        int levelValue;
        int levelDetailBase;

        LevelValueAndLevelDetailBase() {
        }
    }
}

