/*
 * Decompiled with CFR 0.152.
 */
package tianyuan.games.base;

import java.io.IOException;
import org.phoenix.util.MyProperties;
import tianyuan.games.base.Root;
import tianyuan.games.base.TyBaseInput;
import tianyuan.games.base.TyBaseOutput;

public class GoGameResult
extends Root {
    public int value = 0;
    public int blackValue = 0;
    public int whiteValue = 0;
    public boolean isChineseRule = true;
    public byte result = 0;
    public static final byte RESULT_NO_USE = 0;
    public static final byte RESULT_BLACK_WIN = 1;
    public static final byte RESULT_WHITE_WIN = 2;
    public static final byte RESULT_PEACE = 3;
    public static final byte RESULT_RESULTLESS = 4;
    public byte winMode = 0;
    public static final byte WIN_MODE_NO_USE = 0;
    public static final byte WIN_MODE_MIDDLE_WIN = 1;
    public static final byte WIN_MODE_TIME_OUT_WIN = 2;
    public static final byte WIN_MODE_BREAK_LINE_WIN = 3;
    public static final byte WIN_MODE_COMPUTE_WIN = 4;
    public static final byte WIN_MODE_NET_MANAGER_SET = 5;

    public boolean valueEquals(GoGameResult goGameResult) {
        if (this.result != goGameResult.result) {
            return false;
        }
        if (this.winMode != goGameResult.winMode) {
            return false;
        }
        if (this.blackValue != goGameResult.blackValue) {
            return false;
        }
        return this.whiteValue == goGameResult.whiteValue;
    }

    public String toString(MyProperties myProperties) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        switch (this.result) {
            case 1: {
                stringBuffer.append(myProperties.getKey("121_black"));
                stringBuffer.append(this.winModeString(myProperties));
                break;
            }
            case 2: {
                stringBuffer.append(myProperties.getKey("121_white"));
                stringBuffer.append(this.winModeString(myProperties));
                break;
            }
            case 3: {
                stringBuffer.append(myProperties.getKey("121_peace"));
                break;
            }
            case 4: {
                stringBuffer.append(myProperties.getKey("121_result_less"));
                break;
            }
        }
        return stringBuffer.toString();
    }

    private String winModeString(MyProperties myProperties) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        switch (this.winMode) {
            case 1: {
                stringBuffer.append(myProperties.getKey("121_middle_win"));
                break;
            }
            case 2: {
                stringBuffer.append(myProperties.getKey("121_time_out_win"));
                break;
            }
            case 3: {
                stringBuffer.append(myProperties.getKey("121_break_line_win"));
                break;
            }
            case 4: {
                stringBuffer.append(myProperties.getKey("121_compute_win"));
                stringBuffer.append(this.valueString(myProperties));
                break;
            }
            case 5: {
                stringBuffer.append(myProperties.getKey("121_middle_win"));
                break;
            }
            case 0: {
                break;
            }
        }
        return stringBuffer.toString();
    }

    private String valueString(MyProperties myProperties) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        double d = (double)this.value / 100.0;
        stringBuffer.append(d + " " + myProperties.getKey("121_mu"));
        if (this.isChineseRule) {
            double d2 = (double)this.blackValue / 200.0;
            stringBuffer.append("\n" + myProperties.getKey("121_black") + " : " + d2 + ".");
            double d3 = (double)this.whiteValue / 200.0;
            stringBuffer.append("\n" + myProperties.getKey("121_white") + " : " + d3 + ".\n");
        } else {
            double d4 = (double)this.blackValue / 100.0;
            stringBuffer.append("\n" + myProperties.getKey("121_black") + " : " + d4 + " " + myProperties.getKey("121_mu") + ".");
            double d5 = (double)this.whiteValue / 100.0;
            stringBuffer.append("\n" + myProperties.getKey("121_white") + " : " + d5 + " " + myProperties.getKey("121_mu") + ".\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeMeat(TyBaseOutput tyBaseOutput) throws IOException {
        tyBaseOutput.writeByte(this.result);
        tyBaseOutput.writeByte(this.winMode);
        tyBaseOutput.writeInt(this.value);
        tyBaseOutput.writeInt(this.blackValue);
        tyBaseOutput.writeInt(this.whiteValue);
        tyBaseOutput.writeBoolean(this.isChineseRule);
    }

    @Override
    public void readMeat(TyBaseInput tyBaseInput) throws IOException {
        this.result = tyBaseInput.readByte();
        this.winMode = tyBaseInput.readByte();
        this.value = tyBaseInput.readInt();
        this.blackValue = tyBaseInput.readInt();
        this.whiteValue = tyBaseInput.readInt();
        this.isChineseRule = tyBaseInput.readBoolean();
    }
}

