﻿var learnPage = {
    errorCodes: undefined,  //全局返回码（数组）
    key: undefined,         //页面key
    isLoad: false,          //表示当前是否正在异步加载,正在加载则停止当前ajax动作
    init: function () {
        /// <summary>
        ///     1: 初始化函数
        ///     &#10;    1.1 - init() - 在本类库(learnPage)工作之前，请调用本函数进行类库初始化和页面数据初始化
        /// </summary>
        /// <returns type="void" />
        //初始化全局返回码
        learnPage.errorCodes = new Array(lgchenggong, lgcanshuyichang, lgmeiyouchaxundaoxiangguan, lgmeiyoudengluqingdenglu, lgkongpinglunneirong, lgpinglunshibai, lgshujuyichang, lgweizhiyichang);
        learnPage.key = learnPage.getUrlPara("key");
        if (learnPage.key == '') {
           // learnPage.showError('页面数据不正确，请刷新页面或重新访问本页面！');
            return;
        }
        $("#l_Menu>a").click(function () {
            learnPage.loadMenu(this, $(this).attr('data'));
        });
        learnPage.loadChart();
        //评论框事件
        $("#interText").focus(function () {
            var value = jQuery.trim($(this).val());
            if (value == lgzaizhelishuru)
                $(this).val('');
        }).blur(function () {
            var value = jQuery.trim($(this).val());
            if (value.length < 1) {
                $(this).val(lgzaizhelishuru);
            }
        }).val(lgzaizhelishuru).keyup(function (e) {
            var event = e || window.event;
            var key = e.keyCode || e.which || e.charCode; //获取键盘码
            if (key == 13 && e.ctrlKey) $("#submitInteract").click();
        });
        //发言按钮单击事件
        $("#submitInteract").click(function () {
            var context = jQuery.trim($("#interText").val());
            if (context.length < 1 || context == lgzaizhelishuru) {
                $("#interText").focus();
                return;
            }
            //发言
            learnPage.submitChart(context);
        });
        //关闭详情
        $('#cc_Close').click(function () {
            $("#courDetail").stop().animate({ left: -700 }, function () {
                $("#courBar").css('display', 'none');
            });
        });
    },
    loadChart: function () {
        /// <summary>
        ///     1: 加载互动函数
        ///     &#10;    1.1 - loadChart(context) - 该函数加载互动列表信息到页面中
        /// </summary>
        /// <returns type="void" />
        learnPage.ajaxLoad("/Training/Learn/Learn_FilesInteracts.ashx", { action: 1, key: learnPage.key }, function (data) {
            if (!data) {
                learnPage.showError('', 6);
                return;
            }
            if (data.code === 0 && data.data) {
                $("#interMain").prepend(data.data).scrollTop(100);
                return;
            } else if (data.code === 2) return;
            learnPage.showError(lgjiazaiyouxihudong, data.code);
        }, function () {
            learnPage.showError(lgxuexihudongshibaiwangluo);
        });

    },
    submitChart: function (context) {
        /// <summary>
        ///     1: 发言函数
        ///     &#10;    1.1 - submitChart(context) - 发言函数
        /// </summary>
        /// <param name="context" type="String">
        ///     发言的内容
        /// </param>
        /// <returns type="void" />
        learnPage.ajaxLoad("/Training/Learn/Learn_FilesInteracts.ashx", { action: 0, key: learnPage.key, ct: context }, function (data) {
            if (!data) {
                learnPage.showError('', 6);
                return;
            }
            if (data.code === 0 && data.data) {
                $("#interMain").prepend(data.data).scrollTop(100);
                $("#interText").val('');
                return;
            }
            learnPage.showError(lgxuexihundongfayanyichang, data.code);
        }, function () {
            learnPage.showError(lgxueyuanhudongfayanshibai);
        });
    },
    loadMenu: function (data, index) {
        /// <summary>
        ///     1: 每个菜单项点击的函数
        ///     &#10;    1.1 - loadMenu(data,index) - 每个菜单项点击的函数
        /// </summary>
        /// <param name="data" type="String">
        ///     菜单项对象
        /// </param>
        /// <param name="index" type="Int">
        ///     菜单项索引（或数据）：{ 默认:培训 , 2 : 练习 , 3:作业 , 4:详情 }
        /// </param>
        /// <returns type="void" />
        $('.menuHover').removeClass('menuHover');
        $(data).addClass('menuHover');
        switch (parseInt(index)) {
            case 2: //练习
                $("#Interacts").hide();
                $("#rightmain").show().attr("src", "/Training/Exam/Practise_List.aspx?Key=" + learnPage.key);
                break;
            case 3: //作业
                $("#Interacts").hide();
                $("#rightmain").show().attr("src", "/Training/Exam/Practise_List.aspx?Key=" + learnPage.key + "&type=1");
                break;
            case 4: //详情
                $("#courBar").css('display', 'block');
                $("#courDetail").stop().animate({ left: 5 });
                break;
            default: //默认培训
                $("#Interacts").show()
                $("#rightmain").hide();
                break;
        }
    },
    getUrlPara: function (fieldName) {
        /// <summary>
        ///     1: 获取地址栏参数方法
        ///     &#10;    1.1 - getUrlPara(fieldName) - 在当前Url中查询指定的参数，返回查询得到的值
        /// </summary>
        /// <param name="fieldName" type="String">
        ///     要查询的字符串
        /// </param>
        /// <returns type="String" />
        var urlString = document.location.search;
        if (urlString != null) {
            var typeQu = fieldName + "=";
            var urlEnd = urlString.indexOf(typeQu);
            if (urlEnd != -1) {
                var paramsUrl = urlString.substring(urlEnd + typeQu.length);
                var isEnd = paramsUrl.indexOf('&');
                if (isEnd != -1) {
                    return paramsUrl.substring(0, isEnd);
                }
                else {
                    return paramsUrl;
                }
            }
            else {
                return "";
            }
        }
        else {
            return "";
        }
    },
    showError: function (htmlMsg, errCode) {
        /// <summary>
        ///     1: 显示异常函数
        ///     &#10;    1.1 - showError() - 显示异常消息，该函数显示默认内容：发生异常，请刷新网页或稍后重新尝试
        ///     &#10;    1.2 - showError(htmlMsg) - 显示指定的异常消息
        ///     &#10;    1.3 - showError(htmlMsg,errCode) - 显示指定的异常信息，并根据异常编码(全局)对异常信息进行补充
        /// </summary>
        /// <param name="htmlMsg" type="String">
        ///     要显示的异常信息内容
        /// </param>
        /// <param name="errCode" type="Int">
        ///     异常编码，详情请参考变量errorCodes
        /// </param>
        /// <returns type="String" />
        var msg = lgshujuyichangqingjiance;
        if (htmlMsg)
            msg = htmlMsg;
        if (errCode)
            msg += lgyichangxinxi+'：' + learnPage.errorCodes[errCode];
        ZENG.msgbox.show(msg, 5, 4000);
    },
    ajaxLoad: function (url, data, success, error) {
        /// <summary>
        ///     1: ajax请求方法
        ///     &#10;    1.1 - ajaxLoad(url, data, success, error) - 该函数用于ajax请求，注意data只接受json格式的数据，不接受字符串
        /// </summary>
        /// <param name="url" type="String">
        ///     ajax请求url
        /// </param>
        /// <param name="data" type="Json">
        ///     ajax参数，只接受json格式的对象，不接受字符串拼接而成参数
        /// </param>
        /// <param name="success" type="Function">
        ///     ajax请求成功后执行的函数
        /// </param>
        /// <param name="error" type="Function">
        ///     ajax请求异常执行的函数，该函数允许为空，【但强烈不建议为空，请尽可能处理可以捕捉到的异常】
        /// </param>
        /// <returns type="String" />
        if (learnPage.isLoad)
            return;
        learnPage.isLoad = true;
        $.ajax({
            url: url,
            type: "post",
            contentType: 'application/x-www-form-urlencoded',
            //  contentType: 'application/json',
            //  ajax ContentType请求为application/json，有时候一般处理程序并不能解析到参数，在监控了jQuery.post()方法后将请求头修改的和post一样，测试通过，可以接收到参数，目前原因未知。
            data: data,
            dataType: "json",
            success: function (data) {
                learnPage.isLoad = false;
                success(data);
            },
            error: function () {
                learnPage.isLoad = false;
                if (error)
                    error();
            }
        });
    }
};