﻿/*
* TKS公告业务Js类，本类库提供公告信息的方法，本类库依赖jQuery
* 版本：1.0
* 作者:linkFly 
* 时间:2014-01-26 17:39:47
* 概述：本类库提供以下一系列方法：
*/
var affichet = {
    //当前内容区域的DOM模型：{dataId: 当前公告ID, model: 当前公告栏jQuery对象（模型）, title: 公告标题, context: 公告正文, date: 公告发布时间, author: 公告作者}
    DOM: { dataId: undefined, model: undefined, title: undefined, context: undefined, date: undefined, author: undefined },
    init: function () {
        /// <summary>
        ///     init() - 在使用affichet类库之前，必须调用本函数作为初始化数据，而整个页面只需要调用一次本函数，无需重复调用。
        /// </summary>
        /// <returns type="void" />
        //创建DOM
        affichet.DOM.model = affichet.DOM.model ? affichet.DOM.model : $('<div class="affichetContainer" id="affichetBar" style="position: absolute; display: none;background-color: #FAFAFA; color: #333 !important; font: 14px/24px \'Helvetica Neue\' ,Helvetica,Arial, \'Microsoft Yahei\' ,sans-serif !important;outline: none; width: 400px; border: 1px solid #CCC; box-shadow: 0 2px 6px rgba(100, 100, 100, 0.3);padding: 10px;"><span id="affichet_close" style="background: #FAFAFA url(\'/Themes/Images/icons.png\') no-repeat -247px -146px;display: block; width: 16px; height: 16px; position: absolute;right: -5px; top: -5px;cursor:pointer;" title="点击关闭"></span><div><div class="affichet_Title" id="affichet_Title" style="font-weight: bold; font-size: 14px;border-bottom: 1px dotted #CCC;"></div><div class="affichet_Context" id="affichet_Context" style="text-align: justify; text-indent: 2em;word-wrap: break-word; word-break: normal; word-break: break-all;"></div><div id="affichet_Footer" class="affichet_Footer" style="text-align: right; color: #908f8f;"><span class="affichet_Date" id="affichet_Date"></span> <span id="affichet_Author"class="affichet_Author"></span></div></div></div>');
        //追加到页面
        $('body').append(affichet.DOM.model);
        //阻止DOM冒泡
        affichet.DOM.model.bind('dblclick', function (e) {
            affichet.stopBubble(e);
        });
    },
    showDetail: function (e, dataId) {
        /// <summary>
        ///     1: 显示公告明细，一般来说，除了首先init()初始化之后，只需要调用本函数并传入公告ID则可以显示内容
        ///     &#10;    1.1 - showDetail(e,dataId) - 根据公告ID显示公告明细
        ///     &#10;    注：会保留最后一条对应的公告明细数据，如果多次连贯重复的操作(即dataId和保留的数据一致)，则不再进行异步访问服务器查询
        /// </summary>
        /// <param name="e" type="Event">
        ///     因为和某些事件冒泡冲突，需要传入Event对象，如果没有该对象则自动处理兼容性
        /// </param>
        /// <param name="dataId" type="String">
        ///     公告ID
        /// </param>
        /// <returns type="void" />
        affichet.stopBubble(e); //阻止事件冒泡而造成的关闭操作
        if (affichet.DOM.dataId == dataId)//当数据和保留数据一致，直接拉取数据
            affichet.showDOM();
        else {
            affichet.DOM.dataId = dataId; //数据源，公告的ID主键
            affichet.loadData(); //异步访问
        }
        //绑定关闭事件
        affichet.hiddenDetail();
    },
    //
    hiddenDetail: function () {
        /// <summary>
        ///     1: 隐藏公告的DOM，如有需求，可以重写。
        ///     &#10;    1.1 - hiddenDetail() - 为当前页面隐藏公告框的操作绑定事件（双击页面任意非公告框的元素、单击关闭按钮）
        /// </summary>
        /// <returns type="void" />
        $(document.getElementById('affichet_close')).one('click', function () {
            affichet.DOM.model.stop().fadeOut(300);
        });
        $(window).one('dblclick', function () {
            affichet.DOM.model.stop().fadeOut(300);
        });
    },
    //异步加载数据
    loadData: function () {
        /// <summary>
        ///     - 异步加载数据
        /// </summary>
        /// <returns type="void" />
        $.ajax({
            url: "/Training/Affichet/Affichet_Detail.ashx",
            type: "post",
            contentType: 'application/x-www-form-urlencoded',
            //            contentType: 'application/json',
            //  ajax ContentType请求为application/json，有时候一般处理程序并不能解析到参数，在监控了jQuery.post()方法后将请求头修改的和post一样，测试通过，可以接收到参数，目前原因未知。
            data: { dataId: affichet.DOM.dataId },
            dataType: "json",
            success: function (data) {
                affichet.addModel(data);
            },
            error: function () {
                affichet.addModel();
            }
        });

    },
    showDOM: function () {
        /// <summary>
        ///     1: 显示DOM
        ///     &#10;    1.1 - showDOM() - 显示DOM
        /// </summary>
        /// <returns type="void" />
        affichet.DOM.model.css({ 'left': ($(window).width() - affichet.DOM.model.width() - 200) / 2, "top": ($(window).height() - affichet.DOM.model.height() - 100) / 2 }).stop().fadeIn(300);
    },
    addModel: function (data) {
        /// <summary>
        ///     1: 将数据填充到DOM，如有需求，可以重写。
        ///     &#10;    1.1 - addModel(data) - 根据ajax返回的结果，将数据填充到对应的DOM模型中，同时显示该DOM
        /// </summary>
        /// <param name="data" type="Json">
        ///     服务器返回的Json对象
        /// </param>
        /// <returns type="void" />
        if (!data || data == undefined) { //异常
            affichet.DOM.title = '<span style="color:red;">' + lgshujuyichangqingjiance + '</span>';
            affichet.DOM.context = lgshujuyichangqingjiance;
            affichet.DOM.date = '';
            affichet.DOM.author = '';
        }
        switch (data.code) {
            case 1:
                affichet.DOM.title = '<span style="color:red;">' + lgshujuyichangqingjiance + '</span>';
                affichet.DOM.context = lgshujuyichangqingjiance;
                affichet.DOM.date = '';
                affichet.DOM.author = '';
                break;
            case 2:
                affichet.DOM.title = '<span style="color:red;">' + lgshujuyichangqingjiance + '</span>';
                affichet.DOM.context = lgshujuyichangqingjiance;
                affichet.DOM.date = '';
                affichet.DOM.author = '';
                break;
            case 0:
                affichet.DOM.title = data.title;
                //                affichet.DOM.context = (data.context + '').replace(/</g, '&lt').replace(/>/g, '&gt');
                affichet.DOM.context = data.context;
                affichet.DOM.date = data.date;
                affichet.DOM.author = data.author;
                break;
            default:
                affichet.DOM.title = '<span style="color:red;">' + lgshujuyichangqingjiance + '</span>';
                affichet.DOM.context = lgshujuyichangqingjiance;
                affichet.DOM.date = '';
                affichet.DOM.author = '';
                break;
        }
        affichet.DOM.model.find('#affichet_Title').html(affichet.DOM.title);
        affichet.DOM.model.find('#affichet_Context').text(affichet.DOM.context);
        affichet.DOM.model.find('#affichet_Date').html(affichet.DOM.date);
        affichet.DOM.model.find('#affichet_Author').html(affichet.DOM.author);
        affichet.showDOM();
    },
    //    mousePostion: function (e) {
    //        /// <summary>
    //        ///     1: 获取鼠标对象的坐标，如果需要让提示框跟随鼠标显示，则使用本方法
    //        ///     &#10;    1.1 - mousePostion(e) - 传入event对象（e），自动检测兼容性，获取鼠标对象后返回包含坐标信息的Json数据，包含如下属性：
    //        ///     &#10;    x:x轴坐标
    //        ///     &#10;    y:y轴坐标
    //        /// </summary>
    //        /// <param name="e" type="Event">
    //        ///     在现代浏览器中，可以通过e获取Event对象，而在怪异模式下本函数自动进行兼容性处理
    //        /// </param>
    //        /// <returns type="Json" />
    //        var ev = e || window.event; //获取事件对象
    //        if (ev.pageX || ev.pageY) {
    //            return { x: ev.pageX, y: ev.pageY };
    //        }
    //        return {
    //            x: ev.clientX + document.body.scrollLeft - document.body.clientLeft,
    //            y: ev.clientY + document.body.scrollTop - document.body.clientTop
    //        };
    //    },
    stopBubble: function (e) {
        /// <summary>
        ///     1: 阻止事件冒泡
        ///     &#10;    1.1 - stopBubble(e) - 传入event对象（e），自动检测兼容性，阻止事件冒泡
        /// </summary>
        /// <param name="e" type="Event">
        ///     在现代浏览器中，可以通过e获取Event对象，而在怪异模式下本函数自动进行兼容性处理
        /// </param>
        /// <returns type="void" />
        // 如果传入了事件对象，那么就是非ie浏览器  
        if (e && e.stopPropagation) {
            //因此它支持W3C的stopPropagation()方法  
            e.stopPropagation();
        } else {
            //否则我们使用ie的方法来取消事件冒泡  
            window.event.cancelBubble = true;
        }
    }

};
