﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Tags_List.aspx.cs" Inherits="RM.Web.RMBase.SysTag.Tags_List" %>

<%@ Register Src="~/UserControl/LoadButton.ascx" TagName="LoadButton" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List")%></title>
    <link href="/Themes/Styles/Site.css" rel="stylesheet" type="text/css" />
    <script src="/Themes/Scripts/jquery-1.8.2.min.js" type="text/javascript"></script>
    <link href="../../Themes/Scripts/artDialog/skins/opera.css" rel="stylesheet" type="text/css" />
    <script src="../../Themes/Scripts/artDialog/artDialog.js" type="text/javascript"></script>
    <script src="../../Themes/Scripts/artDialog/iframeTools.js" type="text/javascript"></script>
    <script src="/Themes/Scripts/FunctionJS.js" type="text/javascript"></script>
    <style type="text/css">
        .tags_ChangeColor { border-radius: 2px; padding: 0px 10px; margin-right: 3px; background-image: url("/Themes/Images/folderlist_setting104474.png"); background-position: 6px -43px; background-repeat: no-repeat; }
        .tags_Name { color: White; padding: 0 8px; }
        .promptTitle { float: left; vertical-align: middle; color: #fd5b78; padding-top: 7px; margin-left: 5px; }
        #colorSelector li { padding: 8px 10px; display: inline-block; margin: 0px; cursor: pointer; margin: 3px; }
        #colorSelector { width: 150px; padding: 0px; margin: 0px; border: 1px solid #A0A0A0; background-color: #FFFFFF; text-align: center; padding: 10px 10px; border-radius: 3px; position: absolute; z-index: 10; display: none; }
        .updateTags { margin-right: 10px; }
    </style>
    <script type="text/javascript">
        //异步保存方法
        function ajaxUpdate(jsonData, resultFun) {
            $.post("/RMBase/SysTag/Tags_Update.ashx", jsonData, resultFun);
        }
        $(function () {
            var currTagObj; //当前正在改变颜色的对象
            $(".tags_ChangeColor").click(function (e) {
                stopBubble(e);
                var offset = $(this).offset();
                var top = offset.top + $(this).height();
                var left = offset.left + $(this).width();
                currTagObj = $(this);
                $("#colorSelector").css({ top: top, left: left }).fadeIn(300);
                $(document).one("click", function () {
                    currTagObj = null;
                    $("#colorSelector").fadeOut(300);
                });
            });
            $("#colorSelector").click(function (e) {
                stopBubble(e);
            });
            $("#colorSelector>li").click(function () {
                if (!currTagObj) {
                    alert('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List")%>');
                    return false;
                }
                var selectColor = $(this).attr("data"); //获取选中的颜色
                var temp = $(currTagObj).parent().siblings();
                var tN = temp.eq(0).text(); //获取表名和主键名
                var tK = temp.eq(1).text();
                var vN = $(currTagObj).next().text();
                //异步保存
                ajaxUpdate({ tN: tN, tK: tK, vL: selectColor, vN: vN }, function (data) {
                    if (parseInt(data) > 0) {
                        $(currTagObj).css("background-color", selectColor);
                        $(currTagObj).next().css("background-color", selectColor);
                        showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_save")%>', 1500, 4);
                        $(document).click();
                    } else {
                        showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_savesb")%>', 1500, 5);
                    }
                });
            })
            //阻止事件冒泡的通用函数  
            function stopBubble(e) {
                // 如果传入了事件对象，那么就是非ie浏览器  
                if (e && e.stopPropagation) {
                    //因此它支持W3C的stopPropagation()方法  
                    e.stopPropagation();
                } else {
                    //否则我们使用ie的方法来取消事件冒泡  
                    window.event.cancelBubble = true;
                }
            }

        });
        function updateTag(vN, tN, tK, obj) {
            var tempDom = $('<div id="editTags"><input id="txtTages" style=" border:1px solid #CCC; width:370px; line-height:20px; height:20px; font-size:10pt;" value="' + vN + '" /><span style="color:#fd5b78;padding-left:10px;"><%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_save6")%></span></div>');
            art.dialog({
                id: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_bj")%>',
                title: 'Tags_List_bj',
                content: tempDom.get(0),
                button: [
                            {
                                name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Save")%>',
                                callback: function () {
                                    var newTagsName = jQuery.trim(tempDom.find("#txtTages").val());
                                    if (newTagsName == "") {
                                        showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_srbqm")%>', 1500, 3);
                                        return false;
                                    }
                                    $.post("/RMBase/SysTag/Tags_Update.ashx", { tN: tN, tK: tK, vL: newTagsName, vN: vN, action: "uN" }, function (data) {
                                        var result = parseInt(data);
                                        if (result > 0) {
                                            $(obj).closest("tr").children().first().children(".tags_Name").text(newTagsName);
                                            $(obj).attr("onclick", "updateTag('" + newTagsName + "','" + tN + "','" + tK + "',this)");
                                            showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_bccg")%>', 1500, 4);
                                            return true;
                                        } else if (result == -2) {
                                            showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_bcsb")%>', 1500, 5);
                                            return false;
                                        } else if (result == -3) {
                                            showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_ycz")%>', 1500, 3);
                                            return false;
                                        } else {
                                            showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_bcbqcw")%>', 1500, 5);
                                            return false;
                                        }
                                    });
                                },
                                focus: true
                            },
                            {
                                name: '<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Close")%>',
                                callback: function () {
                                    tempDom.remove();
                                    return true;
                                }
                            }
                       ]
            });
        }
        function deleteTag(vN, tN, tK, obj) {
            showConfirmMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_qdsc")%>', function () {
                ajaxUpdate({ tN: tN, tK: tK, vL: vN, action: "dL" }, function (data) {
                    if (parseInt(data) > 0) {
                        $(obj).closest("tr").remove();
                        showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_sccg")%>', 1500, 4);
                        return true;
                    } else {
                        showTipsMsg('<%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_scbqsb")%>', 1500, 4);
                        return false;
                    }
                });

            });
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="btnbartitle">
        <div>
            <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List")%>
        </div>
    </div>
    <div class="btnbarcontetn">
        <div class="promptTitle">
            <%=RM.Common.DotNetConfig.LanguageHelper.GetKey("Tags_List_zy")%></div>
        <div style="text-align: right">
            <uc2:LoadButton ID="LoadButton1" runat="server" />
        </div>
    </div>
    <div class="div-body">
        <%=TableHtml.ToString()%>
    </div>
    <div>
        <ul id="colorSelector">
            <!--data为解决浏览器对color的不同解析问题-->
            <li style="background-color: #000000" data="#000000"></li>
            <li style="background-color: #609022" data="#609022"></li>
            <li style="background-color: #609022" data="#609022"></li>
            <li style="background-color: #35909e" data="#35909e"></li>
            <li style="background-color: #3d6aaa" data="#3d6aaa"></li>
            <li style="background-color: #4d53a5" data="#4d53a5"></li>
            <li style="background-color: #b48e43" data="#b48e43"></li>
            <li style="background-color: #c26502" data="#c26502"></li>
            <li style="background-color: #b3341a" data="#b3341a"></li>
            <li style="background-color: #c24d96" data="#c24d96"></li>
            <li style="background-color: #b20e0e" data="#b20e0e"></li>
            <li style="background-color: #e59c00" data="#e59c00"></li>
            <li style="background-color: #ec6928" data="#ec6928"></li>
            <li style="background-color: #9d569d" data="#9d569d"></li>
            <li style="background-color: #955959" data="#955959"></li>
            <li style="background-color: #ae7841" data="#ae7841"></li>
            <li style="background-color: #ec5105" data="#ec5105"></li>
            <li style="background-color: #ab4646" data="#ab4646"></li>
            <li style="background-color: #ec5105" data="#ec5105"></li>
            <li style="background-color: #950695" data="#950695"></li>
            <li style="background-color: #703b70" data="#703b70"></li>
            <li style="background-color: #3b994f" data="#3b994f"></li>
            <li style="background-color: #21b1b1" data="#21b1b1"></li>
            <li style="background-color: #1e87ef" data="#1e87ef"></li>
            <li style="background-color: #4b9d8f" data="#4b9d8f"></li>
            <li style="background-color: #7c657c" data="#7c657c"></li>
            <li style="background-color: #5487ed" data="#5487ed"></li>
            <li style="background-color: #354b66" data="#354b66"></li>
            <li style="background-color: #2768ea" data="#2768ea"></li>
            <li style="background-color: #7044b2" data="#7044b2"></li>
            <li style="background-color: #1f28df" data="#1f28df"></li>
            <li style="background-color: #a59f79" data="#a59f79"></li>
            <li style="background-color: #8899ab" data="#8899ab"></li>
            <li style="background-color: #585858" data="#585858"></li>
            <li style="background-color: #343434" data="#343434"></li>
        </ul>
    </div>
    </form>
</body>
</html>
<script type="text/javascript">
    $(function () {
        //把分页定位到屏幕下面
        divresize(90);
        FixedTableHeader("#table1", $(window).height() - 121);
    })
</script>
