
local addon, ns = ...

-------------------------------------
-- 隊友目標: DEBUFFS
-- Author:M
-------------------------------------

--創建debuff按鈕
local function PartyTargetDebuff_CreateButton(parent, index)
    local parentName = parent:GetName()
    local frameName = parentName.."Debuff"..index
    local frame = CreateFrame("Button", frameName, parent, "TargetDebuffFrameTemplate")
    frame.unit = parent.unit
    frame:SetID(index)
    frame:SetScale(0.8)
    if (index == 1) then
        frame:SetPoint("TOPLEFT", parent, "TOPLEFT", parent.buffAnchorX or 64, -39)
    elseif (index == 5) then
        frame:SetPoint("TOPLEFT", parent, "TOPLEFT", parent.buffAnchorX or 64, -60)
    else
        frame:SetPoint("LEFT", _G[parentName.."Debuff"..(index-1)], "RIGHT", 4, 0)
    end
    frame:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_BOTTOMRIGHT", 20, -20)
        GameTooltip:SetUnitDebuff(self.unit, self:GetID())
    end)
    frame:SetScript("OnLeave", function() GameTooltip:Hide() end)
    return frame
end

--刷新debuff情況
local function PartyTargetDebuff_RefreshDebuffs(self)
    local numDebuffs = 8
    local frame, frameName
    local frameIcon, frameCount, frameCooldown, frameBorder, color
    local debuffName, _, icon, count, debuffType, duration, expirationTime, unitCaster, canApplyAura
    local selfName = self:GetName()
    local frameNum = 1
    for index = 1, numDebuffs do
        debuffName, _, icon, count, debuffType, duration, expirationTime, unitCaster, _, _, _, canApplyAura = UnitDebuff(self.unit, index, "INCLUDE_NAME_PLATE_ONLY")
        if (debuffName) then
            frameName = selfName.."Debuff"..index
            frame = _G[frameName]
            if (icon) then
                if (not frame) then frame = PartyTargetDebuff_CreateButton(self,index) end
                --icon
                frameIcon = _G[frameName.."Icon"]
                frameIcon:SetTexture(icon)
                --count
                frameCount = _G[frameName.."Count"]
                if (count > 1 and self.showAuraCount) then
                    frameCount:SetText(count)
                    frameCount:Show()
                else
                    frameCount:Hide()
                end
                --cooldown
                frameCooldown = _G[frameName.."Cooldown"]
                CooldownFrame_Set(frameCooldown, expirationTime - duration, duration, duration > 0, true)
                if (unitCaster and duration and duration <= 60 and unitCaster == "player") then
                    frameCooldown:SetHideCountdownNumbers(false)
                else
                    frameCooldown:SetHideCountdownNumbers(true)
                end
                --color
                if (debuffType) then
                    color = DebuffTypeColor[debuffType]
                else
                    color = DebuffTypeColor["none"]
                end
                frameBorder = _G[frameName.."Border"]
                frameBorder:SetVertexColor(color.r, color.g, color.b)

                frame:Show()
                frameNum = frameNum + 1
            end
        end
    end
    
    for i = frameNum, numDebuffs do
		frame = _G[selfName.."Debuff"..i]
		if (frame) then frame:Hide() end
	end
end

--更新頻率
local function PartyTargetDebuff_OnUpdate(self, elapsed)
    self.timer = (self.timer or 0) + elapsed;
    if (self:GetAlpha() > 0.4 and self.timer >= 0.2) then
        self.timer = 0
        PartyTargetDebuff_RefreshDebuffs(self)
    end
end


-------------------------------------
-- 隊友目標框架
-------------------------------------

--更新名字 中英文字號適配
local maxFontSize = GetLocale():sub(1,2) == "zh" and 16 or 13
local function PartyTarget_UpdateName(self, unit)
    local name = UnitName(unit)
    local color = NORMAL_FONT_COLOR
    if (UnitIsPlayer(unit)) then
        color = RAID_CLASS_COLORS[select(2,UnitClass(unit))]
    end
    local fontFile, fontSize, fontFlags = self.Name:GetFont()
    local placeSize = ceil(#name/3)
    local shownSize
    if (string.byte(name) >= 128) then
        shownSize = min(18 - placeSize, 14)
    else
        shownSize = min(18 - placeSize, maxFontSize)
    end
    if (shownSize <= 8) then shownSize = 8 end
    if (fontSize ~= shownSize) then
        self.Name:SetFont(fontFile, shownSize, fontFlags)
    end
    self.Name:SetText(name)
    self.Name:SetTextColor(color.r, color.g, color.b)
end

--更新HP
local function PartyTarget_UpdateHealth(self, unit)
    local hp = UnitHealth(unit)
    local perc = floor(hp / max((UnitHealthMax(unit) or 1),1) * 100)
    self.HealthBar:SetValue(perc)
    if (hp <= 1) then
        self.HealthBar.Text:SetText("|cffeed200Dead|r")
        --self.Portrait:SetTexture("Interface\\TargetingFrame\\TargetDead")
    else
        self.HealthBar.Text:SetText(perc .. "%")
    end
end

--更新MP
local function PartyTarget_UpdatePower(self, unit)
    local powerType = UnitPowerType(unit)
    local color = PowerBarColor[powerType] or PowerBarColor["MANA"]
    self.ManaBar:SetStatusBarColor(color.r, color.g, color.b)
    self.ManaBar:SetValue(floor(UnitPower(unit,powerType)/UnitPowerMax(unit,powerType) * 100))
end

--更新颜色
local function PartyTarget_UpdateColor(self, unit)
    if UnitIsEnemy("player", unit) then
        self.HealthBar:SetStatusBarColor(0.9, 0.16, 0.16)
    elseif UnitIsFriend("player", unit) then
        self.HealthBar:SetStatusBarColor(0.16, 0.9, 0.16)
    else
        self.HealthBar:SetStatusBarColor(0.9, 0.7, 0.2)
    end
    if (UnitIsUnit(unit, "target")) then
        self.Flash:Show()
    else
        self.Flash:Hide()
    end
end

--更新类别
local function PartyTarget_UpdateClassification(self, unit)
    local classification = UnitClassification(unit)
    if (classification == "worldboss" or classification == "elite") then
        if (self.reversed) then
            self.Texture.Elite:SetTexCoord(0.5, 0, 0, 1)
        else
            self.Texture.Elite:SetTexCoord(0, 0.5, 0, 1)
        end
		self.Texture.Elite:Show()
	elseif (classification == "rareelite" or classification == "rare") then
        if (self.reversed) then
            self.Texture.Elite:SetTexCoord(1, 0.5, 0, 1)
        else
            self.Texture.Elite:SetTexCoord(0.5, 1, 0, 1)
        end
		self.Texture.Elite:Show()
	else
        self.Texture.Elite:Hide()
    end
end

--更新透明度
local function PartyTarget_UpdateAlpha(self, unit)
    if (not UnitIsPlayer(unit)) then
        self:SetAlpha(1)
    elseif (UnitInRange(unit)) then
        self:SetAlpha(1)
    else
        self:SetAlpha(0.7)
    end
end

--隊友目標框架更新
local function PartyTarget_OnUpdate(self, elapsed)
	self.timer = (self.timer or 0) + elapsed
	if (self.timer >= 0.2) then
        self.timer = 0
        local unit = "party" .. self:GetID() .."target"
        local frame = _G["PartyTargetBlizFrame"..self:GetID()]
		if UnitExists(unit) then
            SetPortraitTexture(frame.Portrait, unit)
            PartyTarget_UpdateName(frame, unit)
            PartyTarget_UpdateHealth(frame, unit)
            PartyTarget_UpdatePower(frame, unit)
            PartyTarget_UpdateColor(frame, unit)
            PartyTarget_UpdateClassification(frame, unit)
            PartyTarget_UpdateAlpha(frame, unit)
		else
			frame:SetAlpha(0)
		end
	end
end

--創建隊友目標框架
local function PartyTarget_CreateButton(index, reversed)
    local parent = _G["PartyMemberFrame"..index] or UIParent
    local button = CreateFrame("Button", "PartyTargetBlizFrame"..index, parent, "SecureUnitButtonTemplate")
    button.unit = "party"..index.."target"
    button:SetID(index)
    button:SetFrameStrata("LOW")
    button:SetSize(128, 53)
    button:SetHitRectInsets(7, 10, 0, 8)
    button:SetAttribute("unit", "party"..index.."target")
    button:SetAttribute("type1", "target")
    button:SetPoint("TOPLEFT", parent, "TOPLEFT", 188, 2)
    button:SetScript("OnUpdate", PartyTargetDebuff_OnUpdate) --這裡是註冊隊友目標的debuff顯示

    button.Portrait = button:CreateTexture(nil, "BACKGROUND")
    button.Portrait:SetSize(37, 37)
    button.Portrait:SetPoint("TOPLEFT", 7, -6)
    button.Portrait:SetTexture("Interface\\TargetingFrame\\TargetDead")

    button.Flash = button:CreateTexture(nil, "BACKGROUND")
    button.Flash:SetSize(128, 64)
    button.Flash:SetPoint("TOPLEFT", 3, 1)
    button.Flash:SetTexture("Interface\\TargetingFrame\\UI-PartyFrame-Flash")
    button.Flash:SetAlpha(0.8)
    button.Flash:SetVertexColor(1, 0.82, 0)
    button.Flash:Hide()

    button.Name = button:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
    button.Name:SetPoint("BOTTOMLEFT", 46, 44)
    button.Name:SetTextColor(1, 0.82, 0)
    button.Name:SetJustifyH("LEFT")

    button.HealthBar = CreateFrame("STATUSBAR", nil, button, "TextStatusBar")
    button.HealthBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
    button.HealthBar:SetSize(70, 8)
    button.HealthBar:SetPoint("TOPLEFT", 47, -12)
    button.HealthBar:SetFrameLevel(1)
    button.HealthBar:SetMinMaxValues(0, 100)

    button.ManaBar = CreateFrame("STATUSBAR", nil, button, "TextStatusBar")
    button.ManaBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
    button.ManaBar:SetSize(70, 8)
    button.ManaBar:SetPoint("TOPLEFT", 47, -21)
    button.ManaBar:SetFrameLevel(1)
    button.ManaBar:SetMinMaxValues(0, 100)

    button.Texture = CreateFrame("Frame", nil, button)
    button.Texture:SetSize(128, 64)
    button.Texture:SetPoint("TOPLEFT", 0, -2)
    button.Texture:SetFrameLevel(8)
    button.Texture.Border = button.Texture:CreateTexture(nil, "BORDER")
    button.Texture.Border:SetTexture("Interface\\TargetingFrame\\UI-PartyFrame")
    button.Texture.Border:SetSize(128, 64)
    button.Texture.Border:SetPoint("LEFT")
    
    button.Texture.Elite = button.Texture:CreateTexture(nil, "ARTWORK")
    button.Texture.Elite:SetTexture("Interface\\AddOns\\"..addon.."\\BorderElite")
    button.Texture.Elite:SetSize(64, 64)
    button.Texture.Elite:SetPoint("LEFT", -13, 6)
    button.Texture.Elite:SetAlpha(0.8)
    button.Texture.Elite:Hide()
    
    button.Texture.Focus = button.Texture:CreateTexture(nil, "ARTWORK")
    button.Texture.Focus:SetTexture("Interface\\Cursor\\Crosshairs")
    button.Texture.Focus:SetVertexColor(1, 0, 0)
    button.Texture.Focus:SetSize(44, 44)
    button.Texture.Focus:SetPoint("TOPLEFT", 3, -2)
    button.Texture.Focus:Hide()

    button.HealthBar.Text = button.Texture:CreateFontString(nil, "ARTWORK", "SystemFont_Outline_Small")
	button.HealthBar.Text:SetPoint("CENTER", button.HealthBar, "CENTER")
	button.HealthBar.Text:SetTextColor(1, 1, 1)
    button.HealthBar.Text:SetFont(SystemFont_Outline_Small:GetFont(), 10, "THINOUTLINE")

    button.reversed = reversed
    button.buffAnchorX = 63
    
    if (reversed) then
        button:SetPoint("TOPLEFT", parent, "TOPLEFT", 168, -2)
        button.Flash:SetTexCoord(1, 0, 0, 1)
        button.Texture.Border:SetTexCoord(1, 0, 0, 1)
        button.Texture.Elite:ClearAllPoints()
        button.Texture.Elite:SetPoint("RIGHT", 13, 6)
        button.Texture.Focus:ClearAllPoints()
        button.Texture.Focus:SetPoint("TOPRIGHT", -3, -2)
        button.Portrait:ClearAllPoints()
        button.Portrait:SetPoint("TOPRIGHT", -7, -6)
        button.Name:ClearAllPoints()
        button.Name:SetPoint("BOTTOMLEFT", 12, 44)
        button.HealthBar:ClearAllPoints()
        button.HealthBar:SetPoint("TOPRIGHT", -47, -12)
        button.ManaBar:ClearAllPoints()
        button.ManaBar:SetPoint("TOPRIGHT", -47, -21)
        button.buffAnchorX = 15
    end

    button:SetScale(0.9)
    button:SetAlpha(0)

    return button
end

for i = 1, MAX_PARTY_MEMBERS do PartyTarget_CreateButton(i, true) end  --true修改為false,頭像方向相反

hooksecurefunc("PartyMemberFrame_OnUpdate", PartyTarget_OnUpdate)
