
local addon, ns = ...

if (_G["PartyTargetBlizFrame1"]) then return end

-------------------------------------
-- 隊友目標: DEBUFFS
-------------------------------------

--創建debuff按鈕
local function PartyTargetDebuff_CreateButton(parent, index)
    local parentName = parent:GetName()
    local frameName = parentName.."Debuff"..index
    local frame = CreateFrame("Button", frameName, parent, "TargetDebuffFrameTemplate")
    frame.unit = parent.unit
    frame:SetID(index)
    frame:SetScale(0.75)
    if (index == 1) then
        frame:SetPoint("LEFT", parent, "RIGHT", 4, -8)
    else
        frame:SetPoint("LEFT", _G[parentName.."Debuff"..(index-1)], "RIGHT", 4, 0)
    end
    frame:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_BOTTOMRIGHT", 20, -20)
        GameTooltip:SetUnitDebuff(self.unit, self:GetID())
    end)
    frame:SetScript("OnLeave", function() GameTooltip:Hide() end)
    return frame
end

--刷新debuff情況
local function PartyTargetDebuff_RefreshDebuffs(self)
    local numDebuffs = 4
    local frame, frameName
    local frameIcon, frameCount, frameCooldown, frameBorder, color
    local selfName = self:GetName()
    local frameNum = 1
    for index = 1, numDebuffs do
        local debuffName, _, icon, count, debuffType, duration, expirationTime, unitCaster = UnitDebuff(self.unit, index, "INCLUDE_NAME_PLATE_ONLY")
        if (debuffName) then
            frameName = selfName.."Debuff"..index
            frame = _G[frameName]
            if (icon) then
                if (not frame) then frame = PartyTargetDebuff_CreateButton(self,index) end
                --icon
                frameIcon = _G[frameName.."Icon"]
                frameIcon:SetTexture(icon)
                --count
                frameCount = _G[frameName.."Count"]
                if (count > 1 and self.showAuraCount) then
                    frameCount:SetText(count)
                    frameCount:Show()
                else
                    frameCount:Hide()
                end
                --cooldown
                frameCooldown = _G[frameName.."Cooldown"]
                CooldownFrame_Set(frameCooldown, expirationTime - duration, duration, duration > 0, true)
                if (unitCaster and duration and duration <= 60 and unitCaster == "player") then
                    frameCooldown:SetHideCountdownNumbers(false)
                else
                    frameCooldown:SetHideCountdownNumbers(true)
                end
                --color
                if (debuffType) then
                    color = DebuffTypeColor[debuffType]
                else
                    color = DebuffTypeColor["none"]
                end
                frameBorder = _G[frameName.."Border"]
                frameBorder:SetVertexColor(color.r, color.g, color.b)
                
                frame:Show()
                frameNum = frameNum + 1
            end
        end
    end
    
    for i = frameNum, numDebuffs do
		frame = _G[selfName.."Debuff"..i]
		if (frame) then frame:Hide() end
	end
end

--更新頻率
local function PartyTargetDebuff_OnUpdate(self, elapsed)
    self.timer = (self.timer or 0) + elapsed;
    if (self:GetAlpha() > 0.4 and self.timer >= 0.2) then
        self.timer = 0
        PartyTargetDebuff_RefreshDebuffs(self)
    end
end


-------------------------------------
-- 隊友目標框架
-------------------------------------

--更新名字
local maxFontSize = GetLocale():sub(1,2) == "zh" and 16 or 13
local function PartyTarget_UpdateName(self, unit)
    local name = UnitName(unit)
    local color = RAID_CLASS_COLORS[select(2,UnitClass(unit))] or NORMAL_FONT_COLOR
    local fontFile, fontSize, fontFlags = self.Name:GetFont()
    local placeSize = ceil(#name/3)
    local shownSize
    if (string.byte(name) >= 128) then
        shownSize = min(19 - placeSize, 14)
    else
        shownSize = min(19 - placeSize, maxFontSize)
    end
    if (shownSize <= 8) then shownSize = 8 end
    if (fontSize ~= shownSize) then
        self.Name:SetFont(fontFile, shownSize, fontFlags)
    end
    self.Name:SetText(name)
    self.Name:SetTextColor(color.r, color.g, color.b)
end

--更新HP
local function PartyTarget_UpdateHealth(self, unit)
    local hp = UnitHealth(unit)
    local perc = floor(hp / max((UnitHealthMax(unit) or 1),1) * 100)
    self.HealthBar:SetValue(perc)
    if (hp <= 1) then
        self.HealthBar.Text:SetText("|cffeed200DEAD|r")
    else
        self.HealthBar.Text:SetText(perc .. "%")
    end
end

--更新颜色
local function PartyTarget_UpdateColor(self, unit)
    if UnitIsEnemy("player", unit) then
        self.Border:SetVertexColor(1, 0.2, 0.2, 0.6)
        self.HealthBar:SetStatusBarColor(0.9, 0.55, 0.72)
    elseif UnitIsFriend("player", unit) then
        self.Border:SetVertexColor(0, 1, 0, 0.6)
        self.HealthBar:SetStatusBarColor(0, 0.9, 0)
    else
        self.Border:SetVertexColor(0.9, 0.82, 0, 0.6)
        self.HealthBar:SetStatusBarColor(0.65, 0.9, 0.85)
    end
end

--更新透明度
local function PartyTarget_UpdateAlpha(self, unit)
    if (UnitInRange(unit)) then
        self:SetAlpha(1)
    else
        self:SetAlpha(0.8)
    end
end

--隊友目標框架更新
local function PartyTarget_OnUpdate(self, elapsed)
	self.timer = (self.timer or 0) + elapsed
	if (self.timer >= 0.2) then
        self.timer = 0
        local unit = "party" .. self:GetID() .."target"
        local frame = _G["PartyTargetFrame"..self:GetID()]
		if UnitExists(unit) then
            PartyTarget_UpdateName(frame, unit)
            PartyTarget_UpdateHealth(frame, unit)
            PartyTarget_UpdateColor(frame, unit)
            PartyTarget_UpdateAlpha(frame, unit)
		else
			frame:SetAlpha(0)
		end
	end
end

--創建隊友目標框架
local function PartyTarget_CreateButton(index)
    local parent = _G["PartyMemberFrame"..index]
    local button = CreateFrame("Button", "PartyTargetFrame"..index, parent, "SecureUnitButtonTemplate")
    button.unit = "party"..index.."target"
    button:SetID(index)
    button:SetFrameStrata("LOW")
    button:SetWidth(84)
    button:SetHeight(18)
    button:SetHitRectInsets(0, 0, -8, -6)
	button:SetAttribute("unit", "party"..index.."target")
	button:SetAttribute("type1", "target")
    button:SetPoint("TOPLEFT", parent, "TOPLEFT", 160, -5)
    button:SetScript("OnUpdate", PartyTargetDebuff_OnUpdate) --這裡是註冊隊友目標的debuff顯示

    button.Bg = button:CreateTexture(nil, "BACKGROUND")
	button.Bg:SetTexture("Interface\\Tooltips\\UI-Tooltip-Background")
    button.Bg:SetVertexColor(0, 0, 0, 0.6)
	button.Bg:SetWidth(82)
	button.Bg:SetHeight(11)
	button.Bg:SetPoint("TOPLEFT", button, "TOPLEFT", 1, -10)

    button.Name = button:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	button.Name:SetPoint("TOPLEFT", button, "TOPLEFT", 4, 9)
	button.Name:SetTextColor(1, 0.82, 0)

	button.Border = button:CreateTexture(nil, "BORDER")
	button.Border:SetTexture("Interface\\Tooltips\\UI-StatusBar-Border")
	button.Border:SetWidth(84)
	button.Border:SetHeight(18)
	button.Border:SetPoint("TOPLEFT", button, "TOPLEFT", 1, -6)

	button.HealthBar = CreateFrame("STATUSBAR", nil, button)
	button.HealthBar:SetStatusBarTexture("Interface\\AddOns\\"..addon.."\\StatusBar")
	button.HealthBar:SetFrameStrata("LOW")
	button.HealthBar:SetMinMaxValues(0, 100)
	button.HealthBar:SetValue(100)
	button.HealthBar:SetWidth(80)
	button.HealthBar:SetHeight(12)
	button.HealthBar:SetPoint("TOP", button, "TOP", 1, -9)

	button.HealthBar.Text = button.HealthBar:CreateFontString(nil, "ARTWORK", "SystemFont_Outline_Small")
	button.HealthBar.Text:SetPoint("CENTER", button.HealthBar, "CENTER", 3, 1)
	button.HealthBar.Text:SetTextColor(1, 1, 1)
    button.HealthBar.Text:SetFont(SystemFont_Outline_Small:GetFont(), 11, "OUTLINE")

    button:SetAlpha(0)
    
    return button
end

for i = 1, MAX_PARTY_MEMBERS do PartyTarget_CreateButton(i) end

hooksecurefunc("PartyMemberFrame_OnUpdate", PartyTarget_OnUpdate)
