asynctest(
  'Browser Test: features.UnlinkTest',

  [
    'ephox.agar.api.GeneralSteps',
    'ephox.agar.api.Pipeline',
    'ephox.alloy.test.GuiSetup',
    'ephox.sugar.api.node.Body',
    'ephox.sugar.api.search.Traverse',
    'tinymce.themes.mobile.test.theme.TestTheme',
    'tinymce.themes.mobile.test.ui.TestUi'
  ],

  function (GeneralSteps, Pipeline, GuiSetup, Body, Traverse, TestTheme, TestUi) {
    var success = arguments[arguments.length - 2];
    var failure = arguments[arguments.length - 1];

    /* This test is going to create a toolbar with bold, italic, underline in it */
    var body = Body.body();

    TestTheme.setup({
      container: body,
      items: [ 'link', 'unlink' ]
    }, success, failure).use(
      function (realm, apis, toolbar, socket, buttons, onSuccess, onFailure) {

        var sSetS1 = apis.sSetSelection([ 0, 0 ], 'n'.length, [ 0, 0 ], 'n'.length);
        var sSetS2 = apis.sSetSelection([ 0, 1, 0 ], 'tin'.length, [ 0, 1, 0 ], 'tin'.length);

        var sCheckComponent = function (label, state) {
          return function (memento) {
            return TestUi.sWaitForToggledState(label, state, realm, memento);
          };
        };

        var sCheckS1 = function (situation) {
          return GeneralSteps.sequence([
            sSetS1,
            sCheckLink(situation, false)
          ]);
        };

        var sCheckS2 = function (situation) {
          return GeneralSteps.sequence([
            sSetS2,
            sCheckLink(situation, true)
          ]);
        };

        var sCheckLink = function (situation, expected) {
          return GeneralSteps.sequence([
            sCheckComponent(situation + ' (unlink state)', expected)(buttons.unlink),
            sCheckComponent(situation + ' (link state)', expected)(buttons.link)
          ]);
        };

        Pipeline.async({}, [
          GuiSetup.mAddStyles(Traverse.owner(body), [
            '.tinymce-mobile-toolbar-button { padding: 2px; border: 1px solid black; background: white; }',
            '.tinymce-mobile-toolbar-button.tinymce-mobile-toolbar-button-selected { background: #cadbee; }',
            '.tinymce-mobile-icon-unlink:before { content: "UNLINK"; }',
            '.tinymce-mobile-icon-link:before { content: "LINK"; }'
          ]),
          apis.sFocus,

          apis.sSetContent(
            '<p>no link <a href="www.tinymce.com">tinymce</a></p>'
          ),
          sCheckS1('initial selection in text'),
          sCheckS2('normal >>> link'),
          sCheckS1('link >>> normal'),
          apis.sAssertContentPresence({
            a: 1
          }),

          sSetS2,
          TestUi.sClickComponent(realm, buttons.unlink),
          apis.sAssertContentPresence({
            a: 0
          }),

          // Tinymce moves the cursor after an unlink, so return the selection to the same spot
          apis.sSetSelection([ 0, 1 ], 'for'.length, [ 0, 1 ], 'for'.length),
          sCheckLink('link should be removed', false),
          GuiSetup.mRemoveStyles
        ], onSuccess, onFailure);
      }
    );
  }
);
