
local addon, ns = ...

local locale = GetLocale()

local L = {
    Emote       = { zhTW = "表情", zhCN = "表情" },
    EditBoxPos  = { zhTW = "輸入框位置", zhCN = "输入框位置" },
    Top         = { zhTW = "頂部", zhCN = "顶部" },
    Bottom      = { zhTW = "底部", zhCN = "底部" },
    ChatSwitch  = { zhTW = "快捷頻管理", zhCN = "快捷频管理" },
    ToggleShortName = { zhTW = "顯示簡稱", zhCN = "显示简称" },
    ToggleSwitch    = { zhTW = "顯示快捷", zhCN = "显示快捷" },
    ToogleBackdrop  = { zhTW = "按鈕材質", zhCN = "按钮材质" },
    ToggleDock      = { zhTW = "顯示標簽欄", zhCN = "显示标签栏" },
    ToggleLinkIcon  = { zhTW = "顯示鏈接圖", zhCN = "显示链接图" },
    ToggleChatLevel = { zhTW = "顯示用戶等級", zhCN = "显示用户等级" },
}

TinyChatDB = {
    EditBoxPos = "TOP",
    HideSwitchBackdrop = false,
    HideDockManager = false,
    HideSwitch = false,
    FirstWord = true,
}

-------------------------------------
--增加表情按钮到频道切换框架
-------------------------------------

if (ns.emotes) then 
    tinsert(CHATSWITCH["CUSTOM"], { static=true, default = L["Emote"][locale] or "Emote", func = function(self) ToggleFrame(CustomEmoteFrame) end})
end

-------------------------------------
--整體框架
-------------------------------------

local ChatMainFrame, ChatMainButton

do
    --創建框架
    ChatMainFrame = CreateFrame("Frame", "ChatMainFrame", UIParent)
    ChatMainFrame:SetSize(10, 10)
    ChatMainFrame:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", 0, 0)
    --设置父框架要在PLAYER_LOGIN事件处理
    GeneralDockManager:SetParent(ChatMainFrame)
    ChatFrameMenuButton:SetParent(ChatMainFrame)
    QuickJoinToastButton:SetParent(ChatMainFrame)
    --隱藏顯示按鈕
    ChatMainButton = CreateFrame("Button", "ChatMainButton", UIParent)
    ChatMainButton:SetWidth(24)
    ChatMainButton:SetHeight(24)
    ChatMainButton:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-Maximize-Up")
    ChatMainButton:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-Maximize-Down")
    ChatMainButton:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
    ChatMainButton:SetPoint("BOTTOMLEFT", _G["ChatFrame1"], "TOPLEFT", 4, 50)  --這裡調整位置
    ChatMainButton:SetMovable(true)
	ChatMainButton:SetClampedToScreen(true)
    ChatMainButton:SetFrameStrata("LOW")
    ChatMainButton:SetFrameLevel(GeneralDockManager:GetFrameLevel() + 100)
    ChatMainButton:RegisterForDrag("LeftButton")
    ChatMainButton:RegisterForClicks("LeftButtonUp", "RightButtonUp")
    ChatMainButton:SetScript("OnDragStart", function(self) self:StartMoving() end)
    ChatMainButton:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
    --重设社交按钮
    QuickJoinToastButton:ClearAllPoints()
    QuickJoinToastButton:SetWidth(42)
    QuickJoinToastButton:SetScale(0.58)
    QuickJoinToastButton:SetPoint("LEFT", ChatMainButton, "RIGHT", -2, 0)
    --重設ChatSwitchFrame
    if (ChatSwitchFrame) then
        ChatSwitchFrame:SetParent(ChatMainButton)
        ChatSwitchFrame:ClearAllPoints()
        ChatSwitchFrame:SetPoint("LEFT", ChatMainButton, "LEFT", 44, 0)
    end
    --按鈕點擊事件
    ChatMainButton.dropDown = CreateFrame("Frame", "ChatMainButtonDropDown", ChatMainButton, "UIDropDownMenuTemplate")
    local function OnClick(self, button)
        if (button == "LeftButton") then
            ToggleFrame(ChatMainFrame)
            if (ChatSwitchFrame and not TinyChatDB.HideSwitch) then ToggleFrame(ChatSwitchFrame) end
        elseif (button == "RightButton") then
            ToggleDropDownMenu(1, nil, self.dropDown, self, 24, 24)
        end
    end
    ChatMainButton:SetScript("OnClick", OnClick)
    --輸入框上下調整
    local function TopOrBottom(self)  --調整位置在此處
        local editbox
        local editboxA = "BOTTOM"
        local editboxY = -34
        local buttonY  = 28
        if (self.value == "TOP") then
            editboxA = "TOP"
            editboxY = 22
            buttonY  = 50
            if (not GeneralDockManager:IsShown()) then
                editboxY = editboxY - 20
                buttonY  = buttonY - 20
            end
        end
        for i = 1, NUM_CHAT_WINDOWS do
            editbox = _G["ChatFrame"..i.."EditBox"]
            if (editbox) then
                editbox:ClearAllPoints()
                editbox:SetPoint("BOTTOM", _G["ChatFrame"..i], editboxA, 0, editboxY)
                editbox:SetPoint("LEFT", _G["ChatFrame"..i], 0, 0)
                editbox:SetPoint("RIGHT", _G["ChatFrame"..i], -20, 0)
            end
        end
        if (not self.onlyEditBox) then
            ChatMainButton:ClearAllPoints()
            ChatMainButton:SetPoint("BOTTOMLEFT", _G["ChatFrame1"], "TOPLEFT", 4, buttonY)
        end
        TinyChatDB.EditBoxPos = self.value
    end
    --右鍵下拉菜單
    local function initializeDropMenu(self, level)
        local info
        if (level == 1) then
            --大標題
            info = UIDropDownMenu_CreateInfo()
            info.text = "TinyChat"
            info.notCheckable = true
            info.isTitle = true
            UIDropDownMenu_AddButton(info, 1)
            --Editbox Position
            info = UIDropDownMenu_CreateInfo()
            info.text  = L["EditBoxPos"][locale] or "EditBox Position"
            info.value = "EditBox"
            info.notCheckable = 1
            info.hasArrow = 1
            info.keepShownOnClick = 1
            info.func = nil
            UIDropDownMenu_AddButton(info, level)
            --ChatSwitch Panel
            if (CHATSWITCH and ChatSwitchFrame) then
                info = UIDropDownMenu_CreateInfo()
                info.text  = L["ChatSwitch"][locale] or "ChatSwitch Panel"
                info.value = "ChatSwitch"
                info.notCheckable = 1
                info.hasArrow = 1
                info.keepShownOnClick = 1
                info.func = nil
                UIDropDownMenu_AddButton(info, level)
            end
            --GeneralDockManager
            info = UIDropDownMenu_CreateInfo()
            info.text = L["ToggleDock"][locale] or "Toggle DockManager"
            info.checked = not TinyChatDB.HideDockManager
            info.func = function(self)
                ToggleFrame(GeneralDockManager)
                TinyChatDB.HideDockManager=not GeneralDockManager:IsShown()
                TopOrBottom({value=TinyChatDB.EditBoxPos, onlyEditBox=true})
            end
            UIDropDownMenu_AddButton(info, level)
            --聊天鏈接圖標
            info = UIDropDownMenu_CreateInfo()
            info.text = L["ToggleLinkIcon"][locale] or "Toggle ChatLinkIcon"
            info.checked = not TinyChatDB.hideLinkIcon
            info.func = function(self)
                TinyChatDB.hideLinkIcon = not TinyChatDB.hideLinkIcon
            end
            UIDropDownMenu_AddButton(info, level)
            --顯示等級
            info = UIDropDownMenu_CreateInfo()
            info.text = L["ToggleChatLevel"][locale] or "Toggle ChatLevel"
            info.checked = not TinyChatDB.HideChatLevel
            info.func = function(self)
                TinyChatDB.HideChatLevel = not TinyChatDB.HideChatLevel
                if (ChatLevelFrame and TinyChatDB.HideChatLevel) then
                    ChatLevelFrame:SetScript("OnEvent", nil)
                elseif (ChatLevelFrame) then
                    ChatLevelFrame:SetScript("OnEvent", ChatLevelFrame.OnEvent)
                end
            end
            UIDropDownMenu_AddButton(info, level)
            --表情
            info = UIDropDownMenu_CreateInfo()
            info.text = L["Emote"][locale] or "Emote"
            info.notCheckable = 1
            info.func = function(self) ToggleFrame(CustomEmoteFrame) end
            UIDropDownMenu_AddButton(info, level)
            --取消
            info = UIDropDownMenu_CreateInfo()
            info.text = CANCEL or "cancel"
            info.notCheckable = 1
            info.func = function(self) self:GetParent():Hide() end
            UIDropDownMenu_AddButton(info)
        end
        if (level == 2 and UIDROPDOWNMENU_MENU_VALUE == "EditBox") then
            info = UIDropDownMenu_CreateInfo()
            info.text  = L["Top"][locale] or "Top"
            info.value = "TOP"
            info.notCheckable = 1
            info.func = TopOrBottom
            UIDropDownMenu_AddButton(info, level)
            info = UIDropDownMenu_CreateInfo()
            info.text  = L["Bottom"][locale] or "Bottom"
            info.value = "BOTTOM"
            info.notCheckable = 1
            info.func = TopOrBottom
            UIDropDownMenu_AddButton(info, level)
        end
        if (level == 2 and UIDROPDOWNMENU_MENU_VALUE == "ChatSwitch") then
            --全稱或簡稱
            info = UIDropDownMenu_CreateInfo()
            info.text  = L["ToggleShortName"][locale] or "Toggle ShortName"
            info.value = CHATSWITCH.FirstWord
            info.checked = TinyChatDB.FirstWord
            info.func = function(self)
                if (self.value==1) then
                    CHATSWITCH.FirstWord = 0
                    TinyChatDB.FirstWord = false
                else
                    CHATSWITCH.FirstWord = 1
                    TinyChatDB.FirstWord = true
                end
                ChatSwitchFrame:OnEvent("CUSTOM_EVENT")
            end
            UIDropDownMenu_AddButton(info, level)
            --是否显示材质
            info = UIDropDownMenu_CreateInfo()
            info.text = L["ToogleBackdrop"][locale] or "Toogle Backdrop"
            info.value = CHATSWITCH.ShowBackdrop
            info.checked = not TinyChatDB.HideSwitchBackdrop
            info.func = function(self)
                if (self.value==1) then
                    CHATSWITCH.ShowBackdrop = 0
                    TinyChatDB.HideSwitchBackdrop = true
                else
                    CHATSWITCH.ShowBackdrop = 1
                    TinyChatDB.HideSwitchBackdrop = false
                end
                ChatSwitchFrame:OnEvent("CUSTOM_EVENT")
            end
            UIDropDownMenu_AddButton(info, level)
            --單獨顯隱快捷頻
            info = UIDropDownMenu_CreateInfo()
            info.text  = L["ToggleSwitch"][locale] or "Toggle switch panel"
            info.value = TinyChatDB.HideSwitch and 1 or 0
            info.disabled = not ChatMainFrame:IsShown()
            info.checked = not TinyChatDB.HideSwitch
            info.func = function(self)
                if (self.value==1) then
                    TinyChatDB.HideSwitch = false
                else
                    TinyChatDB.HideSwitch = true
                end
                ToggleFrame(ChatSwitchFrame)
            end
            UIDropDownMenu_AddButton(info, level)
        end
    end
    UIDropDownMenu_Initialize(ChatMainButton.dropDown, initializeDropMenu, "MENU")
    --配置存檔事件
    ChatMainButton:SetScript("OnEvent", function(self, event, ...)
        self:UnregisterAllEvents()
        local chatframe, r, t, p, x, y
        local adjust = select(5, UIParent:GetPoint(2)) or 0
        for i = 1, NUM_CHAT_WINDOWS do
            chatframe = _G["ChatFrame"..i]
            r, t, p, x, y = chatframe:GetPoint()
            chatframe:SetParent(ChatMainFrame)
            chatframe:SetPoint(r, t, p, x, y-adjust)
        end
        if (TinyChatDB.HideDockManager) then
            ToggleFrame(GeneralDockManager)
        end
        if (ChatSwitchFrame) then
            if (TinyChatDB.HideSwitch) then ChatSwitchFrame:Hide() end
            CHATSWITCH.ShowBackdrop = TinyChatDB.HideSwitchBackdrop and 0 or 1
            CHATSWITCH.FirstWord = TinyChatDB.FirstWord and 1 or 0
            ChatSwitchFrame:OnEvent("CUSTOM_EVENT")
        end
        TopOrBottom({value=TinyChatDB.EditBoxPos, onlyEditBox=true})
    end)
    ChatMainButton:RegisterEvent("PLAYER_LOGIN") --考慮到位置重置等各種因素,這裡不用VARIABLES_LOADED
end
