
-------------------------------------
-- 聊天頻道點擊切換
-- Author:M
-------------------------------------

local locale = GetLocale()

local buttonFontSize = locale:sub(1,2) == "zh" and 13 or 11

--不需要顯示的頻道repl寫成空字符或<del>
local channelRules = {
    { locale = "enUS", pat = ".*General.+",          repl = "GEN" },
    { locale = "enUS", pat = ".*Trade.+",            repl = "T"   },
    { locale = "enUS", pat = ".*WorldDefense.*",     repl = "WD"  },
    { locale = "enUS", pat = ".*LocalDefense.+",     repl = "LD"  },
    { locale = "enUS", pat = ".*LookingForGroup.*",  repl = "LFG" },
    { locale = "enUS", pat = ".*GuildRecruitment.*", repl = "GR"  },
    { locale = "zhCN", pat = ".*综合.+",     repl = "综合"  },
    { locale = "zhCN", pat = ".*交易.+",     repl = "交易"  },
    { locale = "zhCN", pat = ".*寻求组队.*", repl = "寻组"  },
    { locale = "zhCN", pat = ".*本地防务.+", repl = "<del>" },
    { locale = "zhCN", pat = ".*世界防务.*", repl = "<del>" },
    { locale = "zhCN", pat = ".*公会招募.*", repl = "<del>" },
    { locale = "zhCN", pat = ".*大脚世界.*", repl = "大脚"  },
    { locale = "zhTW", pat = ".*綜合.+",     repl = "綜合"  },
    { locale = "zhTW", pat = ".*交易.+",     repl = "交易"  },
    { locale = "zhTW", pat = ".*尋求組隊.*", repl = "尋組"  },
    { locale = "zhTW", pat = ".*本地防務.+", repl = "<del>" },
    { locale = "zhTW", pat = ".*世界防務.*", repl = "<del>" },
    { locale = "zhTW", pat = ".*公會招募.*", repl = "<del>" },
}

--全局变量
CHATSWITCH = {
    { TypeInfoKey = "SAY",      default = "S", zhCN = "说", zhTW = "說" },
    { TypeInfoKey = "YELL",     default = "Y", zhCN = "喊话", zhTW = "喊話" },
    { TypeInfoKey = "GUILD",    default = "G", zhCN = "会频", zhTW = "會頻", check = IsInGuild },
    { TypeInfoKey = "OFFICER",  default = "O", zhCN = "官员", zhTW = "幹部", check = CanEditOfficerNote },
    { TypeInfoKey = "PARTY",    default = "P", zhCN = "队伍", zhTW = "隊伍", check = function() return IsInGroup(LE_PARTY_CATEGORY_HOME) end },
    { TypeInfoKey = "RAID",     default = "R", zhCN = "团队", zhTW = "團隊", check = function() return IsInRaid(LE_PARTY_CATEGORY_HOME) end },
    { TypeInfoKey = "INSTANCE_CHAT", default ="I", zhCN = "副本", zhTW = "副本", check = function() return IsInGroup(LE_PARTY_CATEGORY_INSTANCE) end },
    { TypeInfoKey = "CHANNEL1", chanId = 1 },
    { TypeInfoKey = "CHANNEL2", chanId = 2 },
    { TypeInfoKey = "CHANNEL3", chanId = 3 },
    { TypeInfoKey = "CHANNEL4", chanId = 4 },
    { TypeInfoKey = "CHANNEL5", chanId = 5 },
    { TypeInfoKey = "CHANNEL6", chanId = 6 },
    { TypeInfoKey = "CHANNEL7", chanId = 7 },
    { TypeInfoKey = "CHANNEL8", chanId = 8 },
    { TypeInfoKey = "CHANNEL9", chanId = 9 },
    { TypeInfoKey = "CHANNEL10", chanId = 10 },
    CUSTOM = {        --自定义按钮
        { zhCN = "骰", zhTW = "骰", default = "Roll", func = function() RandomRoll(1, 100) end },
    },
    FirstWord = 1,    --是否只顯示首字(英文除外)
    ShowBackdrop = 1, --是否显示按钮背景材质
}

--計算寬度
local function length(s)
    if (string.byte(s) >= 128) then
        return ceil(#s/3)
    else
        return max(1, #s/2)
    end
end

--多字節取第一個
local function word(s)
    local b = string.byte(s)
    if (b >= 240) then
        return s:sub(1, 4)
    elseif (b >= 224) then
        return s:sub(1, 3)
    elseif (b >= 192) then
        return s:sub(1, 2)
    else
        return s
    end
end

--獲取配置的顔色信息
local function getTypeinfoColor(config)
    if (not config.TypeInfoKey) then
        return NORMAL_FONT_COLOR
    elseif (config.color) then
        return config.color
    elseif (config.r and config.g and config.b) then
        return config
    end
    if (ChatTypeInfo[config.TypeInfoKey]) then
        return ChatTypeInfo[config.TypeInfoKey]
    else
        local proxy = getmetatable(ChatTypeInfo).__index
        return proxy[config.TypeInfoKey] or NORMAL_FONT_COLOR
    end
end

--按鈕點擊
local function click(self)
    if (self.func) then
        self.func(self)
    else
        local type = self.TypeInfoKey
        local editBox = ChatEdit_ChooseBoxForSend()
        local i, j = string.find(type, "CHANNEL")
        if (i) then
            editBox:SetAttribute("channelTarget", string.sub(type, j+1))
            type = string.sub(type, i, j)
        end
        editBox:SetAttribute("chatType", type)
        ChatEdit_ActivateChat(editBox)
        editBox:SetText(editBox:GetText())
    end
end

--創建按鈕
local function CreateButton(buttonName, config, index)
    local button, text
    button = CreateFrame("Button", buttonName, _G["ChatSwitchFrame"] or UIParent)
    button:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
    button:SetHeight(config.height or 20)
    button:RegisterForClicks("LeftButtonUp")
    button:SetScript("OnClick", click)
    button.text = button:CreateFontString(nil, "ARTWORK")
    button.text:SetFont(UNIT_NAME_FONT, buttonFontSize, "THINOUTLINE")
    button.text:SetShadowOffset(1, 0)
    button.text:SetShadowColor(0, 0, 0, 0.5)
    button.text:SetPoint("CENTER", button, "CENTER", 1, 0)
    button.text:SetJustifyH("CENTER")
    return button
end

--顯示按鈕
local function ShowButton(index, config)
    local buttonName, button, color, textString, chanId
    --频道需要单独处理名称
    if (config.chanId) then
        chanId, textString = GetChannelName(config.chanId)
        if (chanId < 1) then return false end
        for _, rule in ipairs(channelRules) do
            if (not rule.locale or rule.locale == locale) then
                textString = textString:gsub(rule.pat, rule.repl)
            end
        end
        if (textString == "" or textString == "<del>") then return false end
    else
        textString = config[locale] or config.default
    end
    if (CHATSWITCH.FirstWord == 1 and not config.static) then
        textString = word(textString)
    end
    buttonName = "ChatSwitchButton"..index
    button = _G[buttonName]
    if (not button) then
        button = CreateButton(buttonName, config, index)
        if (index == 1) then
            button:SetPoint("LEFT", button:GetParent(), "LEFT", 4, 0)
        else
            button:SetPoint("LEFT", _G["ChatSwitchButton"..(index-1)], "RIGHT", 3, 0)
        end
    end
    button.TextString  = textString
    button.TypeInfoKey = config.TypeInfoKey
    button:SetWidth(config.width or length(textString) * 20)
    button.text:SetWidth(button:GetWidth())
    button.text:SetText(textString)
    color = getTypeinfoColor(config)
    if (CHATSWITCH.ShowBackdrop == 1) then
        button:SetBackdrop({
          bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
          edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 8,
          insets = { left = 2, right = 2, top = 2, bottom = 2 }
        })
        button:SetBackdropColor(0, 0, 0, 0.3)
        button:SetBackdropBorderColor(color.r, color.g, color.b, 0.3)
    else
        button:SetBackdrop(nil)
    end
    button.text:SetTextColor(color.r, color.g, color.b)
    button.func = config.func
    button:Show()
    return true
end

--渲染數據
local function render()
    local index = 1
    for _, config in ipairs(CHATSWITCH) do
        if (not config.check or config.check()) then
            if (ShowButton(index, config)) then
                index = index + 1
            end
        end
    end
    for _, config in ipairs(CHATSWITCH.CUSTOM) do
        ShowButton(index, config)
        index = index + 1
    end
    while (_G["ChatSwitchButton"..index]) do
        _G["ChatSwitchButton"..index]:Hide()
        index = index + 1
    end
end

--事件註冊
local ChatSwitchFrame = CreateFrame("Frame", "ChatSwitchFrame", UIParent)
ChatSwitchFrame:SetSize(24,24)
ChatSwitchFrame:SetPoint("BOTTOMLEFT", _G["ChatFrame1"], "TOPLEFT", 10, 24)  --調整位置的地方
ChatSwitchFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
ChatSwitchFrame:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")
ChatSwitchFrame:RegisterEvent("GROUP_ROSTER_UPDATE")
ChatSwitchFrame.OnEvent = function(self, event, ...)
    local inRaid = IsInRaid(LE_PARTY_CATEGORY_HOME)
    local inParty = IsInGroup(LE_PARTY_CATEGORY_HOME)
    local inInstace = IsInGroup(LE_PARTY_CATEGORY_INSTANCE)
    if (self.inParty ~= inParty or self.inRaid ~= inRaid or self.inInstace ~= inInstace
        or event == "CUSTOM_EVENT"   -- 自定義事件名
        or event == "PLAYER_ENTERING_WORLD"
        or event == "CHAT_MSG_CHANNEL_NOTICE") then
        self.inRaid = inRaid
        self.inParty = inParty
        self.inInstace = inInstace
        render()
    end
end
ChatSwitchFrame:SetScript("OnEvent", ChatSwitchFrame.OnEvent)
